/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsContext;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class URLAndHash {
    protected String url;
    protected byte[] sha1Hash;

    public URLAndHash(String string, byte[] byArray) {
        if (TlsUtils.isNullOrEmpty(string) || string.length() >= 65536) {
            throw new IllegalArgumentException("'url' must have length from 1 to (2^16 - 1)");
        }
        if (byArray != null && byArray.length != 20) {
            throw new IllegalArgumentException("'sha1Hash' must have length == 20, if present");
        }
        this.url = string;
        this.sha1Hash = byArray;
    }

    public String getURL() {
        return this.url;
    }

    public byte[] getSHA1Hash() {
        return this.sha1Hash;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray = Strings.toByteArray(this.url);
        TlsUtils.writeOpaque16(byArray, outputStream);
        if (this.sha1Hash == null) {
            TlsUtils.writeUint8(0, outputStream);
        } else {
            TlsUtils.writeUint8(1, outputStream);
            outputStream.write(this.sha1Hash);
        }
    }

    public static URLAndHash parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(inputStream, 1);
        String string = Strings.fromByteArray(byArray);
        byte[] byArray2 = null;
        short s2 = TlsUtils.readUint8(inputStream);
        switch (s2) {
            case 0: {
                if (!TlsUtils.isTLSv12(tlsContext)) break;
                throw new TlsFatalAlert(47);
            }
            case 1: {
                byArray2 = TlsUtils.readFully(20, inputStream);
                break;
            }
            default: {
                throw new TlsFatalAlert(47);
            }
        }
        return new URLAndHash(string, byArray2);
    }
}

