/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigitallySigned;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.Tls13Verifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsVerifier;
import java.io.IOException;
import java.io.OutputStream;

public final class LegacyTls13Verifier
implements TlsVerifier {
    private final int signatureScheme;
    private final Tls13Verifier tls13Verifier;

    public LegacyTls13Verifier(int n, Tls13Verifier tls13Verifier) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException("'signatureScheme'");
        }
        if (tls13Verifier == null) {
            throw new NullPointerException("'tls13Verifier' cannot be null");
        }
        this.signatureScheme = n;
        this.tls13Verifier = tls13Verifier;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        byte[] byArray = digitallySigned.getSignature();
        return new TlsStreamVerifier(){

            @Override
            public OutputStream getOutputStream() throws IOException {
                return LegacyTls13Verifier.this.tls13Verifier.getOutputStream();
            }

            @Override
            public boolean isVerified() throws IOException {
                return LegacyTls13Verifier.this.tls13Verifier.verifySignature(byArray);
            }
        };
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }
}

