/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Encodable;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1Primitive;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.Certificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.Extension;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.Extensions;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.KeyUsage;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsRawKeyCertificate;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsCertificate
extends BcTlsRawKeyCertificate {
    protected final Certificate certificate;

    public static BcTlsCertificate convert(BcTlsCrypto bcTlsCrypto, TlsCertificate tlsCertificate) throws IOException {
        if (tlsCertificate instanceof BcTlsCertificate) {
            return (BcTlsCertificate)tlsCertificate;
        }
        return new BcTlsCertificate(bcTlsCrypto, tlsCertificate.getEncoded());
    }

    public static Certificate parseCertificate(byte[] byArray) throws IOException {
        try {
            ASN1Primitive aSN1Primitive = TlsUtils.readASN1Object(byArray);
            return Certificate.getInstance(aSN1Primitive);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TlsFatalAlert(42, (Throwable)illegalArgumentException);
        }
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, byte[] byArray) throws IOException {
        this(bcTlsCrypto, BcTlsCertificate.parseCertificate(byArray));
    }

    public BcTlsCertificate(BcTlsCrypto bcTlsCrypto, Certificate certificate) {
        super(bcTlsCrypto, certificate.getSubjectPublicKeyInfo());
        this.certificate = certificate;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return this.certificate.getEncoded("DER");
    }

    @Override
    public byte[] getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException {
        Extension extension;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        if (extensions != null && (extension = extensions.getExtension(aSN1ObjectIdentifier)) != null) {
            return Arrays.clone(extension.getExtnValue().getOctets());
        }
        return null;
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.certificate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgOID() {
        return this.certificate.getSignatureAlgorithm().getAlgorithm().getId();
    }

    @Override
    public ASN1Encodable getSigAlgParams() {
        return this.certificate.getSignatureAlgorithm().getParameters();
    }

    @Override
    protected boolean supportsKeyUsage(int n) {
        int n2;
        KeyUsage keyUsage;
        Extensions extensions = this.certificate.getTBSCertificate().getExtensions();
        return extensions == null || (keyUsage = KeyUsage.fromExtensions(extensions)) == null || ((n2 = keyUsage.getBytes()[0] & 0xFF) & n) == n;
    }
}

