/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.ec.CustomNamedCurves;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECPoint;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.NamedGroup;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECDomain;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final TlsECConfig config;
    protected final ECDomainParameters domainParameters;

    public static BcTlsSecret calculateECDHAgreement(BcTlsCrypto bcTlsCrypto, ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters eCPublicKeyParameters) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init(eCPrivateKeyParameters);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(eCPublicKeyParameters);
        byte[] byArray = BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), bigInteger);
        return bcTlsCrypto.adoptLocalSecret(byArray);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig tlsECConfig) {
        return BcTlsECDomain.getDomainParameters(tlsECConfig.getNamedGroup());
    }

    public static ECDomainParameters getDomainParameters(int n) {
        if (!NamedGroup.refersToASpecificCurve(n)) {
            return null;
        }
        String string = NamedGroup.getCurveName(n);
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName(string)) == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto bcTlsCrypto, TlsECConfig tlsECConfig) {
        this.crypto = bcTlsCrypto;
        this.config = tlsECConfig;
        this.domainParameters = BcTlsECDomain.getDomainParameters(tlsECConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters eCPrivateKeyParameters, ECPublicKeyParameters eCPublicKeyParameters) {
        return BcTlsECDomain.calculateECDHAgreement(this.crypto, eCPrivateKeyParameters, eCPublicKeyParameters);
    }

    @Override
    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] byArray) {
        return this.domainParameters.getCurve().decodePoint(byArray);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] byArray) throws IOException {
        try {
            ECPoint eCPoint = this.decodePoint(byArray);
            return new ECPublicKeyParameters(eCPoint, this.domainParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public byte[] encodePoint(ECPoint eCPoint) {
        return eCPoint.getEncoded(false);
    }

    public byte[] encodePublicKey(ECPublicKeyParameters eCPublicKeyParameters) {
        return this.encodePoint(eCPublicKeyParameters.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(this.domainParameters, this.crypto.getSecureRandom()));
        return eCKeyPairGenerator.generateKeyPair();
    }
}

