/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPrivateKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsMLKemDomain;
import java.io.IOException;

public class BcTlsMLKem
implements TlsAgreement {
    protected final BcTlsMLKemDomain domain;
    protected KyberPrivateKeyParameters privateKey;
    protected KyberPublicKeyParameters publicKey;
    protected TlsSecret secret;

    public BcTlsMLKem(BcTlsMLKemDomain bcTlsMLKemDomain) {
        this.domain = bcTlsMLKemDomain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        if (this.domain.isServer()) {
            SecretWithEncapsulation secretWithEncapsulation = this.domain.encapsulate(this.publicKey);
            this.publicKey = null;
            this.secret = this.domain.adoptLocalSecret(secretWithEncapsulation.getSecret());
            return secretWithEncapsulation.getEncapsulation();
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.domain.generateKeyPair();
        this.privateKey = (KyberPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return this.domain.encodePublicKey((KyberPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        if (this.domain.isServer()) {
            this.publicKey = this.domain.decodePublicKey(byArray);
        } else {
            this.secret = this.domain.decapsulate(this.privateKey, byArray);
            this.privateKey = null;
        }
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        TlsSecret tlsSecret = this.secret;
        this.secret = null;
        return tlsSecret;
    }
}

