/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.InvalidCipherTextException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsEncryptor;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import java.io.IOException;

final class BcTlsRSAEncryptor
implements TlsEncryptor {
    private final BcTlsCrypto crypto;
    private final RSAKeyParameters pubKeyRSA;

    private static RSAKeyParameters checkPublicKey(RSAKeyParameters rSAKeyParameters) {
        if (null == rSAKeyParameters || rSAKeyParameters.isPrivate()) {
            throw new IllegalArgumentException("No public RSA key provided");
        }
        return rSAKeyParameters;
    }

    BcTlsRSAEncryptor(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters) {
        this.crypto = bcTlsCrypto;
        this.pubKeyRSA = BcTlsRSAEncryptor.checkPublicKey(rSAKeyParameters);
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n, int n2) throws IOException {
        try {
            PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
            pKCS1Encoding.init(true, new ParametersWithRandom(this.pubKeyRSA, this.crypto.getSecureRandom()));
            return pKCS1Encoding.processBlock(byArray, n, n2);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
        }
    }
}

