/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.Digest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.engines.RSAEngine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.PSSSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigitallySigned;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;
import java.io.IOException;

public class BcTlsRSAPSSVerifier
extends BcTlsVerifier {
    private final int signatureScheme;

    public BcTlsRSAPSSVerifier(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, int n) {
        super(bcTlsCrypto, rSAKeyParameters);
        if (!SignatureScheme.isRSAPSS(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = n;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        Digest digest = this.crypto.createDigest(n);
        PSSSigner pSSSigner = PSSSigner.createRawSigner(new RSAEngine(), digest);
        pSSSigner.init(false, this.publicKey);
        pSSSigner.update(byArray, 0, byArray.length);
        return pSSSigner.verifySignature(digitallySigned.getSignature());
    }
}

