/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.digests.NullDigest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.GenericSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsRSASigner
extends BcTlsSigner {
    private final RSAKeyParameters publicKey;

    public BcTlsRSASigner(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters, RSAKeyParameters rSAKeyParameters2) {
        super(bcTlsCrypto, rSAKeyParameters);
        this.publicKey = rSAKeyParameters2;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        if (signatureAndHashAlgorithm != null) {
            if (signatureAndHashAlgorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(byArray, 0, byArray.length);
        try {
            byte[] byArray2 = signer.generateSignature();
            signer.init(false, this.publicKey);
            signer.update(byArray, 0, byArray.length);
            if (signer.verifySignature(byArray2)) {
                return byArray2;
            }
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
        throw new TlsFatalAlert(80);
    }
}

