/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.digests.NullDigest;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.GenericSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigitallySigned;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(BcTlsCrypto bcTlsCrypto, RSAKeyParameters rSAKeyParameters) {
        super(bcTlsCrypto, rSAKeyParameters);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) {
        Signer signer;
        NullDigest nullDigest = new NullDigest();
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null) {
            if (signatureAndHashAlgorithm.getSignature() != 1) {
                throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(false, this.publicKey);
        signer.update(byArray, 0, byArray.length);
        return signer.verifySignature(digitallySigned.getSignature());
    }
}

