/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.CryptoException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.Signer;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.crypto.io.SignerOutputStream;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.io.TeeOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class BcVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signer signer;
    private final Signer verifier;
    private final TeeOutputStream output;

    BcVerifyingStreamSigner(Signer signer, Signer signer2) {
        SignerOutputStream signerOutputStream = new SignerOutputStream(signer);
        SignerOutputStream signerOutputStream2 = new SignerOutputStream(signer2);
        this.signer = signer;
        this.verifier = signer2;
        this.output = new TeeOutputStream(signerOutputStream, signerOutputStream2);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    @Override
    public byte[] getSignature() throws IOException {
        try {
            byte[] byArray = this.signer.generateSignature();
            if (this.verifier.verifySignature(byArray)) {
                return byArray;
            }
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
        throw new TlsFatalAlert(80);
    }
}

