/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.rfc7748.X25519;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class BcX25519
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[32];
    protected final byte[] peerPublicKey = new byte[32];

    public BcX25519(BcTlsCrypto bcTlsCrypto) {
        this.crypto = bcTlsCrypto;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] byArray = new byte[32];
        X25519.scalarMultBase(this.privateKey, 0, byArray, 0);
        return byArray;
    }

    @Override
    public void receivePeerValue(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 32) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(byArray, 0, this.peerPublicKey, 0, 32);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] byArray = new byte[32];
            if (!X25519.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, byArray, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(byArray);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

