/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureScheme;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class JcaTlsECDSA13Signer
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final int signatureScheme;

    public JcaTlsECDSA13Signer(JcaTlsCrypto jcaTlsCrypto, PrivateKey privateKey, int n) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == privateKey) {
            throw new NullPointerException("privateKey");
        }
        if (!SignatureScheme.isECDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.crypto = jcaTlsCrypto;
        this.privateKey = privateKey;
        this.signatureScheme = n;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        try {
            Signature signature = this.crypto.getHelper().createSignature("NoneWithECDSA");
            signature.initSign(this.privateKey, this.crypto.getSecureRandom());
            signature.update(byArray, 0, byArray.length);
            return signature.sign();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsFatalAlert(80, (Throwable)generalSecurityException);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        return null;
    }
}

