/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.DERNull;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.DigestInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DigitallySigned;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsVerifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;

public class JcaTlsRSAVerifier
implements TlsVerifier {
    private final JcaTlsCrypto crypto;
    private final PublicKey publicKey;
    private Signature rawVerifier = null;

    public JcaTlsRSAVerifier(JcaTlsCrypto jcaTlsCrypto, PublicKey publicKey) {
        if (null == jcaTlsCrypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = jcaTlsCrypto;
        this.publicKey = publicKey;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned digitallySigned) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive() && this.isSunMSCAPIRawVerifier()) {
            return this.crypto.createStreamVerifier(digitallySigned, this.publicKey);
        }
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned digitallySigned, byte[] byArray) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = digitallySigned.getAlgorithm();
        try {
            Signature signature = this.getRawVerifier();
            if (signatureAndHashAlgorithm != null) {
                if (signatureAndHashAlgorithm.getSignature() != 1) {
                    throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
                }
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(signatureAndHashAlgorithm.getHash()), DERNull.INSTANCE);
                byte[] byArray2 = new DigestInfo(algorithmIdentifier, byArray).getEncoded();
                signature.update(byArray2, 0, byArray2.length);
            } else {
                signature.update(byArray, 0, byArray.length);
            }
            return signature.verify(digitallySigned.getSignature());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to process signature: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    protected Signature getRawVerifier() throws GeneralSecurityException {
        if (this.rawVerifier == null) {
            this.rawVerifier = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawVerifier.initVerify(this.publicKey);
        }
        return this.rawVerifier;
    }

    protected boolean isSunMSCAPIRawVerifier() throws IOException {
        try {
            Signature signature = this.getRawVerifier();
            return JcaUtils.isSunMSCAPIProvider(signature.getProvider());
        }
        catch (GeneralSecurityException generalSecurityException) {
            return true;
        }
    }
}

