/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECCurve;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.math.ec.ECPoint;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.NamedGroup;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoException;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsECDomain;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.Exceptions;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsECDH;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JceTlsSecret;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;

public class JceTlsECDomain
implements TlsECDomain {
    protected final JcaTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECParameterSpec ecSpec;
    protected final ECCurve ecCurve;

    public JceTlsECDomain(JcaTlsCrypto jcaTlsCrypto, TlsECConfig tlsECConfig) {
        ECParameterSpec eCParameterSpec;
        int n = tlsECConfig.getNamedGroup();
        if (NamedGroup.refersToAnECDSACurve(n) && null != (eCParameterSpec = ECUtil.getECParameterSpec(jcaTlsCrypto, NamedGroup.getCurveName(n)))) {
            this.crypto = jcaTlsCrypto;
            this.ecConfig = tlsECConfig;
            this.ecSpec = eCParameterSpec;
            this.ecCurve = ECUtil.convertCurve(eCParameterSpec.getCurve(), eCParameterSpec.getOrder(), eCParameterSpec.getCofactor());
            return;
        }
        throw new IllegalArgumentException("NamedGroup not supported: " + NamedGroup.getText(n));
    }

    public JceTlsSecret calculateECDHAgreement(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        try {
            byte[] byArray = this.crypto.calculateKeyAgreement("ECDH", privateKey, publicKey, "TlsPremasterSecret");
            return this.crypto.adoptLocalSecret(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new TlsCryptoException("cannot calculate secret", generalSecurityException);
        }
    }

    @Override
    public TlsAgreement createECDH() {
        return new JceTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] byArray) throws IOException {
        return this.ecCurve.decodePoint(byArray);
    }

    public PublicKey decodePublicKey(byte[] byArray) throws IOException {
        try {
            ECPoint eCPoint = this.decodePoint(byArray).normalize();
            BigInteger bigInteger = eCPoint.getAffineXCoord().toBigInteger();
            BigInteger bigInteger2 = eCPoint.getAffineYCoord().toBigInteger();
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new java.security.spec.ECPoint(bigInteger, bigInteger2), this.ecSpec);
            KeyFactory keyFactory = this.crypto.getHelper().createKeyFactory("EC");
            return keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    public byte[] encodePoint(ECPoint eCPoint) throws IOException {
        return eCPoint.getEncoded(false);
    }

    public byte[] encodePublicKey(PublicKey publicKey) throws IOException {
        if (publicKey instanceof com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jce.interfaces.ECPublicKey) {
            return this.encodePoint(((com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jce.interfaces.ECPublicKey)publicKey).getQ());
        }
        if (publicKey instanceof ECPublicKey) {
            java.security.spec.ECPoint eCPoint = ((ECPublicKey)publicKey).getW();
            return this.encodePoint(this.ecCurve.createPoint(eCPoint.getAffineX(), eCPoint.getAffineY()));
        }
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
        return subjectPublicKeyInfo.getPublicKeyData().getOctets();
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = this.crypto.getHelper().createKeyPairGenerator("EC");
            keyPairGenerator.initialize(this.ecSpec, this.crypto.getSecureRandom());
            return keyPairGenerator.generateKeyPair();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Exceptions.illegalStateException("unable to create key pair: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }
}

