/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsCryptoUtils;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.TlsHMAC;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class JceTlsHMAC
implements TlsHMAC {
    private final Mac hmac;
    private final String algorithm;
    private final int internalBlockSize;

    public JceTlsHMAC(int n, Mac mac, String string) {
        this.hmac = mac;
        this.algorithm = string;
        this.internalBlockSize = TlsCryptoUtils.getHashInternalSize(n);
    }

    @Override
    public void setKey(byte[] byArray, int n, int n2) {
        try {
            this.hmac.init(new SecretKeySpec(byArray, n, n2, this.algorithm));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException.getMessage());
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.hmac.update(byArray, n, n2);
    }

    @Override
    public byte[] calculateMAC() {
        return this.hmac.doFinal();
    }

    @Override
    public void calculateMAC(byte[] byArray, int n) {
        try {
            this.hmac.doFinal(byArray, n);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IllegalArgumentException(shortBufferException.getMessage());
        }
    }

    @Override
    public int getInternalBlockSize() {
        return this.internalBlockSize;
    }

    @Override
    public int getMacLength() {
        return this.hmac.getMacLength();
    }

    @Override
    public void reset() {
        this.hmac.reset();
    }
}

