/*
 * Decompiled with CFR 0.152.
 */
package com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.interfaces.XDHPublicKey;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jcajce.spec.RawEncodedKeySpec;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.TlsFatalAlert;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;

class XDHUtil {
    XDHUtil() {
    }

    static PublicKey decodePublicKey(JcaTlsCrypto jcaTlsCrypto, String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws TlsFatalAlert {
        try {
            KeyFactory keyFactory = jcaTlsCrypto.getHelper().createKeyFactory(string);
            if (keyFactory.getProvider() instanceof BouncyCastleProvider) {
                try {
                    RawEncodedKeySpec rawEncodedKeySpec = new RawEncodedKeySpec(byArray);
                    return keyFactory.generatePublic(rawEncodedKeySpec);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X509EncodedKeySpec x509EncodedKeySpec = XDHUtil.createX509EncodedKeySpec(aSN1ObjectIdentifier, byArray);
            return keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(47, (Throwable)exception);
        }
    }

    static byte[] encodePublicKey(PublicKey publicKey) throws TlsFatalAlert {
        if (publicKey instanceof XDHPublicKey) {
            return ((XDHPublicKey)publicKey).getUEncoding();
        }
        if (!"X.509".equals(publicKey.getFormat())) {
            throw new TlsFatalAlert(80, "Public key format unrecognized");
        }
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            return subjectPublicKeyInfo.getPublicKeyData().getOctets();
        }
        catch (Exception exception) {
            throw new TlsFatalAlert(80, (Throwable)exception);
        }
    }

    private static X509EncodedKeySpec createX509EncodedKeySpec(ASN1ObjectIdentifier aSN1ObjectIdentifier, byte[] byArray) throws IOException {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier);
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, byArray);
        return new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded("DER"));
    }
}

