/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.executor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.content.StreamedHttpContent;
import net.lenni0451.commons.httpclient.executor.RequestExecutor;
import net.lenni0451.commons.httpclient.proxy.SingleProxySelector;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.utils.HttpRequestUtils;
import net.lenni0451.commons.httpclient.utils.IgnoringTrustManager;

public class URLConnectionExecutor
extends RequestExecutor {
    public URLConnectionExecutor(HttpClient client) {
        super(client);
    }

    @Override
    @Nonnull
    public HttpResponse execute(@Nonnull HttpRequest request) throws IOException {
        CookieManager cookieManager = this.getCookieManager(request);
        HttpURLConnection connection = this.openConnection(request, cookieManager);
        return this.executeRequest(connection, cookieManager, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection openConnection(HttpRequest request, CookieManager cookieManager) throws IOException {
        SingleProxySelector proxySelector = null;
        if (this.client.getProxyHandler().isProxySet()) {
            proxySelector = this.client.getProxyHandler().getProxySelector();
        }
        try {
            if (proxySelector != null) {
                proxySelector.set();
            }
            URL url = request.getURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (this.isIgnoreInvalidSSL(request) && connection instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
                httpsConnection.setSSLSocketFactory(IgnoringTrustManager.makeIgnoringSSLContext().getSocketFactory());
            }
            this.setupConnection(connection, cookieManager, request);
            connection.connect();
            HttpURLConnection httpURLConnection = connection;
            return httpURLConnection;
        }
        finally {
            if (proxySelector != null) {
                proxySelector.reset();
            }
        }
    }

    private void setupConnection(HttpURLConnection connection, @Nullable CookieManager cookieManager, HttpRequest request) throws IOException {
        HttpRequestUtils.setHeaders(connection, this.getHeaders(request, cookieManager));
        HttpContentRequest contentRequest = request instanceof HttpContentRequest ? (HttpContentRequest)request : null;
        HttpContent content = contentRequest != null ? contentRequest.getContent() : null;
        connection.setConnectTimeout(this.client.getConnectTimeout());
        connection.setReadTimeout(this.client.getReadTimeout());
        connection.setRequestMethod(request.getMethod());
        connection.setDoInput(true);
        if (contentRequest != null && content != null) {
            connection.setDoOutput(true);
            if (content instanceof StreamedHttpContent) {
                connection.setFixedLengthStreamingMode(content.getContentLength());
            }
        } else {
            connection.setDoOutput(false);
        }
        switch (request.getFollowRedirects()) {
            case NOT_SET: {
                connection.setInstanceFollowRedirects(this.client.isFollowRedirects());
                break;
            }
            case FOLLOW: {
                connection.setInstanceFollowRedirects(true);
                break;
            }
            case IGNORE: {
                connection.setInstanceFollowRedirects(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeRequest(HttpURLConnection connection, @Nullable CookieManager cookieManager, HttpRequest request) throws IOException {
        boolean closeConnection = true;
        try {
            HttpResponse response;
            Object body;
            if (connection.getDoOutput()) {
                HttpContent content = ((HttpContentRequest)request).getContent();
                OutputStream os = connection.getOutputStream();
                if (content instanceof StreamedHttpContent) {
                    int read;
                    StreamedHttpContent streamedContent = (StreamedHttpContent)content;
                    InputStream is = streamedContent.getInputStream();
                    byte[] buffer = new byte[streamedContent.getBufferSize()];
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    is.close();
                } else {
                    os.write(content.getAsBytes());
                }
                os.flush();
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(connection.getHeaderFields());
            headers.remove(null);
            if (request.isStreamedResponse()) {
                body = HttpRequestUtils.getInputStream(connection);
                response = new HttpResponse(request.getURL(), connection.getResponseCode(), (InputStream)body, headers);
                closeConnection = false;
            } else {
                body = HttpRequestUtils.readBody(connection);
                response = new HttpResponse(request.getURL(), connection.getResponseCode(), (byte[])body, headers);
            }
            HttpRequestUtils.updateCookies(cookieManager, request.getURL(), connection.getHeaderFields());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (closeConnection) {
                connection.disconnect();
            }
        }
    }
}

