/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2i;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.Vector4l;
import org.cloudburstmc.math.vector.VectorNi;
import org.cloudburstmc.math.vector.Vectori;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector4i
implements Vectori,
Comparable<Vector4i>,
Serializable,
Cloneable {
    public static final Vector4i ZERO = Vector4i.from(0, 0, 0, 0);
    public static final Vector4i UNIT_X = Vector4i.from(1, 0, 0, 0);
    public static final Vector4i UNIT_Y = Vector4i.from(0, 1, 0, 0);
    public static final Vector4i UNIT_Z = Vector4i.from(0, 0, 1, 0);
    public static final Vector4i UNIT_W = Vector4i.from(0, 0, 0, 1);
    public static final Vector4i ONE = Vector4i.from(1, 1, 1, 1);

    public abstract int getX();

    public abstract int getY();

    public abstract int getZ();

    public abstract int getW();

    @Nonnull
    public Vector4i add(Vector4i v) {
        return this.add(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i add(double x, double y, double z, double w) {
        return this.add(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i add(int var1, int var2, int var3, int var4);

    @Nonnull
    public Vector4i sub(Vector4i v) {
        return this.sub(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i sub(double x, double y, double z, double w) {
        return this.sub(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i sub(int var1, int var2, int var3, int var4);

    @Nonnull
    public Vector4i mul(double a) {
        return this.mul(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector4i mul(int a) {
        return this.mul(a, a, a, a);
    }

    @Nonnull
    public Vector4i mul(Vector4i v) {
        return this.mul(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i mul(double x, double y, double z, double w) {
        return this.mul(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i mul(int var1, int var2, int var3, int var4);

    @Nonnull
    public Vector4i div(double a) {
        return this.div(GenericMath.floor(a));
    }

    @Override
    @Nonnull
    public Vector4i div(int a) {
        return this.div(a, a, a, a);
    }

    @Nonnull
    public Vector4i div(Vector4i v) {
        return this.div(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i div(double x, double y, double z, double w) {
        return this.div(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i div(int var1, int var2, int var3, int var4);

    public int dot(Vector4i v) {
        return this.dot(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public int dot(double x, double y, double z, double w) {
        return this.dot(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    public int dot(int x, int y, int z, int w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector4i project(Vector4i v) {
        return this.project(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i project(double x, double y, double z, double w) {
        return this.project(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i project(int var1, int var2, int var3, int var4);

    @Nonnull
    public Vector4i pow(double pow) {
        return this.pow(GenericMath.floor(pow));
    }

    @Override
    @Nonnull
    public abstract Vector4i pow(int var1);

    @Override
    @Nonnull
    public abstract Vector4i abs();

    @Override
    @Nonnull
    public abstract Vector4i negate();

    @Nonnull
    public Vector4i min(Vector4i v) {
        return this.min(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i min(double x, double y, double z, double w) {
        return this.min(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i min(int var1, int var2, int var3, int var4);

    @Nonnull
    public Vector4i max(Vector4i v) {
        return this.max(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4i max(double x, double y, double z, double w) {
        return this.max(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public abstract Vector4i max(int var1, int var2, int var3, int var4);

    public int distanceSquared(Vector4i v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public int distanceSquared(double x, double y, double z, double w) {
        return this.distanceSquared(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    public int distanceSquared(int x, int y, int z, int w) {
        int dx = this.getX() - x;
        int dy = this.getY() - y;
        int dz = this.getZ() - z;
        int dw = this.getW() - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public float distance(Vector4i v) {
        return this.distance(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public float distance(double x, double y, double z, double w) {
        return this.distance(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    public float distance(int x, int y, int z, int w) {
        return (float)Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    @Override
    public int lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        int value2 = this.getX();
        int axis = 0;
        if (this.getY() < value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() < value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() < value2) {
            axis = 3;
        }
        return axis;
    }

    @Override
    public int getMaxAxis() {
        int value2 = this.getX();
        int axis = 0;
        if (this.getY() > value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() > value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() > value2) {
            axis = 3;
        }
        return axis;
    }

    @Nonnull
    public Vector2i toVector2() {
        return Vector2i.from(this);
    }

    @Nonnull
    public Vector3i toVector3() {
        return Vector3i.from(this);
    }

    @Nonnull
    public VectorNi toVectorN() {
        return VectorNi.from(this);
    }

    @Override
    @Nonnull
    public int[] toArray() {
        return new int[]{this.getX(), this.getY(), this.getZ(), this.getW()};
    }

    @Override
    @Nonnull
    public Vector4i toInt() {
        return Vector4i.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4l toLong() {
        return Vector4l.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4f toFloat() {
        return Vector4f.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4d toDouble() {
        return Vector4d.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Vector4i v) {
        return this.lengthSquared() - v.lengthSquared();
    }

    @Nonnull
    public Vector4i clone() {
        return Vector4i.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Vector4i from(int n) {
        return Vectors.createVector4i(n, n, n, n);
    }

    @Nonnull
    public static Vector4i from(Vector2i v) {
        return Vector4i.from(v, 0, 0);
    }

    @Nonnull
    public static Vector4i from(Vector2i v, double z, double w) {
        return Vector4i.from(v, GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public static Vector4i from(Vector2i v, int z, int w) {
        return Vector4i.from(v.getX(), v.getY(), z, w);
    }

    @Nonnull
    public static Vector4i from(Vector3i v) {
        return Vector4i.from(v, 0);
    }

    @Nonnull
    public static Vector4i from(Vector3i v, int w) {
        return Vector4i.from(v.getX(), v.getY(), v.getZ(), w);
    }

    @Nonnull
    public static Vector4i from(Vector4i v) {
        return Vector4i.from(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public static Vector4i from(VectorNi v) {
        return Vector4i.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0, v.size() > 3 ? v.get(3) : 0);
    }

    @Nonnull
    public static Vector4i from(double x, double y, double z, double w) {
        return Vector4i.from(GenericMath.floor(x), GenericMath.floor(y), GenericMath.floor(z), GenericMath.floor(w));
    }

    @Nonnull
    public static Vector4i from(int x, int y, int z, int w) {
        return Vectors.createVector4i(x, y, z, w);
    }
}

