/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.math.vector;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.cloudburstmc.math.GenericMath;
import org.cloudburstmc.math.vector.Vector2l;
import org.cloudburstmc.math.vector.Vector3l;
import org.cloudburstmc.math.vector.Vector4d;
import org.cloudburstmc.math.vector.Vector4f;
import org.cloudburstmc.math.vector.Vector4i;
import org.cloudburstmc.math.vector.VectorNl;
import org.cloudburstmc.math.vector.Vectorl;
import org.cloudburstmc.math.vector.Vectors;

@ParametersAreNonnullByDefault
@Immutable
public abstract class Vector4l
implements Vectorl,
Comparable<Vector4l>,
Serializable,
Cloneable {
    public static final Vector4l ZERO = Vector4l.from(0L, 0L, 0L, 0L);
    public static final Vector4l UNIT_X = Vector4l.from(1L, 0L, 0L, 0L);
    public static final Vector4l UNIT_Y = Vector4l.from(0L, 1L, 0L, 0L);
    public static final Vector4l UNIT_Z = Vector4l.from(0L, 0L, 1L, 0L);
    public static final Vector4l UNIT_W = Vector4l.from(0L, 0L, 0L, 1L);
    public static final Vector4l ONE = Vector4l.from(1L, 1L, 1L, 1L);

    public abstract long getX();

    public abstract long getY();

    public abstract long getZ();

    public abstract long getW();

    @Nonnull
    public Vector4l add(Vector4l v) {
        return this.add(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l add(double x, double y, double z, double w) {
        return this.add(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l add(long var1, long var3, long var5, long var7);

    @Nonnull
    public Vector4l sub(Vector4l v) {
        return this.sub(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l sub(double x, double y, double z, double w) {
        return this.sub(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l sub(long var1, long var3, long var5, long var7);

    @Nonnull
    public Vector4l mul(double a) {
        return this.mul(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector4l mul(long a) {
        return this.mul(a, a, a, a);
    }

    @Nonnull
    public Vector4l mul(Vector4l v) {
        return this.mul(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l mul(double x, double y, double z, double w) {
        return this.mul(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l mul(long var1, long var3, long var5, long var7);

    @Nonnull
    public Vector4l div(double a) {
        return this.div(GenericMath.floor64(a));
    }

    @Override
    @Nonnull
    public Vector4l div(long a) {
        return this.div(a, a, a, a);
    }

    @Nonnull
    public Vector4l div(Vector4l v) {
        return this.div(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l div(double x, double y, double z, double w) {
        return this.div(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l div(long var1, long var3, long var5, long var7);

    public long dot(Vector4l v) {
        return this.dot(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public long dot(double x, double y, double z, double w) {
        return this.dot(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    public long dot(long x, long y, long z, long w) {
        return this.getX() * x + this.getY() * y + this.getZ() * z + this.getW() * w;
    }

    @Nonnull
    public Vector4l project(Vector4l v) {
        return this.project(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l project(double x, double y, double z, double w) {
        return this.project(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l project(long var1, long var3, long var5, long var7);

    @Nonnull
    public Vector4l pow(double pow) {
        return this.pow(GenericMath.floor64(pow));
    }

    @Override
    @Nonnull
    public abstract Vector4l pow(long var1);

    @Override
    @Nonnull
    public abstract Vector4l abs();

    @Override
    @Nonnull
    public abstract Vector4l negate();

    @Nonnull
    public Vector4l min(Vector4l v) {
        return this.min(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l min(double x, double y, double z, double w) {
        return this.min(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l min(long var1, long var3, long var5, long var7);

    @Nonnull
    public Vector4l max(Vector4l v) {
        return this.max(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public Vector4l max(double x, double y, double z, double w) {
        return this.max(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public abstract Vector4l max(long var1, long var3, long var5, long var7);

    public long distanceSquared(Vector4l v) {
        return this.distanceSquared(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public long distanceSquared(double x, double y, double z, double w) {
        return this.distanceSquared(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    public long distanceSquared(long x, long y, long z, long w) {
        long dx = this.getX() - x;
        long dy = this.getY() - y;
        long dz = this.getZ() - z;
        long dw = this.getW() - w;
        return dx * dx + dy * dy + dz * dz + dw * dw;
    }

    public double distance(Vector4l v) {
        return this.distance(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    public double distance(double x, double y, double z, double w) {
        return this.distance(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    public double distance(long x, long y, long z, long w) {
        return Math.sqrt(this.distanceSquared(x, y, z, w));
    }

    @Override
    public long lengthSquared() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ() + this.getW() * this.getW();
    }

    @Override
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Override
    public int getMinAxis() {
        long value2 = this.getX();
        int axis = 0;
        if (this.getY() < value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() < value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() < value2) {
            axis = 3;
        }
        return axis;
    }

    @Override
    public int getMaxAxis() {
        long value2 = this.getX();
        int axis = 0;
        if (this.getY() > value2) {
            value2 = this.getY();
            axis = 1;
        }
        if (this.getZ() > value2) {
            value2 = this.getZ();
            axis = 2;
        }
        if (this.getW() > value2) {
            axis = 3;
        }
        return axis;
    }

    @Nonnull
    public Vector2l toVector2() {
        return Vector2l.from(this);
    }

    @Nonnull
    public Vector3l toVector3() {
        return Vector3l.from(this);
    }

    @Nonnull
    public VectorNl toVectorN() {
        return VectorNl.from(this);
    }

    @Override
    @Nonnull
    public long[] toArray() {
        return new long[]{this.getX(), this.getY(), this.getZ(), this.getW()};
    }

    @Override
    @Nonnull
    public Vector4i toInt() {
        return Vector4i.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4l toLong() {
        return Vector4l.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4f toFloat() {
        return Vector4f.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    @Nonnull
    public Vector4d toDouble() {
        return Vector4d.from(this.getX(), this.getY(), this.getZ(), this.getW());
    }

    @Override
    public int compareTo(Vector4l v) {
        return (int)(this.lengthSquared() - v.lengthSquared());
    }

    @Nonnull
    public Vector4l clone() {
        return Vector4l.from(this);
    }

    @Nonnull
    public String toString() {
        return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ", " + this.getW() + ")";
    }

    @Nonnull
    public static Vector4l from(long n) {
        return Vectors.createVector4l(n, n, n, n);
    }

    @Nonnull
    public static Vector4l from(Vector2l v) {
        return Vector4l.from(v, 0L, 0L);
    }

    @Nonnull
    public static Vector4l from(Vector2l v, double z, double w) {
        return Vector4l.from(v, GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public static Vector4l from(Vector2l v, long z, long w) {
        return Vector4l.from(v.getX(), v.getY(), z, w);
    }

    @Nonnull
    public static Vector4l from(Vector3l v) {
        return Vector4l.from(v, 0L);
    }

    @Nonnull
    public static Vector4l from(Vector3l v, long w) {
        return Vector4l.from(v.getX(), v.getY(), v.getZ(), w);
    }

    @Nonnull
    public static Vector4l from(Vector4l v) {
        return Vector4l.from(v.getX(), v.getY(), v.getZ(), v.getW());
    }

    @Nonnull
    public static Vector4l from(VectorNl v) {
        return Vector4l.from(v.get(0), v.get(1), v.size() > 2 ? v.get(2) : 0L, v.size() > 3 ? v.get(3) : 0L);
    }

    @Nonnull
    public static Vector4l from(double x, double y, double z, double w) {
        return Vector4l.from(GenericMath.floor64(x), GenericMath.floor64(y), GenericMath.floor64(z), GenericMath.floor64(w));
    }

    @Nonnull
    public static Vector4l from(long x, long y, long z, long w) {
        return Vectors.createVector4l(x, y, z, w);
    }
}

