/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.netty.channel.raknet.config;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import java.util.Map;
import org.cloudburstmc.netty.channel.raknet.RakConstants;
import org.cloudburstmc.netty.channel.raknet.config.DefaultRakSessionConfig;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelConfig;
import org.cloudburstmc.netty.channel.raknet.config.RakChannelOption;
import org.cloudburstmc.netty.channel.raknet.config.RakServerChannelConfig;
import org.cloudburstmc.netty.util.IpDontFragmentProvider;

public class DefaultRakClientConfig
extends DefaultRakSessionConfig {
    private volatile ByteBuf unconnectedMagic = Unpooled.wrappedBuffer(RakConstants.DEFAULT_UNCONNECTED_MAGIC);
    private volatile long connectTimeout = 10000L;
    private volatile long sessionTimeout = 10000L;
    private volatile long serverGuid;
    private volatile boolean compatibilityMode = false;
    private volatile Integer[] mtuSizes = RakConstants.MTU_SIZES;
    private volatile boolean ipDontFragment = false;
    private volatile int clientInternalAddresses = 10;
    private volatile int timeBetweenSendConnectionAttemptsMS = 1000;

    public DefaultRakClientConfig(Channel channel) {
        super(channel);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), RakChannelOption.RAK_UNCONNECTED_MAGIC, RakChannelOption.RAK_CONNECT_TIMEOUT, RakChannelOption.RAK_REMOTE_GUID, RakChannelOption.RAK_SESSION_TIMEOUT, RakChannelOption.RAK_COMPATIBILITY_MODE, RakChannelOption.RAK_MTU_SIZES, RakChannelOption.RAK_IP_DONT_FRAGMENT, RakChannelOption.RAK_CLIENT_INTERNAL_ADDRESSES, RakChannelOption.RAK_TIME_BETWEEN_SEND_CONNECTION_ATTEMPTS_MS);
    }

    @Override
    public <T> T getOption(ChannelOption<T> option) {
        if (option == RakChannelOption.RAK_UNCONNECTED_MAGIC) {
            return (T)this.getUnconnectedMagic();
        }
        if (option == RakChannelOption.RAK_CONNECT_TIMEOUT) {
            return (T)Long.valueOf(this.getConnectTimeout());
        }
        if (option == RakChannelOption.RAK_REMOTE_GUID) {
            return (T)Long.valueOf(this.getServerGuid());
        }
        if (option == RakChannelOption.RAK_SESSION_TIMEOUT) {
            return (T)Long.valueOf(this.getSessionTimeout());
        }
        if (option == RakChannelOption.RAK_COMPATIBILITY_MODE) {
            return (T)Boolean.valueOf(this.isCompatibilityMode());
        }
        if (option == RakChannelOption.RAK_MTU_SIZES) {
            return (T)this.getMtuSizes();
        }
        if (option == RakChannelOption.RAK_IP_DONT_FRAGMENT) {
            return (T)Boolean.valueOf(this.ipDontFragment);
        }
        if (option == RakChannelOption.RAK_CLIENT_INTERNAL_ADDRESSES) {
            return (T)Integer.valueOf(this.clientInternalAddresses);
        }
        if (option == RakChannelOption.RAK_TIME_BETWEEN_SEND_CONNECTION_ATTEMPTS_MS) {
            return (T)Integer.valueOf(this.timeBetweenSendConnectionAttemptsMS);
        }
        return super.getOption(option);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> option, T value2) {
        this.validate(option, value2);
        if (option == RakChannelOption.RAK_UNCONNECTED_MAGIC) {
            this.setUnconnectedMagic((ByteBuf)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_CONNECT_TIMEOUT) {
            this.setConnectTimeout((Long)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_REMOTE_GUID) {
            this.setServerGuid((Long)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_SESSION_TIMEOUT) {
            this.setSessionTimeout((Long)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_COMPATIBILITY_MODE) {
            this.setCompatibilityMode((Boolean)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_MTU_SIZES) {
            this.setMtuSizes((Integer[])value2);
            return true;
        }
        if (option == RakChannelOption.RAK_IP_DONT_FRAGMENT) {
            this.setIpDontFragment((Boolean)value2);
            return ((Boolean)value2).booleanValue() == this.isIpDontFragment();
        }
        if (option == RakChannelOption.RAK_CLIENT_INTERNAL_ADDRESSES) {
            this.setClientInternalAddresses((Integer)value2);
            return true;
        }
        if (option == RakChannelOption.RAK_TIME_BETWEEN_SEND_CONNECTION_ATTEMPTS_MS) {
            this.setTimeBetweenSendConnectionAttemptsMS((Integer)value2);
            return true;
        }
        return super.setOption(option, value2);
    }

    public ByteBuf getUnconnectedMagic() {
        return this.unconnectedMagic.slice();
    }

    public RakServerChannelConfig setUnconnectedMagic(ByteBuf unconnectedMagic) {
        if (unconnectedMagic.readableBytes() < 16) {
            throw new IllegalArgumentException("Unconnect magic must at least be 16 bytes");
        }
        this.unconnectedMagic = unconnectedMagic.copy().asReadOnly();
        return null;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public DefaultRakClientConfig setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public long getServerGuid() {
        return this.serverGuid;
    }

    public DefaultRakClientConfig setServerGuid(long serverGuid) {
        this.serverGuid = serverGuid;
        return this;
    }

    @Override
    public RakChannelConfig setSessionTimeout(long timeout2) {
        this.sessionTimeout = timeout2;
        return this;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean enable) {
        this.compatibilityMode = enable;
    }

    public Integer[] getMtuSizes() {
        return (Integer[])this.mtuSizes.clone();
    }

    public void setMtuSizes(Integer[] mtuSizes) {
        this.mtuSizes = (Integer[])mtuSizes.clone();
    }

    public boolean isIpDontFragment() {
        return this.ipDontFragment;
    }

    public void setIpDontFragment(boolean enable) {
        this.ipDontFragment = IpDontFragmentProvider.trySet(this.channel, enable);
    }

    public int getClientInternalAddresses() {
        return this.clientInternalAddresses;
    }

    public void setClientInternalAddresses(int clientInternalAddresses) {
        this.clientInternalAddresses = clientInternalAddresses;
    }

    public int getTimeBetweenSendConnectionAttemptsMS() {
        return this.timeBetweenSendConnectionAttemptsMS;
    }

    public void setTimeBetweenSendConnectionAttemptsMS(int timeBetweenSendConnectionAttemptsMS) {
        this.timeBetweenSendConnectionAttemptsMS = timeBetweenSendConnectionAttemptsMS;
    }
}

