/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.common.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import java.util.function.ObjIntConsumer;
import org.cloudburstmc.protocol.common.util.Preconditions;

public class Int2ObjectBiMap<T> {
    private final Int2ObjectMap<T> forwards;
    private final Object2IntMap<T> backwards;

    public Int2ObjectBiMap() {
        this(2);
    }

    public Int2ObjectBiMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public Int2ObjectBiMap(T noEntryValue) {
        this(2, 0.5f, -1, noEntryValue);
    }

    public Int2ObjectBiMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, -1);
    }

    public Int2ObjectBiMap(int initialCapacity, float loadFactor, int noEntryKey) {
        this(initialCapacity, loadFactor, noEntryKey, null);
    }

    public Int2ObjectBiMap(int initialCapacity, float loadFactor, int noEntryKey, T noEntryValue) {
        this.forwards = new Int2ObjectOpenHashMap<T>(initialCapacity, loadFactor);
        this.backwards = new Object2IntOpenHashMap<T>(initialCapacity, loadFactor);
        this.forwards.defaultReturnValue(noEntryValue);
        this.backwards.defaultReturnValue(noEntryKey);
    }

    public T get(int key) {
        Object value2 = this.forwards.get(key);
        if (value2 == null) {
            value2 = this.forwards.defaultReturnValue();
        }
        return (T)value2;
    }

    public int get(T value2) {
        return this.backwards.get(value2);
    }

    public void put(int key, T value2) {
        Preconditions.checkNotNull(value2, "value");
        this.forwards.put(key, value2);
        this.backwards.put(value2, key);
    }

    public boolean containsKey(int key) {
        return this.forwards.containsKey(key);
    }

    public boolean containsValue(T value2) {
        return this.forwards.containsValue(value2);
    }

    public boolean remove(int key) {
        if (!this.forwards.containsKey(key)) {
            return false;
        }
        Object value2 = this.forwards.get(key);
        if (!this.backwards.containsKey(value2)) {
            return false;
        }
        this.forwards.remove(key);
        this.backwards.removeInt(value2);
        return true;
    }

    public boolean remove(T t) {
        if (!this.backwards.containsKey(t)) {
            return false;
        }
        int value2 = this.backwards.getInt(t);
        if (!this.forwards.containsKey(value2)) {
            return false;
        }
        this.backwards.removeInt(t);
        this.forwards.remove(value2);
        return true;
    }

    public void forEach(ObjIntConsumer<T> consumer) {
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(this.forwards)) {
            consumer.accept(entry.getValue(), entry.getIntKey());
        }
    }

    public int hashCode() {
        return this.forwards.hashCode();
    }

    public String toString() {
        return this.forwards.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Int2ObjectBiMap that = (Int2ObjectBiMap)o;
        return Objects.equals(this.forwards, that.forwards) && Objects.equals(this.backwards, that.backwards);
    }
}

