/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.AwsCandidateHarvester;
import org.ice4j.ice.harvest.HarvestConfig;
import org.ice4j.ice.harvest.HostCandidateHarvester;
import org.ice4j.ice.harvest.MappingCandidateHarvester;
import org.ice4j.ice.harvest.StaticMappingCandidateHarvester;
import org.ice4j.ice.harvest.StunMappingCandidateHarvester;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.concurrent.ExecutorFactory;

public class MappingCandidateHarvesters {
    private static final Logger logger = Logger.getLogger(MappingCandidateHarvesters.class.getName());
    private static boolean initialized = false;
    private static MappingCandidateHarvester[] harvesters = new MappingCandidateHarvester[0];
    public static boolean stunDiscoveryFailed = false;

    public static MappingCandidateHarvester[] getHarvesters() {
        MappingCandidateHarvesters.initialize();
        return harvesters;
    }

    public static MappingCandidateHarvester findHarvesterForAddress(TransportAddress publicAddress) {
        for (MappingCandidateHarvester harvester : harvesters) {
            if (!harvester.publicAddressMatches(publicAddress)) continue;
            return harvester;
        }
        return null;
    }

    public static synchronized void initialize() {
        List<String> list;
        if (initialized) {
            return;
        }
        initialized = true;
        long start = System.currentTimeMillis();
        List<MappingCandidateHarvester> harvesterList = new LinkedList<MappingCandidateHarvester>();
        for (HarvestConfig.StaticMapping staticMapping : HarvestConfig.config.getStaticMappings()) {
            logger.info("Adding a static mapping: " + staticMapping);
            int localPort = staticMapping.getLocalPort() != null ? staticMapping.getLocalPort() : 9;
            int publicPort = staticMapping.getPublicPort() != null ? staticMapping.getPublicPort() : 9;
            TransportAddress localAddress = new TransportAddress(staticMapping.getLocalAddress(), localPort, Transport.UDP);
            TransportAddress publicAddress = new TransportAddress(staticMapping.getPublicAddress(), publicPort, Transport.UDP);
            harvesterList.add(new StaticMappingCandidateHarvester(publicAddress, localAddress, staticMapping.getName(), staticMapping.getLocalPort() != null));
        }
        boolean enableAwsHarvester2 = HarvestConfig.config.enableAwsHarvester();
        if (enableAwsHarvester2 && (HarvestConfig.config.forceAwsHarvester() || AwsCandidateHarvester.smellsLikeAnEC2())) {
            logger.info("Using AwsCandidateHarvester.");
            harvesterList.add(new AwsCandidateHarvester());
        }
        if (!(list = HarvestConfig.config.stunMappingCandidateHarvesterAddresses()).isEmpty()) {
            List<StunMappingCandidateHarvester> stunHarvesters = MappingCandidateHarvesters.createStunHarvesters(list);
            stunDiscoveryFailed = stunHarvesters.isEmpty();
            harvesterList.addAll(stunHarvesters);
        }
        harvesterList = MappingCandidateHarvesters.prune(harvesterList);
        for (MappingCandidateHarvester harvester : harvesters = harvesterList.toArray(new MappingCandidateHarvester[harvesterList.size()])) {
            logger.info("Using " + harvester);
        }
        logger.info("Initialized mapping harvesters (delay=" + (System.currentTimeMillis() - start) + "ms).  stunDiscoveryFailed=" + stunDiscoveryFailed);
    }

    private static List<MappingCandidateHarvester> prune(List<MappingCandidateHarvester> harvesters) {
        LinkedList<MappingCandidateHarvester> pruned = new LinkedList<MappingCandidateHarvester>();
        for (MappingCandidateHarvester harvester : harvesters) {
            MappingCandidateHarvesters.maybeAdd(harvester, pruned);
        }
        return pruned;
    }

    private static void maybeAdd(MappingCandidateHarvester harvester, List<MappingCandidateHarvester> harvesters) {
        TransportAddress face = harvester.getFace();
        TransportAddress mask = harvester.getMask();
        if (face == null || mask == null || face.equals(mask)) {
            logger.info("Discarding a mapping harvester: " + harvester);
            return;
        }
        for (MappingCandidateHarvester h : harvesters) {
            if (!face.getAddress().equals(h.getFace().getAddress()) || !mask.getAddress().equals(h.getMask().getAddress())) continue;
            logger.info("Discarding a mapping harvester with duplicate addresses: " + harvester + ". Kept: " + h);
            return;
        }
        harvesters.add(harvester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<StunMappingCandidateHarvester> createStunHarvesters(@NotNull List<String> stunServers) {
        LinkedList<StunMappingCandidateHarvester> stunHarvesters = new LinkedList<StunMappingCandidateHarvester>();
        LinkedList<Callable<StunMappingCandidateHarvester>> tasks = new LinkedList<Callable<StunMappingCandidateHarvester>>();
        List<InetAddress> localAddresses = HostCandidateHarvester.getAllAllowedAddresses();
        for (String stunServer : stunServers) {
            int port;
            String[] addressAndPort = stunServer.split(":");
            if (addressAndPort.length < 2) {
                logger.severe("Failed to parse STUN server address: " + stunServer);
                continue;
            }
            try {
                port = Integer.parseInt(addressAndPort[1]);
            }
            catch (NumberFormatException nfe) {
                logger.severe("Invalid STUN server port: " + addressAndPort[1]);
                continue;
            }
            TransportAddress remoteAddress = new TransportAddress(addressAndPort[0], port, Transport.UDP);
            for (InetAddress localInetAddress : localAddresses) {
                if (localInetAddress instanceof Inet6Address) continue;
                TransportAddress localAddress = new TransportAddress(localInetAddress, 0, Transport.UDP);
                logger.info("Using " + remoteAddress + " for StunMappingCandidateHarvester (localAddress=" + localAddress + ").");
                StunMappingCandidateHarvester stunHarvester = new StunMappingCandidateHarvester(localAddress, remoteAddress);
                Callable<StunMappingCandidateHarvester> task = () -> {
                    stunHarvester.discover();
                    return stunHarvester;
                };
                tasks.add(task);
            }
        }
        if (tasks.isEmpty()) {
            logger.warning("STUN mapping harvesters are configured, but no allowed local addresses were found. Not using STUN.");
            return stunHarvesters;
        }
        ExecutorService es = ExecutorFactory.createFixedThreadPool(tasks.size(), "ice4j.Harvester-executor-");
        try {
            List futures;
            try {
                futures = es.invokeAll(tasks);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LinkedList<StunMappingCandidateHarvester> port = stunHarvesters;
                es.shutdown();
                return port;
            }
            for (Future future : futures) {
                try {
                    StunMappingCandidateHarvester harvester = (StunMappingCandidateHarvester)future.get();
                    if (harvester.getMask() == null) continue;
                    stunHarvesters.add(harvester);
                }
                catch (ExecutionException harvester) {
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                    return stunHarvesters;
                }
            }
        }
        finally {
            es.shutdown();
        }
    }

    private MappingCandidateHarvesters() {
    }
}

