/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.stats;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.AtomicExtensionsKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.Buckets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0002'(B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0004J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u00020!2\b\b\u0002\u0010$\u001a\u00020%H\u0017R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jitsi/utils/stats/BucketStats;", "", "thresholds", "", "", "averageMaxMinLabel", "", "bucketLabel", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "average", "", "getAverage", "()D", "getAverageMaxMinLabel", "()Ljava/lang/String;", "getBucketLabel", "buckets", "Lorg/jitsi/utils/stats/Buckets;", "discarded", "Ljava/util/concurrent/atomic/LongAdder;", "maxValue", "Ljava/util/concurrent/atomic/AtomicLong;", "minValue", "snapshot", "Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "getSnapshot", "()Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "totalCount", "totalValue", "addValue", "", "value", "getBucketsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "b", "Lorg/jitsi/utils/stats/Buckets$Snapshot;", "format", "Lorg/jitsi/utils/stats/BucketStats$Format;", "toJson", "Format", "Snapshot", "jitsi-utils"})
@SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="False positive with kotlin's 'when'.")
@SourceDebugExtension(value={"SMAP\nBucketStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BucketStats.kt\norg/jitsi/utils/stats/BucketStats\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n13309#2,2:225\n13309#2,2:228\n1#3:227\n1855#4,2:230\n*S KotlinDebug\n*F\n+ 1 BucketStats.kt\norg/jitsi/utils/stats/BucketStats\n*L\n102#1:225,2\n111#1:228,2\n123#1:230,2\n*E\n"})
public class BucketStats {
    @NotNull
    private final String averageMaxMinLabel;
    @NotNull
    private final String bucketLabel;
    @NotNull
    private final LongAdder totalValue;
    @NotNull
    private final LongAdder totalCount;
    @NotNull
    private final AtomicLong maxValue;
    @NotNull
    private final AtomicLong minValue;
    @NotNull
    private final Buckets buckets;
    @NotNull
    private final LongAdder discarded;

    public BucketStats(@NotNull List<Long> thresholds, @NotNull String averageMaxMinLabel, @NotNull String bucketLabel) {
        Intrinsics.checkNotNullParameter(thresholds, (String)"thresholds");
        Intrinsics.checkNotNullParameter((Object)averageMaxMinLabel, (String)"averageMaxMinLabel");
        Intrinsics.checkNotNullParameter((Object)bucketLabel, (String)"bucketLabel");
        this.averageMaxMinLabel = averageMaxMinLabel;
        this.bucketLabel = bucketLabel;
        if (thresholds.size() < 2) {
            throw new IllegalArgumentException("At least 2 thresholds are required.");
        }
        if (!Intrinsics.areEqual(thresholds, (Object)CollectionsKt.sorted((Iterable)thresholds))) {
            throw new IllegalArgumentException("Thresholds must be sorted: " + CollectionsKt.joinToString$default((Iterable)thresholds, null, null, null, (int)0, null, null, (int)63, null));
        }
        this.totalValue = new LongAdder();
        this.totalCount = new LongAdder();
        this.maxValue = new AtomicLong(0L);
        this.minValue = new AtomicLong(0L);
        this.buckets = new Buckets(thresholds);
        this.discarded = new LongAdder();
    }

    public /* synthetic */ BucketStats(List list, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        this(list, string, string2);
    }

    @NotNull
    public final String getAverageMaxMinLabel() {
        return this.averageMaxMinLabel;
    }

    @NotNull
    public final String getBucketLabel() {
        return this.bucketLabel;
    }

    private final double getAverage() {
        return (double)this.totalValue.sum() / (double)this.totalCount.sum();
    }

    public final void addValue(long value2) {
        this.totalValue.add(value2);
        AtomicExtensionsKt.maxAssign(this.maxValue, value2);
        AtomicExtensionsKt.minAssign(this.minValue, value2);
        this.totalCount.increment();
        if (!this.buckets.addValue(value2)) {
            this.discarded.increment();
        }
    }

    @JvmOverloads
    @NotNull
    public OrderedJsonObject toJson(@NotNull Format format) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Snapshot snapshot = this.getSnapshot();
        $this$toJson_u24lambda_u240.put("average" + this.averageMaxMinLabel, (Object)snapshot.getAverage());
        $this$toJson_u24lambda_u240.put("max" + this.averageMaxMinLabel, (Object)snapshot.getMaxValue());
        $this$toJson_u24lambda_u240.put("min" + this.averageMaxMinLabel, (Object)snapshot.getMinValue());
        $this$toJson_u24lambda_u240.put("total_value", (Object)snapshot.getTotalValue());
        $this$toJson_u24lambda_u240.put("total_count", (Object)snapshot.getTotalCount());
        $this$toJson_u24lambda_u240.put("discarded", (Object)this.discarded.sum());
        $this$toJson_u24lambda_u240.put("buckets", this.getBucketsJson(snapshot.getBuckets(), format));
        return orderedJsonObject;
    }

    public static /* synthetic */ OrderedJsonObject toJson$default(BucketStats bucketStats, Format format, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toJson");
        }
        if ((n & 1) != 0) {
            format = Format.Separate;
        }
        return bucketStats.toJson(format);
    }

    @NotNull
    public final Snapshot getSnapshot() {
        return new Snapshot(this.getAverage(), this.maxValue.get(), this.minValue.get(), this.totalValue.sum(), this.totalCount.sum(), this.buckets.getSnapshot());
    }

    @NotNull
    public OrderedJsonObject getBucketsJson(@NotNull Buckets.Snapshot b, @NotNull Format format) {
        OrderedJsonObject orderedJsonObject;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        OrderedJsonObject $this$getBucketsJson_u24lambda_u246 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                Pair<Pair<Long, Long>, Long>[] $this$forEach$iv = b.getBuckets();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Pair<Pair<Long, Long>, Long> element$iv;
                    Pair<Pair<Long, Long>, Long> it = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    String f = ((Number)((Pair)it.getFirst()).getFirst()).longValue() == Long.MIN_VALUE ? "min" : String.valueOf(((Number)((Pair)it.getFirst()).getFirst()).longValue());
                    String s2 = ((Number)((Pair)it.getFirst()).getSecond()).longValue() == Long.MAX_VALUE ? "max" : String.valueOf(((Number)((Pair)it.getFirst()).getSecond()).longValue());
                    String key = f + "_to_" + s2;
                    ((Map)$this$getBucketsJson_u24lambda_u246).put(key + this.bucketLabel, it.getSecond());
                }
                break;
            }
            case 2: {
                long sum = 0L;
                long it = ((Number)((Pair)((Pair)ArraysKt.first((Object[])b.getBuckets())).getFirst()).getFirst()).longValue();
                int n = 0;
                String f = it == Long.MIN_VALUE ? "min" : String.valueOf(it);
                Pair<Pair<Long, Long>, Long>[] $this$forEach$iv = b.getBuckets();
                boolean $i$f$forEach = false;
                n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Pair<Pair<Long, Long>, Long> element$iv;
                    Pair<Pair<Long, Long>, Long> it2 = element$iv = $this$forEach$iv[i];
                    boolean bl3 = false;
                    if (((Number)((Pair)it2.getFirst()).getSecond()).longValue() == Long.MAX_VALUE) continue;
                    String s3 = String.valueOf(((Number)((Pair)it2.getFirst()).getSecond()).longValue());
                    String key = f + "_to_" + s3;
                    ((Map)$this$getBucketsJson_u24lambda_u246).put(key + this.bucketLabel, sum += ((Number)it2.getSecond()).longValue());
                }
                break;
            }
            case 3: {
                long sum = 0L;
                long it = ((Number)((Pair)((Pair)ArraysKt.last((Object[])b.getBuckets())).getFirst()).getSecond()).longValue();
                boolean bl4 = false;
                String s4 = it == Long.MAX_VALUE ? "max" : String.valueOf(it);
                Iterable $this$forEach$iv = ArraysKt.reversed((Object[])b.getBuckets());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it3 = (Pair)element$iv;
                    boolean bl5 = false;
                    if (((Number)((Pair)it3.getFirst()).getFirst()).longValue() == Long.MIN_VALUE) continue;
                    String f = String.valueOf(((Number)((Pair)it3.getFirst()).getFirst()).longValue());
                    String key = f + "_to_" + s4;
                    ((Map)$this$getBucketsJson_u24lambda_u246).put(key + this.bucketLabel, sum += ((Number)it3.getSecond()).longValue());
                }
                break;
            }
        }
        $this$getBucketsJson_u24lambda_u246.put("p99_upper_bound", (Object)b.getP99bound());
        $this$getBucketsJson_u24lambda_u246.put("p999_upper_bound", (Object)b.getP999bound());
        return orderedJsonObject;
    }

    @JvmOverloads
    @NotNull
    public final OrderedJsonObject toJson() {
        return BucketStats.toJson$default(this, null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/utils/stats/BucketStats$Format;", "", "(Ljava/lang/String;I)V", "Separate", "CumulativeLeft", "CumulativeRight", "jitsi-utils"})
    public static final class Format
    extends Enum<Format> {
        public static final /* enum */ Format Separate = new Format();
        public static final /* enum */ Format CumulativeLeft = new Format();
        public static final /* enum */ Format CumulativeRight = new Format();
        private static final /* synthetic */ Format[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Format[] values() {
            return (Format[])$VALUES.clone();
        }

        public static Format valueOf(String value2) {
            return Enum.valueOf(Format.class, value2);
        }

        @NotNull
        public static EnumEntries<Format> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = formatArray = new Format[]{Format.Separate, Format.CumulativeLeft, Format.CumulativeRight};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006#"}, d2={"Lorg/jitsi/utils/stats/BucketStats$Snapshot;", "", "average", "", "maxValue", "", "minValue", "totalValue", "totalCount", "buckets", "Lorg/jitsi/utils/stats/Buckets$Snapshot;", "(DJJJJLorg/jitsi/utils/stats/Buckets$Snapshot;)V", "getAverage", "()D", "getBuckets", "()Lorg/jitsi/utils/stats/Buckets$Snapshot;", "getMaxValue", "()J", "getMinValue", "getTotalCount", "getTotalValue", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-utils"})
    public static final class Snapshot {
        private final double average;
        private final long maxValue;
        private final long minValue;
        private final long totalValue;
        private final long totalCount;
        @NotNull
        private final Buckets.Snapshot buckets;

        public Snapshot(double average, long maxValue, long minValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
            this.average = average;
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.totalValue = totalValue;
            this.totalCount = totalCount;
            this.buckets = buckets;
        }

        public final double getAverage() {
            return this.average;
        }

        public final long getMaxValue() {
            return this.maxValue;
        }

        public final long getMinValue() {
            return this.minValue;
        }

        public final long getTotalValue() {
            return this.totalValue;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot getBuckets() {
            return this.buckets;
        }

        public final double component1() {
            return this.average;
        }

        public final long component2() {
            return this.maxValue;
        }

        public final long component3() {
            return this.minValue;
        }

        public final long component4() {
            return this.totalValue;
        }

        public final long component5() {
            return this.totalCount;
        }

        @NotNull
        public final Buckets.Snapshot component6() {
            return this.buckets;
        }

        @NotNull
        public final Snapshot copy(double average, long maxValue, long minValue, long totalValue, long totalCount, @NotNull Buckets.Snapshot buckets) {
            Intrinsics.checkNotNullParameter((Object)buckets, (String)"buckets");
            return new Snapshot(average, maxValue, minValue, totalValue, totalCount, buckets);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, double d, long l, long l2, long l3, long l4, Buckets.Snapshot snapshot2, int n, Object object) {
            if ((n & 1) != 0) {
                d = snapshot.average;
            }
            if ((n & 2) != 0) {
                l = snapshot.maxValue;
            }
            if ((n & 4) != 0) {
                l2 = snapshot.minValue;
            }
            if ((n & 8) != 0) {
                l3 = snapshot.totalValue;
            }
            if ((n & 0x10) != 0) {
                l4 = snapshot.totalCount;
            }
            if ((n & 0x20) != 0) {
                snapshot2 = snapshot.buckets;
            }
            return snapshot.copy(d, l, l2, l3, l4, snapshot2);
        }

        @NotNull
        public String toString() {
            return "Snapshot(average=" + this.average + ", maxValue=" + this.maxValue + ", minValue=" + this.minValue + ", totalValue=" + this.totalValue + ", totalCount=" + this.totalCount + ", buckets=" + this.buckets + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.average);
            result = result * 31 + Long.hashCode(this.maxValue);
            result = result * 31 + Long.hashCode(this.minValue);
            result = result * 31 + Long.hashCode(this.totalValue);
            result = result * 31 + Long.hashCode(this.totalCount);
            result = result * 31 + this.buckets.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)other;
            if (Double.compare(this.average, snapshot.average) != 0) {
                return false;
            }
            if (this.maxValue != snapshot.maxValue) {
                return false;
            }
            if (this.minValue != snapshot.minValue) {
                return false;
            }
            if (this.totalValue != snapshot.totalValue) {
                return false;
            }
            if (this.totalCount != snapshot.totalCount) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buckets, (Object)snapshot.buckets);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Format.values().length];
            try {
                nArray[Format.Separate.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.CumulativeLeft.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Format.CumulativeRight.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

