/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.json.internal.json_simple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONAware;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.json.internal.json_simple.JSONStreamAware;
import org.jose4j.json.internal.json_simple.parser.JSONParser;
import org.jose4j.json.internal.json_simple.parser.ParseException;

public class JSONValue {
    public static Object parse(Reader in) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s2) {
        StringReader in = new StringReader(s2);
        return JSONValue.parse(in);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }

    public static void writeJSONString(Object value2, Writer out) throws IOException {
        if (value2 == null) {
            out.write("null");
            return;
        }
        if (value2 instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value2));
            out.write(34);
            return;
        }
        if (value2 instanceof Double) {
            if (((Double)value2).isInfinite() || ((Double)value2).isNaN()) {
                out.write("null");
            } else {
                out.write(value2.toString());
            }
            return;
        }
        if (value2 instanceof Float) {
            if (((Float)value2).isInfinite() || ((Float)value2).isNaN()) {
                out.write("null");
            } else {
                out.write(value2.toString());
            }
            return;
        }
        if (value2 instanceof Number) {
            out.write(value2.toString());
            return;
        }
        if (value2 instanceof Boolean) {
            out.write(value2.toString());
            return;
        }
        if (value2 instanceof JSONStreamAware) {
            ((JSONStreamAware)value2).writeJSONString(out);
            return;
        }
        if (value2 instanceof JSONAware) {
            out.write(((JSONAware)value2).toJSONString());
            return;
        }
        if (value2 instanceof Map) {
            JSONObject.writeJSONString((Map)value2, out);
            return;
        }
        if (value2 instanceof Collection) {
            JSONArray.writeJSONString((Collection)value2, out);
            return;
        }
        if (value2 instanceof byte[]) {
            JSONArray.writeJSONString((byte[])value2, out);
            return;
        }
        if (value2 instanceof short[]) {
            JSONArray.writeJSONString((short[])value2, out);
            return;
        }
        if (value2 instanceof int[]) {
            JSONArray.writeJSONString((int[])value2, out);
            return;
        }
        if (value2 instanceof long[]) {
            JSONArray.writeJSONString((long[])value2, out);
            return;
        }
        if (value2 instanceof float[]) {
            JSONArray.writeJSONString((float[])value2, out);
            return;
        }
        if (value2 instanceof double[]) {
            JSONArray.writeJSONString((double[])value2, out);
            return;
        }
        if (value2 instanceof boolean[]) {
            JSONArray.writeJSONString((boolean[])value2, out);
            return;
        }
        if (value2 instanceof char[]) {
            JSONArray.writeJSONString((char[])value2, out);
            return;
        }
        if (value2 instanceof Object[]) {
            JSONArray.writeJSONString((Object[])value2, out);
            return;
        }
        JSONValue.writeJSONString(value2.toString(), out);
    }

    public static String toJSONString(Object value2) {
        StringWriter writer = new StringWriter();
        try {
            JSONValue.writeJSONString(value2, writer);
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JSONValue.escape(s2, sb);
        return sb.toString();
    }

    static void escape(String s2, StringBuilder sb) {
        int len = s2.length();
        block9: for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - ss.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block9;
                    }
                    sb.append(ch);
                }
            }
        }
    }
}

