/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp;

import com.phono.srtplight.Log;
import com.rtm516.mcxboxbroadcast.shaded.org.bouncycastle.tls.DatagramTransport;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import pe.pi.sctp4j.sctp.AssociationListener;
import pe.pi.sctp4j.sctp.ReconfigState;
import pe.pi.sctp4j.sctp.SCTPMessage;
import pe.pi.sctp4j.sctp.SCTPStream;
import pe.pi.sctp4j.sctp.SCTPStreamListener;
import pe.pi.sctp4j.sctp.StreamNumberInUseException;
import pe.pi.sctp4j.sctp.dataChannel.DECP.DCOpen;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.CookieAckChunk;
import pe.pi.sctp4j.sctp.messages.CookieEchoChunk;
import pe.pi.sctp4j.sctp.messages.DataChunk;
import pe.pi.sctp4j.sctp.messages.ErrorChunk;
import pe.pi.sctp4j.sctp.messages.HeartBeatChunk;
import pe.pi.sctp4j.sctp.messages.InitAckChunk;
import pe.pi.sctp4j.sctp.messages.InitChunk;
import pe.pi.sctp4j.sctp.messages.Packet;
import pe.pi.sctp4j.sctp.messages.ReConfigChunk;
import pe.pi.sctp4j.sctp.messages.SackChunk;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;
import pe.pi.sctp4j.sctp.messages.exceptions.UnreadyAssociationException;
import pe.pi.sctp4j.sctp.messages.params.StaleCookieError;

public abstract class Association {
    private final boolean _even;
    private byte[] _supportedExtensions = new byte[]{-126};
    public static int COOKIESIZE = 40;
    private static long VALIDCOOKIELIFE = 60000L;
    protected final DatagramTransport _transp;
    private Thread _rcv;
    private int _peerVerTag;
    protected int _myVerTag;
    private final SecureRandom _random;
    private long _winCredit;
    private long _farTSN;
    private int MAXSTREAMS = 1000;
    private int _maxOutStreams = 256;
    private int _maxInStreams = 256;
    static final int MAXBUFF = 131072;
    public long _nearTSN;
    private int _srcPort;
    private int _destPort;
    private final ConcurrentHashMap<Integer, SCTPStream> _streams;
    private final AssociationListener _al;
    private HashMap<Long, DataChunk> _outbound;
    protected State _state;
    private HashMap<Long, DataChunk> _holdingPen;
    private static int TICK = 1000;
    protected static int __assocNo = 1;
    private ReconfigState reconfigState;
    private String peerId;
    private final ArrayList<CookieHolder> _cookies = new ArrayList();

    public abstract void associate() throws SctpPacketFormatException, IOException;

    protected byte[] getSupportedExtensions() {
        return this._supportedExtensions;
    }

    long getNearTSN() {
        return this._nearTSN;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public void setPeerId(String peer) {
        this.peerId = peer;
    }

    byte[] getUnionSupportedExtensions(byte[] far) {
        ByteBuffer unionbb = ByteBuffer.allocate(far.length);
        for (int f = 0; f < far.length; ++f) {
            Log.verb("offered extension " + Chunk.typeLookup(far[f]));
            for (int n = 0; n < this._supportedExtensions.length; ++n) {
                Log.verb("supported extension " + Chunk.typeLookup(this._supportedExtensions[n]));
                if (this._supportedExtensions[n] != far[f]) continue;
                Log.verb("matching extension " + Chunk.typeLookup(this._supportedExtensions[n]));
                unionbb.put(far[f]);
            }
        }
        byte[] res = new byte[unionbb.position()];
        ((Buffer)unionbb).rewind();
        unionbb.get(res);
        Log.verb("union of extensions contains :" + Chunk.chunksToNames(res));
        return res;
    }

    void deal(Packet rec) throws Exception {
        Chunk[] s2 = new Chunk[]{};
        ArrayList<Chunk> replies = new ArrayList<Chunk>();
        rec.validate(this);
        List<Chunk> cl = rec.getChunkList();
        for (Chunk c2 : cl) {
            c2.validate();
        }
        if (cl.get(0).getType() == 1) {
            this._srcPort = rec.getDestPort();
            this._destPort = rec.getSrcPort();
        }
        for (Chunk c2 : cl) {
            if (!this.deal(c2, replies)) break;
        }
        Optional<Chunk> hisack = replies.stream().filter(c -> c.getType() == 3).sorted((a, b) -> (int)(((SackChunk)b).getCumuTSNAck() - ((SackChunk)a).getCumuTSNAck())).findFirst();
        replies.removeIf(c -> c.getType() == 3);
        if (hisack.isPresent()) {
            replies.add(0, hisack.get());
        }
        try {
            this.send(replies.toArray(s2));
        }
        catch (EOFException end) {
            this.unexpectedClose(end);
        }
    }

    void startRcv() {
        Association me = this;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int length = -99;
                try {
                    byte[] buf = new byte[1500];
                    while (Association.this._rcv != null) {
                        try {
                            length = Association.this._transp.receive(buf, 0, buf.length, TICK);
                            if (length > 0) {
                                String b = Packet.getHex(buf, length);
                                Log.verb("DTLS message recieved\n" + b.toString());
                                ByteBuffer pbb = ByteBuffer.wrap(buf);
                                ((Buffer)pbb).limit(length);
                                Packet rec = new Packet(pbb);
                                Log.debug("SCTP message parsed\n" + rec.toString());
                                Association.this.deal(rec);
                                continue;
                            }
                            Log.verb("Timeout -> short packet " + length);
                        }
                        catch (InterruptedIOException iox) {
                            Log.verb("tick time out");
                        }
                    }
                    Log.verb("SCTP message recv null\n Shutting down.");
                    Association.this._transp.close();
                }
                catch (EOFException eof) {
                    Association.this.unexpectedClose(eof);
                }
                catch (IllegalArgumentException iex) {
                    Log.warn("Exception " + iex.getMessage());
                    Log.warn("Buffer Length was invalid " + length);
                }
                catch (Exception ex) {
                    Log.debug("Association rcv failed " + ex.getClass().getName() + " " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        };
        this._rcv = new Thread(r);
        this._rcv.setPriority(10);
        this._rcv.setName("AssocRcv" + __assocNo);
        this._rcv.start();
    }

    public Association(DatagramTransport transport, AssociationListener al) {
        this(transport, al, false);
    }

    public Association(DatagramTransport transport, AssociationListener al, boolean client) {
        Log.debug("Created an Associaction of type: " + this.getClass().getSimpleName());
        this._al = al;
        this._random = new SecureRandom();
        this._myVerTag = this._random.nextInt();
        this._transp = transport;
        this._streams = new ConcurrentHashMap();
        this._outbound = new HashMap();
        this._holdingPen = new HashMap();
        this._nearTSN = this._random.nextInt(Integer.MAX_VALUE);
        this._state = State.CLOSED;
        if (this._transp != null) {
            this.startRcv();
        } else {
            Log.error("Created an Associaction with a null transport somehow...");
        }
        ++__assocNo;
        this._even = client;
    }

    public boolean doBidirectionalInit() {
        return true;
    }

    public void sendHeartBeat() throws Exception {
        Chunk[] dub = new Chunk[]{new HeartBeatChunk()};
        this.send(dub);
    }

    protected void send(Chunk[] c) throws SctpPacketFormatException, IOException {
        if (c != null && c.length > 0) {
            ByteBuffer obb = this.mkPkt(c);
            Log.verb("sending SCTP packet" + Packet.getHex(obb));
            this._transp.send(obb.array(), obb.arrayOffset(), obb.position());
        } else {
            Log.verb("Blocked empty packet send() - probably no response needed.");
        }
    }

    private boolean acceptableStateForInboundInit() {
        boolean ret = false;
        ret = this.doBidirectionalInit() ? this._state == State.CLOSED || this._state == State.COOKIEWAIT || this._state == State.COOKIEECHOED : this._state == State.CLOSED;
        return ret;
    }

    private boolean deal(Chunk c, ArrayList<Chunk> replies) throws IOException, SctpPacketFormatException {
        int ty = c.getType();
        if (ty < 0) {
            Log.debug("fixing negative " + ty);
            ty = (ty & 0x7F) + 128;
            Log.debug("fixed negative " + ty);
        }
        boolean ret = true;
        State oldState = this._state;
        Chunk[] reply = null;
        switch (ty) {
            case 1: {
                if (this.acceptableStateForInboundInit()) {
                    InitChunk init = (InitChunk)c;
                    reply = this.inboundInit(init);
                    break;
                }
                Log.debug("Got an INIT when state was " + this._state.name() + " - ignoring it for now ");
                break;
            }
            case 2: {
                Log.debug("got initack " + c.toString());
                if (this._state == State.COOKIEWAIT) {
                    InitAckChunk iack = (InitAckChunk)c;
                    reply = this.iackDeal(iack);
                    break;
                }
                Log.debug("Got an INITACK when not waiting for it - ignoring it");
                break;
            }
            case 10: {
                Log.debug("got cookie echo " + c.toString());
                reply = this.cookieEchoDeal((CookieEchoChunk)c);
                if (reply.length <= 0) break;
                ret = !(reply[0] instanceof ErrorChunk);
                break;
            }
            case 11: {
                Log.debug("got cookie ack " + c.toString());
                if (this._state != State.COOKIEECHOED) break;
                this._state = State.ESTABLISHED;
                break;
            }
            case 0: {
                Log.debug("got data " + c.toString());
                reply = this.dataDeal((DataChunk)c);
                break;
            }
            case 6: {
                this.unexpectedClose(new EOFException("ABORT received"));
                oldState = this._state;
                ret = false;
                break;
            }
            case 4: {
                Log.debug("got heartbeat " + c.toString());
                reply = ((HeartBeatChunk)c).mkReply();
                Log.debug("sending " + reply[0].typeLookup());
                break;
            }
            case 3: {
                Log.debug("got tsak for TSN " + ((SackChunk)c).getCumuTSNAck());
                reply = this.sackDeal((SackChunk)c);
                break;
            }
            case 130: {
                reply = this.reconfigState.deal((ReConfigChunk)c);
            }
        }
        if (reply != null) {
            for (Chunk r : reply) {
                replies.add(r);
            }
        }
        if (this._state == State.ESTABLISHED && oldState != State.ESTABLISHED) {
            if (null != this._al) {
                this._al.onAssociated(this);
            }
            this.reconfigState = new ReconfigState(this, this._farTSN);
        }
        if (oldState == State.ESTABLISHED && this._state != State.ESTABLISHED) {
            this.closeAllStreams();
            if (null != this._al) {
                this._al.onDisAssociated(this);
            }
        }
        return ret;
    }

    ByteBuffer mkPkt(Chunk[] cs) throws SctpPacketFormatException {
        Packet ob = new Packet(this._srcPort, this._destPort, this._peerVerTag);
        Arrays.asList(cs).stream().filter(c -> c.getType() == 11).forEach(r -> {
            Log.debug("adding Cookie Ack chunk to outbound packet " + r.toString());
            ob.getChunkList().add((Chunk)r);
        });
        Arrays.asList(cs).stream().filter(c -> c.getType() != 11).forEach(r -> {
            Log.debug("adding normal chunk to outbound packet " + r.toString());
            ob.getChunkList().add((Chunk)r);
        });
        ByteBuffer obb = ob.getByteBuffer();
        return obb;
    }

    public int getPeerVerTag() {
        return this._peerVerTag;
    }

    public int getMyVerTag() {
        return this._myVerTag;
    }

    private CookieHolder checkCookieEcho(byte[] cookieData) {
        CookieHolder same = null;
        for (CookieHolder cookie : this._cookies) {
            int i;
            byte[] cd = cookie.cookieData;
            if (cd.length != cookieData.length) continue;
            for (i = 0; i < cd.length && cd[i] == cookieData[i]; ++i) {
            }
            if (i != cd.length) continue;
            same = cookie;
            break;
        }
        return same;
    }

    private long howStaleIsMyCookie(CookieHolder cookie) {
        long ret = 0L;
        long now = System.currentTimeMillis();
        ret = now - cookie.cookieTime < VALIDCOOKIELIFE ? 0L : now - cookie.cookieTime - VALIDCOOKIELIFE;
        return ret;
    }

    public void sendInit() throws SctpPacketFormatException, IOException {
        InitChunk c = new InitChunk();
        c.setInitialTSN(this._nearTSN);
        c.setNumInStreams(this.MAXSTREAMS);
        c.setNumOutStreams(this.MAXSTREAMS);
        c.setAdRecWinCredit(131072L);
        c.setInitiate(this.getMyVerTag());
        Chunk[] s2 = new Chunk[]{c};
        this._state = State.COOKIEWAIT;
        try {
            this.send(s2);
        }
        catch (EOFException end) {
            this.unexpectedClose(end);
        }
    }

    protected Chunk[] iackDeal(InitAckChunk iack) {
        Chunk[] reply = null;
        this._peerVerTag = iack.getInitiateTag();
        this._winCredit = iack.getAdRecWinCredit();
        this._farTSN = iack.getInitialTSN() - 1L;
        this._maxOutStreams = Math.min(iack.getNumInStreams(), this.MAXSTREAMS);
        this._maxInStreams = Math.min(iack.getNumOutStreams(), this.MAXSTREAMS);
        iack.getSupportedExtensions(this._supportedExtensions);
        byte[] data = iack.getCookie();
        CookieEchoChunk ce = new CookieEchoChunk();
        ce.setCookieData(data);
        reply = new Chunk[]{ce};
        this._state = State.COOKIEECHOED;
        return reply;
    }

    protected Chunk[] inboundInit(InitChunk init) {
        Chunk[] reply = null;
        this._peerVerTag = init.getInitiateTag();
        this._winCredit = init.getAdRecWinCredit();
        this._farTSN = init.getInitialTSN() - 1L;
        this._maxOutStreams = Math.min(init.getNumInStreams(), this.MAXSTREAMS);
        this._maxInStreams = Math.min(init.getNumOutStreams(), this.MAXSTREAMS);
        InitAckChunk iac = new InitAckChunk();
        iac.setAdRecWinCredit(131072);
        iac.setNumInStreams(this._maxInStreams);
        iac.setNumOutStreams(this._maxOutStreams);
        iac.setInitialTSN((int)this._nearTSN);
        iac.setInitiateTag(this._myVerTag);
        CookieHolder cookie = new CookieHolder();
        cookie.cookieData = new byte[COOKIESIZE];
        cookie.cookieTime = System.currentTimeMillis();
        this._random.nextBytes(cookie.cookieData);
        byte[] watermark = " |pi.pe|".getBytes();
        int wlen = Math.min(watermark.length, cookie.cookieData.length);
        for (int w = 0; w < wlen; ++w) {
            cookie.cookieData[w] = watermark[w];
        }
        iac.setCookie(cookie.cookieData);
        this._cookies.add(cookie);
        byte[] fse = init.getFarSupportedExtensions();
        if (fse != null) {
            iac.setSupportedExtensions(this.getUnionSupportedExtensions(fse));
        }
        reply = new Chunk[]{iac};
        Log.debug("Got in bound init :" + init.toString());
        Log.debug("Replying with init-ack :" + iac.toString());
        return reply;
    }

    private void ingest(DataChunk dc, ArrayList<Chunk> rep) {
        Chunk[] repa;
        Log.verb("ingesting " + dc.toString());
        Object closer = null;
        Integer sno = dc.getStreamId();
        long tsn = dc.getTsn();
        SCTPStream in = this._streams.get(sno);
        if (in == null) {
            Log.verb("making new stream " + sno);
            in = this.mkStream(sno);
            this._streams.put(sno, in);
            this._al.onRawStream(in);
        }
        if ((repa = in.append(dc)) != null) {
            for (Chunk r : repa) {
                rep.add(r);
            }
        }
        if (closer != null) {
            rep.add((Chunk)closer);
        }
        in.inbound(dc);
        this._farTSN = tsn;
    }

    private Chunk[] dataDeal(DataChunk dc) {
        ArrayList<Chunk> rep = new ArrayList<Chunk>();
        ArrayList<Long> duplicates = new ArrayList<Long>();
        Chunk[] dummy = new Chunk[]{};
        long tsn = dc.getTsn();
        Long tsn_L = new Long(tsn);
        if (tsn > this._farTSN) {
            DataChunk dup = this._holdingPen.get(tsn_L);
            if (dup != null) {
                duplicates.add(tsn_L);
            } else {
                this._holdingPen.put(tsn_L, dc);
            }
            boolean gap = false;
            long t = this._farTSN + 1L;
            while (!gap) {
                Long l = new Long(t);
                dc = this._holdingPen.remove(l);
                if (dc != null) {
                    this.ingest(dc, rep);
                } else {
                    Log.verb("gap in inbound tsns at " + t);
                    gap = true;
                }
                ++t;
            }
        } else {
            Log.warn("Already seen . " + tsn + " expecting " + this._farTSN);
            duplicates.add(tsn_L);
        }
        ArrayList<Long> l = new ArrayList<Long>();
        l.addAll(this._holdingPen.keySet());
        Collections.sort(l);
        SackChunk sack = this.mkSack(l, duplicates);
        rep.add(sack);
        return rep.toArray(dummy);
    }

    private Chunk[] cookieEchoDeal(CookieEchoChunk echo) {
        Chunk[] reply = new Chunk[]{};
        if (this._state == State.CLOSED || this._state == State.COOKIEWAIT || this._state == State.COOKIEECHOED || this._state == State.ESTABLISHED) {
            CookieHolder cookie = this.checkCookieEcho(echo.getCookieData());
            if (null != cookie) {
                long howStale = this.howStaleIsMyCookie(cookie);
                if (howStale == 0L) {
                    if (this._state == State.ESTABLISHED) {
                        Log.debug("Repeating a lost cookie Ack");
                    }
                    this._state = State.ESTABLISHED;
                    reply = new Chunk[]{new CookieAckChunk()};
                } else {
                    reply = new Chunk[1];
                    StaleCookieError sce = new StaleCookieError();
                    sce.setMeasure(howStale * 1000L);
                    ErrorChunk ec = new ErrorChunk(sce);
                    reply[0] = ec;
                }
            } else {
                Log.error("Got a COOKIE_ECHO that doesn't match any we sent. ?!?");
            }
        } else {
            Log.debug("Got an COOKIE_ECHO when not expecting one - ignoring it");
        }
        return reply;
    }

    private SackChunk mkSack(ArrayList<Long> pen, ArrayList<Long> dups) {
        SackChunk ret = new SackChunk();
        ret.setCumuTSNAck(this._farTSN);
        int stashcap = this.calcStashCap();
        ret.setArWin(131072 - stashcap);
        ret.setGaps(pen);
        ret.setDuplicates(dups);
        Log.debug("made SACK " + ret.toString());
        return ret;
    }

    private int calcStashCap() {
        return this._streams.values().stream().mapToInt(s2 -> s2.stashCap()).sum();
    }

    public abstract void enqueue(DataChunk var1);

    public abstract SCTPStream mkStream(int var1);

    long getCumAckPt() {
        return this._farTSN;
    }

    ReConfigChunk addToCloseList(SCTPStream st) throws Exception {
        return this.reconfigState.makeClose(st);
    }

    public void closeStream(SCTPStream st) throws SctpPacketFormatException, IOException, Exception {
        Chunk[] cs = new Chunk[1];
        if (this.canSend()) {
            Log.debug("due to reconfig stream " + st);
            cs[0] = this.reconfigState.makeClose(st);
            this.send(cs);
        }
    }

    public SCTPStream mkStream(String label, SCTPStreamListener sl) throws StreamNumberInUseException, UnreadyAssociationException, SctpPacketFormatException, IOException, Exception {
        SCTPStream s2 = this.mkStream(label);
        s2.setSCTPStreamListener(sl);
        return s2;
    }

    public SCTPStream mkStream(String label) throws StreamNumberInUseException, UnreadyAssociationException, SctpPacketFormatException, IOException, Exception {
        int n = 1;
        int tries = this._maxOutStreams;
        do {
            n = 2 * this._random.nextInt(this._maxOutStreams / 2);
            if (!this._even) {
                ++n;
            }
            if (--tries >= 0) continue;
            throw new StreamNumberInUseException();
        } while (this._streams.containsKey(new Integer(n)));
        return this.mkStream(n, label);
    }

    int[] allStreams() {
        int[] ret = new int[]{};
        Set ks = this._streams.keySet();
        ret = new int[ks.size()];
        int i = 0;
        for (Integer k : ks) {
            ret[i++] = k;
        }
        return ret;
    }

    protected SCTPStream getStream(int s2) {
        return this._streams.get(s2);
    }

    SCTPStream delStream(int s2) {
        return this._streams.remove(s2);
    }

    public SCTPStream mkStream(int sno, String label) throws StreamNumberInUseException, UnreadyAssociationException, SctpPacketFormatException, IOException, Exception {
        SCTPStream sout;
        if (this.canSend()) {
            sout = this.mkStream(sno);
            sout.setLabel(label);
            SCTPStream sold = this._streams.putIfAbsent(sno, sout);
            if (sold != null) {
                Log.warn("Stream number already in use " + sno);
                throw new StreamNumberInUseException();
            }
        } else {
            throw new UnreadyAssociationException();
        }
        return sout;
    }

    public int maxMessageSize() {
        return 65536;
    }

    public State getState() {
        return this._state;
    }

    public boolean canSend() {
        boolean ok;
        switch (this._state) {
            case ESTABLISHED: {
                ok = true;
                break;
            }
            default: {
                ok = false;
            }
        }
        return ok;
    }

    public void unexpectedClose(EOFException end) {
        Log.debug("Unxepected association close " + end.getMessage());
        if (this._state != State.CLOSED) {
            block7: {
                block6: {
                    try {
                        this.closeAllStreams();
                    }
                    catch (Throwable t) {
                        Log.error("can't close " + t.getMessage() + " in unexpectedClose");
                        if (Log.getLevel() < 4) break block6;
                        t.printStackTrace();
                    }
                }
                try {
                    this._al.onDisAssociated(this);
                }
                catch (Throwable t) {
                    Log.error("Can't dis " + t.getMessage() + " in unexpectedClose");
                    if (Log.getLevel() < 4) break block7;
                    t.printStackTrace();
                }
            }
            this._state = State.CLOSED;
        } else {
            Log.warn("already closed. ");
        }
        this._rcv = null;
    }

    public void closeAllStreams() {
        this._streams.forEach((sn, st) -> {
            block3: {
                Log.debug("closing " + st.getLabel());
                try {
                    SCTPStreamListener li = st.getSCTPStreamListener();
                    if (li != null) {
                        li.close((SCTPStream)st);
                    }
                }
                catch (Exception x) {
                    Log.error("problem closing stream");
                    if (Log.getLevel() < 4) break block3;
                    x.printStackTrace();
                }
            }
        });
        this._streams.clear();
    }

    public boolean isAssociated() {
        return this._state == State.ESTABLISHED;
    }

    public synchronized SCTPMessage makeMessage(byte[] bytes, SCTPStream s2) {
        SCTPMessage m = null;
        if (this.canSend()) {
            if (bytes.length < this.maxMessageSize()) {
                m = new SCTPMessage(bytes, s2);
                s2.setAsNextMessage(m);
            } else {
                Log.warn("Message too long " + bytes.length + " > " + this.maxMessageSize());
            }
        }
        return m;
    }

    public synchronized SCTPMessage makeMessage(String string, SCTPStream s2) {
        SCTPMessage m = null;
        if (this.canSend()) {
            if (string.length() < this.maxMessageSize()) {
                m = new SCTPMessage(string, s2);
                s2.setAsNextMessage(m);
            } else {
                Log.warn("Message too long " + string.length() + " > " + this.maxMessageSize());
            }
        }
        return m;
    }

    public synchronized SCTPMessage makeMessage(DCOpen dco, SCTPStream s2) {
        SCTPMessage m = null;
        byte[] bytes = dco.getBytes();
        if (this.canSend()) {
            if (bytes.length < this.maxMessageSize()) {
                m = new SCTPMessage(dco, s2);
                s2.setAsNextMessage(m);
                if (m.getSeq() != 0) {
                    Log.warn("DCO should be the first message in a stream was " + m.getSeq() + " type = dcep" + (dco.isAck() ? "ACK" : "OPEN"));
                }
            } else {
                Log.warn("Message too long " + bytes.length + " > " + this.maxMessageSize());
            }
        }
        return m;
    }

    void alOnDCEPStream(SCTPStream _stream, String label, int _pPid) throws Exception {
        this._al.onDCEPStream(_stream, label, _pPid);
    }

    protected abstract Chunk[] sackDeal(SackChunk var1);

    class CookieHolder {
        byte[] cookieData;
        long cookieTime;

        CookieHolder() {
        }
    }

    public static enum State {
        COOKIEWAIT,
        COOKIEECHOED,
        ESTABLISHED,
        SHUTDOWNPENDING,
        SHUTDOWNSENT,
        SHUTDOWNRECEIVED,
        SHUTDOWNACKSENT,
        CLOSED;

    }
}

