/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import java.util.SortedSet;
import pe.pi.sctp4j.sctp.MessageCompleteHandler;
import pe.pi.sctp4j.sctp.SCTPByteStreamListener;
import pe.pi.sctp4j.sctp.SCTPOutboundStreamOpenedListener;
import pe.pi.sctp4j.sctp.SCTPStream;
import pe.pi.sctp4j.sctp.SCTPStreamListener;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.dataChannel.DECP.DCOpen;
import pe.pi.sctp4j.sctp.messages.DataChunk;

public class SCTPMessage
implements Runnable {
    private final SCTPStream _stream;
    private final byte[] _data;
    private int _offset = 0;
    private int _pPid = 0;
    private int _mseq;
    private SCTPStreamListener _li;
    private boolean _delivered;
    private Runnable onAcked;

    public SCTPMessage(byte[] data, SCTPStream s2) {
        this._data = data.length > 0 ? data : new byte[1];
        this._stream = s2;
        this._pPid = data.length > 0 ? 53 : 57;
    }

    public SCTPMessage(String data, SCTPStream s2) {
        this._data = data.length() > 0 ? data.getBytes() : new byte[1];
        this._stream = s2;
        this._pPid = data.length() > 0 ? 51 : 56;
    }

    public SCTPMessage(DCOpen dcep, SCTPStream s2) {
        byte[] data = dcep.getBytes();
        this._data = data.length > 0 ? data : new byte[1];
        this._stream = s2;
        this._pPid = data.length > 0 ? 50 : 57;
    }

    public SCTPMessage(SCTPStream s2, SortedSet<DataChunk> chunks) {
        this._stream = s2;
        int tot = 0;
        if ((chunks.first().getFlags() & 2) == 0) {
            throw new IllegalArgumentException("must start with 'start' chunk");
        }
        if ((chunks.last().getFlags() & 1) == 0) {
            throw new IllegalArgumentException("must end with 'end' chunk");
        }
        this._pPid = chunks.first().getPpid();
        for (DataChunk dc : chunks) {
            tot += dc.getDataSize();
            if (this._pPid == dc.getPpid()) continue;
            throw new IllegalArgumentException("chunk has wrong ppid" + dc.getPpid() + " vs " + this._pPid);
        }
        this._data = new byte[tot];
        int offs = 0;
        for (DataChunk dc : chunks) {
            System.arraycopy(dc.getData(), 0, this._data, offs, dc.getDataSize());
            offs += dc.getDataSize();
        }
    }

    public SCTPMessage(SCTPStream s2, DataChunk singleChunk) {
        this._stream = s2;
        int flags = singleChunk.getFlags();
        if ((flags & 3) <= 0) {
            throw new IllegalArgumentException("must use a 'single' chunk");
        }
        this._data = singleChunk.getData();
        this._pPid = singleChunk.getPpid();
    }

    public void setCompleteHandler(MessageCompleteHandler mch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean hasMoreData() {
        return this._offset < this._data.length;
    }

    public void fill(DataChunk dc) {
        int dsz = dc.getCapacity();
        int remain = this._data.length - this._offset;
        if (this._offset == 0) {
            if (remain <= dsz) {
                dc.setFlags(3);
                dc.setData(this._data);
                this._offset = this._data.length;
            } else {
                dc.setFlags(2);
                dc.setData(this._data, this._offset, dsz);
                this._offset += dsz;
            }
        } else if (remain <= dsz) {
            dc.setFlags(1);
            dc.setData(this._data, this._offset, remain);
            this._offset += remain;
        } else {
            dc.setFlags(0);
            dc.setData(this._data, this._offset, dsz);
            this._offset += dsz;
        }
        dc.setPpid(this._pPid);
        dc.setsSeqNo(this._mseq);
        this._stream.outbound(dc);
    }

    public boolean deliver(SCTPStreamListener li) {
        this._li = li;
        this._delivered = false;
        Log.debug("delegating message delivery to stream of type " + this._stream.getClass().getSimpleName());
        this._stream.deliverMessage(this);
        return true;
    }

    public byte[] getData() {
        return this._data;
    }

    public void setSeq(int mseq) {
        this._mseq = mseq;
    }

    public int getSeq() {
        return this._mseq;
    }

    private void dcepMessageDeal(byte[] data) {
        block9: {
            ByteBuffer bb = ByteBuffer.wrap(data);
            try {
                DCOpen dcep = new DCOpen(bb);
                SCTPStreamBehaviour behave = dcep.mkStreamBehaviour();
                this._stream.setBehave(behave);
                if (!dcep.isAck()) {
                    Log.debug("decp open  " + dcep.toString());
                    this._stream.setLabel(dcep.getLabel());
                    try {
                        this._stream.openAck(dcep);
                        this._stream.alOnDCEPStream(this._stream, this._stream.getLabel(), this._pPid);
                    }
                    catch (Exception x) {
                        Log.error("Dcep ack failed to send");
                        if (Log.getLevel() >= 4) {
                            x.printStackTrace();
                        }
                        try {
                            this._stream.close();
                            break block9;
                        }
                        catch (Exception sx) {
                            Log.error("Can't close " + this._stream.toString() + " because " + x.getMessage());
                        }
                    }
                    break block9;
                }
                Log.debug("got a dcep ack for " + this._stream.getLabel());
                if (this._li != null && this._li instanceof SCTPOutboundStreamOpenedListener) {
                    ((SCTPOutboundStreamOpenedListener)((Object)this._li)).opened(this._stream);
                }
            }
            catch (Exception x) {
                Log.error("Problem with DCOpen " + x.getMessage());
                if (Log.getLevel() < 4) break block9;
                x.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        Log.debug("delegated message delivery from stream of type " + this._stream.getClass().getSimpleName());
        if (this._li != null) {
            Log.debug("delegated message delivery to listener of type " + this._li.getClass().getSimpleName());
        }
        byte[] data = this._data;
        switch (this._pPid) {
            case 57: {
                data = new byte[]{};
            }
            case 53: {
                if (this._li != null && this._li instanceof SCTPByteStreamListener) {
                    ((SCTPByteStreamListener)this._li).onMessage(this._stream, data);
                    this._delivered = true;
                    break;
                }
                this._stream.earlyMessageEnqueue(this);
                break;
            }
            case 56: {
                data = new byte[]{};
            }
            case 51: {
                if (this._li != null) {
                    this._li.onMessage(this._stream, new String(data));
                    this._delivered = true;
                    break;
                }
                this._stream.earlyMessageEnqueue(this);
                break;
            }
            case 50: {
                this.dcepMessageDeal(data);
                this._delivered = true;
            }
        }
        if (!this._delivered) {
            Log.debug("Undelivered message to " + (this._stream == null ? "null stream" : this._stream.getLabel()) + " via " + (this._li == null ? "null listener" : this._li.getClass().getSimpleName()) + " ppid is " + this._pPid);
        }
    }

    public void setAckCallBack(Runnable r) {
        this.onAcked = r;
    }

    public void acked() {
        if (this.onAcked != null) {
            this.onAcked.run();
        }
    }
}

