/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp;

import com.phono.srtplight.Log;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.LinkedBlockingQueue;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.SCTPMessage;
import pe.pi.sctp4j.sctp.SCTPStreamListener;
import pe.pi.sctp4j.sctp.behave.OrderedStreamBehaviour;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.dataChannel.DECP.DCOpen;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.DataChunk;
import pe.pi.sctp4j.sctp.messages.ReConfigChunk;

public abstract class SCTPStream {
    private SCTPStreamBehaviour _behave;
    Association _ass;
    private Integer _sno;
    private String _label;
    private ConcurrentSkipListSet<DataChunk> _stash;
    private SCTPStreamListener _sl;
    private int _nextMessageSeqIn;
    private int _nextMessageSeqOut;
    protected LinkedBlockingQueue<SCTPMessage> _earlyQueue;
    private boolean closing;
    private State state = State.OPEN;

    public boolean InboundIsOpen() {
        return this.state == State.OPEN || this.state == State.INBOUNDONLY;
    }

    public boolean OutboundIsOpen() {
        return this.state == State.OPEN || this.state == State.OUTBOUNDONLY;
    }

    public Chunk immediateClose() {
        ReConfigChunk ret = null;
        try {
            ret = this._ass.addToCloseList(this);
        }
        catch (Exception ex) {
            Log.error("Can't make immediate close for " + this._sno + " because " + ex.getMessage());
        }
        return ret;
    }

    public abstract void delivered(DataChunk var1);

    public SCTPStreamListener getSCTPStreamListener() {
        return this._sl;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._sno + "]=" + this._label + "|" + this._behave.getClass().getSimpleName() + "|->" + (this._sl != null ? this._sl.getClass().getSimpleName() : "null");
    }

    public String getBehave() {
        return this._behave == null ? "unknown" : this._behave.getClass().getSimpleName();
    }

    synchronized void setAsNextMessage(SCTPMessage m) {
        int mseq = this.getNextMessageSeqOut();
        this.setNextMessageSeqOut(mseq + 1);
        m.setSeq(mseq);
    }

    public void openAck(DCOpen dcep) throws Exception {
        DCOpen ack = DCOpen.mkAck();
        Log.debug("made a dcep ack for " + this._label);
        this.send(ack);
    }

    protected void alOnDCEPStream(SCTPStream _stream, String label, int _pPid) throws Exception {
        this._ass.alOnDCEPStream(_stream, label, _pPid);
    }

    void earlyMessageEnqueue(SCTPMessage early) {
        Log.debug("enqueue an early message seq " + early.getSeq() + " on " + this.toString());
        this._earlyQueue.add(early);
    }

    public SCTPStream(Association a, Integer id) {
        this._ass = a;
        this._sno = id;
        this._stash = new ConcurrentSkipListSet();
        this._behave = new OrderedStreamBehaviour();
        this._earlyQueue = new LinkedBlockingQueue(100);
    }

    public void setLabel(String l) {
        this._label = l;
    }

    public Integer getNum() {
        return this._sno;
    }

    public Chunk[] append(DataChunk dc) {
        Log.debug("adding data to stash on stream " + (this._label == null ? "*unnamed*" : this._label) + "(" + dc + ")");
        this._stash.add(dc);
        return this._behave.respond(this);
    }

    public void setBehave(SCTPStreamBehaviour behave) {
        this._behave = behave;
    }

    public void outbound(DataChunk chunk) {
        chunk.setStreamId(this._sno);
    }

    void inbound(DataChunk dc) {
        if (this._behave != null) {
            this._behave.deliver(this, this._stash, this._sl);
        } else {
            Log.warn("No behaviour set");
        }
    }

    public String getLabel() {
        return this._label;
    }

    int stashCap() {
        int ret = 0;
        for (DataChunk d : this._stash) {
            ret += d.getData().length;
        }
        return ret;
    }

    public void setSCTPStreamListener(SCTPStreamListener sl) {
        this._sl = sl;
        Log.debug("adding listener for " + this._label + " of " + sl.getClass().getName());
        if (this._earlyQueue != null) {
            Log.debug("delivering early " + this._earlyQueue.size() + " messages to " + sl.getClass().getName());
            SCTPMessage e = null;
            while (null != (e = this._earlyQueue.poll())) {
                e.deliver(this._sl);
            }
        } else {
            Log.debug("no early queue for " + this._label);
        }
    }

    public abstract void send(String var1) throws Exception;

    public abstract void send(byte[] var1) throws Exception;

    public abstract void send(DCOpen var1) throws Exception;

    public Association getAssociation() {
        return this._ass;
    }

    public void close() throws Exception {
        Log.debug("closing stream " + this._label + " " + this._sno);
        this._ass.closeStream(this);
    }

    public void setNextMessageSeqIn(int expectedSeq) {
        this._nextMessageSeqIn = expectedSeq == 65536 ? 0 : expectedSeq;
    }

    public int getNextMessageSeqIn() {
        return this._nextMessageSeqIn;
    }

    public void setNextMessageSeqOut(int expectedSeq) {
        this._nextMessageSeqOut = expectedSeq == 65536 ? 0 : expectedSeq;
    }

    public int getNextMessageSeqOut() {
        return this._nextMessageSeqOut;
    }

    public abstract void deliverMessage(SCTPMessage var1);

    void setDeferred(boolean b) {
        boolean deferred = true;
    }

    void reset() {
        Log.debug("Resetting stream " + this._sno);
        if (this._sl != null) {
            this._sl.close(this);
        }
    }

    void setClosing(boolean b) {
        this.closing = b;
    }

    boolean isClosing() {
        return this.closing;
    }

    void setOutboundClosed() {
        switch (this.state) {
            case OPEN: {
                this.state = State.INBOUNDONLY;
                break;
            }
            case OUTBOUNDONLY: {
                this.state = State.CLOSED;
                break;
            }
        }
        Log.debug("Stream State for " + this._sno + " is now " + this.state);
    }

    void setInboundClosed() {
        switch (this.state) {
            case OPEN: {
                this.state = State.OUTBOUNDONLY;
                break;
            }
            case INBOUNDONLY: {
                this.state = State.CLOSED;
                break;
            }
        }
        Log.debug("Stream State for " + this._sno + " is now " + this.state);
    }

    State getState() {
        Log.debug("Stream State for " + this._sno + " is currently " + this.state);
        return this.state;
    }

    public boolean idle() {
        return true;
    }

    static enum State {
        CLOSED,
        INBOUNDONLY,
        OUTBOUNDONLY,
        OPEN;

    }
}

