/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.dataChannel.DECP;

import com.phono.srtplight.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.behave.OrderedStreamBehaviour;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.behave.UnorderedStreamBehaviour;
import pe.pi.sctp4j.sctp.messages.Packet;
import pe.pi.sctp4j.sctp.messages.exceptions.InvalidDataChunkException;

public class DCOpen {
    public static final byte RELIABLE = 0;
    public static final byte PARTIAL_RELIABLE_REXMIT = 1;
    public static final byte PARTIAL_RELIABLE_REXMIT_UNORDERED = -127;
    public static final byte PARTIAL_RELIABLE_TIMED = 2;
    public static final byte PARTIAL_RELIABLE_TIMED_UNORDERED = -126;
    public static final byte RELIABLE_UNORDERED = -128;
    private byte _messType;
    private byte _chanType;
    private int _priority;
    private long _reliablity;
    int _labLen;
    int _protLen;
    private byte[] _label;
    private byte[] _protocol;
    static final int OPEN = 3;
    static final int ACK = 2;
    boolean _isAck = false;

    public DCOpen(String label) {
        this(0, 0, 0L, label, "");
    }

    private DCOpen() {
    }

    public DCOpen(byte chanType, int priority, long reliablity, String label, String protocol) {
        this._messType = (byte)3;
        this._chanType = chanType;
        this._priority = priority;
        this._reliablity = reliablity;
        this._label = label.getBytes();
        this._protocol = protocol.getBytes();
        this._labLen = this._label.length;
        this._protLen = this._protocol.length;
    }

    public byte[] getBytes() {
        int sz = 12 + this._labLen + DCOpen.pad(this._labLen) + this._protLen + DCOpen.pad(this._protLen);
        Log.verb("dcopen needs " + sz + " bytes ");
        byte[] ret = new byte[sz];
        ByteBuffer buff = ByteBuffer.wrap(ret);
        buff.put(this._messType);
        buff.put(this._chanType);
        buff.putChar((char)this._priority);
        buff.putInt((int)this._reliablity);
        buff.putChar((char)this._labLen);
        buff.putChar((char)this._protLen);
        buff.put(this._label);
        ByteBuffer bu = buff;
        ((Buffer)bu).position(bu.position() + DCOpen.pad(this._labLen));
        buff.put(this._protocol);
        ((Buffer)bu).position(bu.position() + DCOpen.pad(this._protLen));
        return ret;
    }

    public static final int pad(int len) {
        int mod = len % 4;
        int res = 0;
        Log.verb("field of " + len + " mod 4 is " + mod);
        if (mod > 0) {
            res = 4 - mod;
        }
        Log.verb("padded by " + res);
        return res;
    }

    public DCOpen(ByteBuffer bb) throws InvalidDataChunkException {
        this._messType = bb.get();
        switch (this._messType) {
            case 3: {
                this._chanType = bb.get();
                this._priority = bb.getChar();
                this._reliablity = bb.getInt();
                this._labLen = bb.getChar();
                this._protLen = bb.getChar();
                this._label = new byte[this._labLen];
                bb.get(this._label);
                this._protocol = new byte[this._protLen];
                bb.get(this._protocol);
                break;
            }
            case 2: {
                this._isAck = true;
                break;
            }
            default: {
                throw new InvalidDataChunkException("Unexpected DCEP message type " + this._messType);
            }
        }
    }

    public String toString() {
        return this._isAck ? "Ack " : "Open  _chanType =" + this._chanType + " _priority = " + this._priority + " _reliablity = " + this._reliablity + " _label = " + new String(this._label) + " _protocol = " + Packet.getHex(this._protocol);
    }

    public boolean isAck() {
        return this._isAck;
    }

    public SCTPStreamBehaviour mkStreamBehaviour() {
        String loglab = this._label == null ? "_null_" : new String(this._label);
        Log.debug("Making a behaviour for dcep stream " + loglab);
        OrderedStreamBehaviour behave = null;
        switch (this._chanType) {
            case 0: {
                behave = new OrderedStreamBehaviour();
                break;
            }
            case -128: {
                behave = new UnorderedStreamBehaviour();
                break;
            }
            case 1: 
            case 2: {
                behave = new OrderedStreamBehaviour();
                break;
            }
            case -127: 
            case -126: {
                behave = new UnorderedStreamBehaviour();
            }
        }
        if (behave != null) {
            Log.debug(loglab + " behaviour is " + behave.getClass().getSimpleName());
        }
        return behave;
    }

    public String getLabel() {
        return new String(this._label);
    }

    public static DCOpen mkAck() {
        DCOpen ack = new DCOpen(){

            @Override
            public byte[] getBytes() {
                byte[] a = new byte[]{2};
                return a;
            }
        };
        ack._isAck = true;
        return ack;
    }
}

