/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pe.pi.sctp4j.sctp.messages.AbortChunk;
import pe.pi.sctp4j.sctp.messages.CookieAckChunk;
import pe.pi.sctp4j.sctp.messages.CookieEchoChunk;
import pe.pi.sctp4j.sctp.messages.DataChunk;
import pe.pi.sctp4j.sctp.messages.HeartBeatChunk;
import pe.pi.sctp4j.sctp.messages.InitAckChunk;
import pe.pi.sctp4j.sctp.messages.InitChunk;
import pe.pi.sctp4j.sctp.messages.Packet;
import pe.pi.sctp4j.sctp.messages.ReConfigChunk;
import pe.pi.sctp4j.sctp.messages.SackChunk;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;
import pe.pi.sctp4j.sctp.messages.params.AddIncomingStreamsRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.AddOutgoingStreamsRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.CookiePreservative;
import pe.pi.sctp4j.sctp.messages.params.HostNameAddress;
import pe.pi.sctp4j.sctp.messages.params.IPv4Address;
import pe.pi.sctp4j.sctp.messages.params.IPv6Address;
import pe.pi.sctp4j.sctp.messages.params.IncomingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.KnownError;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;
import pe.pi.sctp4j.sctp.messages.params.OutgoingSSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.ProtocolViolationError;
import pe.pi.sctp4j.sctp.messages.params.ReconfigurationResponseParameter;
import pe.pi.sctp4j.sctp.messages.params.RequestedHMACAlgorithmParameter;
import pe.pi.sctp4j.sctp.messages.params.SSNTSNResetRequestParameter;
import pe.pi.sctp4j.sctp.messages.params.StaleCookieError;
import pe.pi.sctp4j.sctp.messages.params.StateCookie;
import pe.pi.sctp4j.sctp.messages.params.SupportedAddressTypes;
import pe.pi.sctp4j.sctp.messages.params.Unknown;
import pe.pi.sctp4j.sctp.messages.params.UnrecognizedParameters;
import pe.pi.sctp4j.sctp.messages.params.VariableParam;

public abstract class Chunk {
    public static final int DATA = 0;
    public static final int INIT = 1;
    public static final int INITACK = 2;
    public static final int SACK = 3;
    public static final int HEARTBEAT = 4;
    public static final int HEARTBEAT_ACK = 5;
    public static final int ABORT = 6;
    public static final int ERROR = 9;
    public static final int COOKIE_ECHO = 10;
    public static final int COOKIE_ACK = 11;
    public static final int SHUTDOWN_COMPLETE = 14;
    public static final int RE_CONFIG = 130;
    static byte TBIT = 1;
    static final Map<Integer, String> _typeLookup = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<Integer, String>(0, "DATA"), new AbstractMap.SimpleEntry<Integer, String>(1, "INIT"), new AbstractMap.SimpleEntry<Integer, String>(2, "INIT ACK"), new AbstractMap.SimpleEntry<Integer, String>(3, "SACK"), new AbstractMap.SimpleEntry<Integer, String>(4, "HEARTBEAT"), new AbstractMap.SimpleEntry<Integer, String>(5, "HEARTBEAT ACK"), new AbstractMap.SimpleEntry<Integer, String>(6, "ABORT"), new AbstractMap.SimpleEntry<Integer, String>(7, "SHUTDOWN"), new AbstractMap.SimpleEntry<Integer, String>(8, "SHUTDOWN ACK"), new AbstractMap.SimpleEntry<Integer, String>(9, "ERROR"), new AbstractMap.SimpleEntry<Integer, String>(10, "COOKIE ECHO"), new AbstractMap.SimpleEntry<Integer, String>(11, "COOKIE ACK"), new AbstractMap.SimpleEntry<Integer, String>(12, "ECNE"), new AbstractMap.SimpleEntry<Integer, String>(13, "CWR"), new AbstractMap.SimpleEntry<Integer, String>(14, "SHUTDOWN COMPLETE"), new AbstractMap.SimpleEntry<Integer, String>(15, "AUTH"), new AbstractMap.SimpleEntry<Integer, String>(193, "ASCONF"), new AbstractMap.SimpleEntry<Integer, String>(128, "ASCONF-ACK"), new AbstractMap.SimpleEntry<Integer, String>(130, "RE-CONFIG"), new AbstractMap.SimpleEntry<Integer, String>(192, "FORWARDTSN"), new AbstractMap.SimpleEntry<Integer, String>(129, "PKTDROP")).collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> (String)e.getValue())));
    static final Map<String, Integer> __nameMap = _typeLookup.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getValue(), e -> (Integer)e.getKey()));
    byte _type;
    byte _flags;
    int _length;
    ByteBuffer _body;
    ArrayList<VariableParam> _varList = new ArrayList();

    static Chunk mkChunk(ByteBuffer pkt) {
        Chunk ret = null;
        if (pkt.remaining() >= 4) {
            int mod;
            byte type = pkt.get();
            byte flags = pkt.get();
            char length = pkt.getChar();
            int itype = 0xFF & type;
            switch (itype) {
                case 0: {
                    ret = new DataChunk(type, flags, length, pkt);
                    break;
                }
                case 1: {
                    ret = new InitChunk(type, flags, length, pkt);
                    break;
                }
                case 3: {
                    ret = new SackChunk(type, flags, length, pkt);
                    break;
                }
                case 2: {
                    ret = new InitAckChunk(type, flags, length, pkt);
                    break;
                }
                case 10: {
                    ret = new CookieEchoChunk(type, flags, length, pkt);
                    break;
                }
                case 11: {
                    ret = new CookieAckChunk(type, flags, length, pkt);
                    break;
                }
                case 6: {
                    ret = new AbortChunk(type, flags, length, pkt);
                    break;
                }
                case 4: {
                    ret = new HeartBeatChunk(type, flags, length, pkt);
                    break;
                }
                case 130: {
                    ret = new ReConfigChunk(type, flags, length, pkt);
                    break;
                }
                default: {
                    Log.warn("Default chunk type " + itype + " read in ");
                    ret = new Chunk(type, flags, length, pkt){

                        @Override
                        void putFixedParams(ByteBuffer ret) {
                        }
                    };
                }
            }
            if (ret != null && pkt.hasRemaining() && (mod = ret.getLength() % 4) != 0) {
                for (int pad = mod; pad < 4; ++pad) {
                    pkt.get();
                }
            }
        }
        return ret;
    }

    protected Chunk(byte type) {
        this._type = type;
    }

    protected Chunk(byte type, byte flags, int length, ByteBuffer pkt) {
        this._type = type;
        this._flags = flags;
        this._length = length;
        this._body = pkt.slice();
        ((Buffer)this._body).limit(length - 4);
        ByteBuffer bpkt = pkt;
        ((Buffer)bpkt).position(bpkt.position() + (length - 4));
    }

    public static long getUnsignedInt(ByteBuffer bb) {
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer bb, long value2) {
        bb.putInt((int)(value2 & 0xFFFFFFFFL));
    }

    void write(ByteBuffer ret) throws SctpPacketFormatException {
        ret.put(this._type);
        ret.put(this._flags);
        ret.putChar('\u0004');
        ByteBuffer bret = ret;
        this.putFixedParams(ret);
        int pad = 0;
        if (this._varList != null) {
            for (VariableParam v : this._varList) {
                Log.debug("var " + v.getName() + " at " + bret.position());
                ByteBuffer var = ret.slice();
                var.putChar((char)v.getType());
                var.putChar('\u0004');
                v.writeBody(var);
                ByteBuffer bvar = var;
                var.putChar(2, (char)bvar.position());
                Log.verb("setting var length to " + bvar.position());
                pad = bvar.position() % 4;
                pad = pad != 0 ? 4 - pad : 0;
                Log.verb("padding by " + pad);
                ((Buffer)bret).position(bret.position() + bvar.position() + pad);
            }
        }
        ((Buffer)bret).position(bret.position() - pad);
        ret.putChar(2, (char)bret.position());
    }

    public String typeLookup() {
        return Chunk.typeLookup(this._type);
    }

    public static String typeLookup(byte t) {
        Integer k = new Integer(0xFF & t);
        Object ret = _typeLookup.get(k);
        if (ret == null) {
            ret = "unknown(" + (0xFF & t) + ")";
        }
        return ret;
    }

    public static String chunksToNames(byte[] fse) {
        StringBuffer ret = new StringBuffer();
        for (byte f : fse) {
            ret.append(Chunk.typeLookup(f));
            ret.append(" ");
        }
        return ret.toString();
    }

    public String toString() {
        return "Chunk : type " + Chunk.typeLookup(this._type) + " flags " + Integer.toHexString(0xFF & this._flags) + " length = " + this._length;
    }

    public int getType() {
        return this._type;
    }

    int getLength() {
        return this._length;
    }

    protected VariableParam readVariable() {
        int mod;
        Unknown var;
        char type = this._body.getChar();
        char len = this._body.getChar();
        int blen = len - 4;
        Object data = null;
        switch (type) {
            case '\u0001': {
                var = new HeartbeatInfo(1, "HeartbeatInfo");
                break;
            }
            case '\u0005': {
                var = new IPv4Address(5, "IPv4Address");
                break;
            }
            case '\u0006': {
                var = new IPv6Address(6, "IPv6Address");
                break;
            }
            case '\u0007': {
                var = new StateCookie(7, "StateCookie");
                break;
            }
            case '\b': {
                var = new UnrecognizedParameters(8, "UnrecognizedParameters");
                break;
            }
            case '\t': {
                var = new CookiePreservative(9, "CookiePreservative");
                break;
            }
            case '\u000b': {
                var = new HostNameAddress(11, "HostNameAddress");
                break;
            }
            case '\f': {
                var = new SupportedAddressTypes(12, "SupportedAddressTypes");
                break;
            }
            case '\r': {
                var = new OutgoingSSNResetRequestParameter(13, "OutgoingSSNResetRequestParameter");
                break;
            }
            case '\u000e': {
                var = new IncomingSSNResetRequestParameter(14, "IncomingSSNResetRequestParameter");
                break;
            }
            case '\u000f': {
                var = new SSNTSNResetRequestParameter(15, "SSNTSNResetRequestParameter");
                break;
            }
            case '\u0010': {
                var = new ReconfigurationResponseParameter(16, "ReconfigurationResponseParameter");
                break;
            }
            case '\u0011': {
                var = new AddOutgoingStreamsRequestParameter(17, "AddOutgoingStreamsRequestParameter");
                break;
            }
            case '\u0012': {
                var = new AddIncomingStreamsRequestParameter(18, "AddIncomingStreamsRequestParameter");
                break;
            }
            case '\u8000': {
                var = new Unknown(32768, "ReservedforECNCapable");
                break;
            }
            case '\u8002': {
                var = new RandomParam(32770, "Random");
                break;
            }
            case '\u8003': {
                var = new ChunkListParam(32771, "ChunkList");
                break;
            }
            case '\u8004': {
                var = new RequestedHMACAlgorithmParameter(32772, "RequestedHMACAlgorithmParameter");
                break;
            }
            case '\u8005': {
                var = new Unknown(32773, "Padding");
                break;
            }
            case '\u8008': {
                var = new SupportedExtensions(32776, "SupportedExtensions");
                break;
            }
            case '\uc000': {
                var = new ForwardTSNsupported(49152, "ForwardTSNsupported");
                break;
            }
            case '\uc001': {
                var = new Unknown(49153, "AddIPAddress");
                break;
            }
            case '\uc002': {
                var = new Unknown(49154, "DeleteIPAddress");
                break;
            }
            case '\uc003': {
                var = new Unknown(49155, "ErrorCauseIndication");
                break;
            }
            case '\uc004': {
                var = new Unknown(49156, "SetPrimaryAddress");
                break;
            }
            case '\uc005': {
                var = new Unknown(49157, "SuccessIndication");
                break;
            }
            case '\uc006': {
                var = new Unknown(49158, "AdaptationLayerIndication");
                break;
            }
            default: {
                var = new Unknown(-1, "Unknown");
            }
        }
        try {
            var.readBody(this._body, blen);
            Log.debug("variable type " + var.getType() + " name " + var.getName());
        }
        catch (SctpPacketFormatException ex) {
            Log.error(ex.getMessage());
        }
        if (this._body.hasRemaining() && (mod = blen % 4) != 0) {
            for (int pad = mod; pad < 4; ++pad) {
                this._body.get();
            }
        }
        return var;
    }

    protected VariableParam readErrorParam() {
        int mod;
        char type = this._body.getChar();
        char len = this._body.getChar();
        int blen = len - 4;
        Object data = null;
        KnownError var = null;
        switch (type) {
            case '\u0001': {
                var = new KnownError(1, "InvalidStreamIdentifier");
                break;
            }
            case '\u0002': {
                var = new KnownError(2, "MissingMandatoryParameter");
                break;
            }
            case '\u0003': {
                var = new StaleCookieError();
                break;
            }
            case '\u0004': {
                var = new KnownError(4, "OutofResource");
                break;
            }
            case '\u0005': {
                var = new KnownError(5, "UnresolvableAddress");
                break;
            }
            case '\u0006': {
                var = new KnownError(6, "UnrecognizedChunkType");
                break;
            }
            case '\u0007': {
                var = new KnownError(7, "InvalidMandatoryParameter");
                break;
            }
            case '\b': {
                var = new KnownError(8, "UnrecognizedParameters");
                break;
            }
            case '\t': {
                var = new KnownError(9, "NoUserData");
                break;
            }
            case '\n': {
                var = new KnownError(10, "CookieReceivedWhileShuttingDown");
                break;
            }
            case '\u000b': {
                var = new KnownError(11, "RestartofanAssociationwithNewAddresses");
                break;
            }
            case '\f': {
                var = new KnownError(12, "UserInitiatedAbort");
                break;
            }
            case '\r': {
                var = new ProtocolViolationError(13, "ProtocolViolation");
                break;
            }
            case '\u00a0': {
                var = new KnownError(160, "RequesttoDeleteLastRemainingIPAddress");
                break;
            }
            case '\u00a1': {
                var = new KnownError(161, "OperationRefusedDuetoResourceShortage");
                break;
            }
            case '\u00a2': {
                var = new KnownError(162, "RequesttoDeleteSourceIPAddress");
                break;
            }
            case '\u00a3': {
                var = new KnownError(163, "AssociationAbortedduetoillegalASCONF-ACK");
                break;
            }
            case '\u00a4': {
                var = new KnownError(164, "Requestrefused-noauthorization");
                break;
            }
            case '\u0105': {
                var = new KnownError(261, "UnsupportedHMACIdentifier");
            }
        }
        try {
            var.readBody(this._body, blen);
            Log.verb("variable type " + var.getType() + " name " + var.getName());
            Log.verb("additional info " + var.toString());
        }
        catch (SctpPacketFormatException ex) {
            Log.error(ex.getMessage());
        }
        if (this._body.hasRemaining() && (mod = blen % 4) != 0) {
            for (int pad = mod; pad < 4; ++pad) {
                this._body.get();
            }
        }
        return var;
    }

    abstract void putFixedParams(ByteBuffer var1);

    public void validate() throws Exception {
    }

    protected static class SupportedExtensions
    extends KnownParam {
        public SupportedExtensions() {
            this(32776, "SupportedExtensions");
        }

        public SupportedExtensions(int t, String n) {
            super(t, n);
        }

        @Override
        public String toString() {
            Object ret = " ChunksTypes ";
            byte[] data = this.getData();
            for (int i = 0; i < data.length; ++i) {
                ret = (String)ret + " " + Chunk.typeLookup(data[i]);
            }
            return super.toString() + (String)ret;
        }
    }

    protected static class ChunkListParam
    extends KnownParam {
        public ChunkListParam(int t, String n) {
            super(t, n);
        }

        @Override
        public String toString() {
            Object ret = " ChunksTypes ";
            byte[] data = this.getData();
            for (int i = 0; i < data.length; ++i) {
                ret = (String)ret + " " + Chunk.typeLookup(data[i]);
            }
            return super.toString() + (String)ret;
        }
    }

    protected static class RandomParam
    extends KnownParam {
        public RandomParam(int t, String n) {
            super(t, n);
        }

        @Override
        public String toString() {
            Object ret = " random value ";
            ret = (String)ret + Packet.getHex(this.getData());
            return super.toString() + (String)ret;
        }
    }

    protected static class ForwardTSNsupported
    extends KnownParam {
        public ForwardTSNsupported(int t, String n) {
            super(t, n);
        }
    }

    protected static class HeartbeatInfo
    extends KnownParam {
        public HeartbeatInfo(int t, String n) {
            super(t, n);
        }
    }
}

