/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;

public class CookieEchoChunk
extends Chunk {
    private byte[] _cookieData;

    public CookieEchoChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        this._cookieData = new byte[this._body.remaining()];
        this._body.get(this._cookieData);
    }

    public CookieEchoChunk() {
        super((byte)10);
    }

    @Override
    public void validate() throws SctpPacketFormatException {
        if (this._cookieData.length != Association.COOKIESIZE) {
            throw new SctpPacketFormatException("cookie Echo wrong length for our association " + this._cookieData.length + " != " + Association.COOKIESIZE);
        }
    }

    public void setCookieData(byte[] cd) {
        this._cookieData = cd;
    }

    public byte[] getCookieData() {
        return this._cookieData;
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
        Log.debug("cookie is " + this._cookieData + "and buffer is " + ret);
        ret.put(this._cookieData);
    }
}

