/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import java.util.Comparator;
import pe.pi.sctp4j.sctp.dataChannel.DECP.DCOpen;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.Packet;
import pe.pi.sctp4j.sctp.messages.exceptions.InvalidDataChunkException;

public class DataChunk
extends Chunk
implements Comparable,
Comparator {
    public static final int WEBRTCCONTROL = 50;
    public static final int WEBRTCSTRING = 51;
    public static final int WEBRTCBINARY = 53;
    public static final int WEBRTCSTRINGEMPTY = 56;
    public static final int WEBRTCBINARYEMPTY = 57;
    public static final int BEGINFLAG = 2;
    public static final int ENDFLAG = 1;
    public static final int SINGLEFLAG = 3;
    public static final int UNORDERED = 4;
    private long _tsn;
    private int _streamId;
    private int _sSeqNo;
    private int _ppid;
    private byte[] _data;
    private int _dataOffset;
    private int _dataLength;
    private DCOpen _open;
    private InvalidDataChunkException _invalid;
    private boolean _gapAck;
    private long _retryTime;
    private int _retryCount;
    private long _sentTime;

    public DataChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        Log.debug("read in chunk header " + length);
        Log.debug("body remaining " + this._body.remaining());
        if (this._body.remaining() >= 12) {
            this._tsn = DataChunk.getUnsignedInt(this._body);
            this._streamId = this._body.getChar();
            this._sSeqNo = this._body.getChar();
            this._ppid = this._body.getInt();
            Log.debug(" _tsn : " + this._tsn + " _streamId : " + this._streamId + " _sSeqNo : " + this._sSeqNo + " _ppid : " + this._ppid);
            Log.debug("data size remaining " + this._body.remaining());
            switch (this._ppid) {
                case 53: {
                    this._data = new byte[this._body.remaining()];
                    this._body.get(this._data);
                    this._dataOffset = 0;
                    this._dataLength = this._data.length;
                    Log.verb("Binary data is " + Packet.getHex(this._data));
                    break;
                }
                case 51: {
                    this._data = new byte[this._body.remaining()];
                    this._body.get(this._data);
                    this._dataOffset = 0;
                    this._dataLength = this._data.length;
                    Log.verb("String data is " + new String(this._data));
                    break;
                }
                case 50: {
                    this._data = new byte[this._body.remaining()];
                    this._body.get(this._data);
                    this._dataOffset = 0;
                    this._dataLength = this._data.length;
                    Log.verb("Dcep data is " + Packet.getHex(this._data));
                    break;
                }
                case 56: {
                    this._data = new byte[0];
                    this._dataOffset = 0;
                    this._dataLength = this._data.length;
                    Log.verb("String data empty");
                    break;
                }
                case 57: {
                    this._data = new byte[0];
                    this._dataOffset = 0;
                    this._dataLength = this._data.length;
                    Log.verb("Binary data empty");
                    break;
                }
                default: {
                    this._invalid = new InvalidDataChunkException("Invalid Protocol Id in data Chunk " + this._ppid);
                }
            }
        }
    }

    public String getDataAsString() {
        Object ret;
        switch (this._ppid) {
            case 50: {
                ret = "Got an DCEP " + this._open;
                break;
            }
            case 51: {
                ret = new String(this._data, this._dataOffset, this._dataLength);
                break;
            }
            case 56: {
                ret = "Empty String message";
                break;
            }
            case 53: {
                byte[] p = new byte[this._dataLength];
                System.arraycopy(this._data, this._dataOffset, p, 0, this._dataLength);
                ret = Packet.getHex(this._data);
                break;
            }
            case 57: {
                ret = "Empty binay message";
                break;
            }
            default: {
                ret = "Invalid Protocol Id in data Chunk " + this._ppid;
            }
        }
        return ret;
    }

    @Override
    public void validate() throws InvalidDataChunkException {
        if (this._invalid != null) {
            throw this._invalid;
        }
    }

    public DataChunk() {
        super((byte)0);
        this.setFlags(0);
    }

    public long getTsn() {
        return this._tsn;
    }

    public int getStreamId() {
        return this._streamId;
    }

    public int getSSeqNo() {
        return this._sSeqNo;
    }

    public int getPpid() {
        return this._ppid;
    }

    public byte[] getData() {
        return this._data;
    }

    public DCOpen getDCEP() {
        return this._open;
    }

    public void setPpid(int pp) {
        this._ppid = pp;
    }

    public int getDataSize() {
        return this._dataLength;
    }

    public int getChunkLength() {
        int len = super.getLength();
        if (len == 0) {
            len = this._dataLength + 12 + 4;
        }
        return len;
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
        DataChunk.putUnsignedInt(ret, this._tsn);
        ret.putChar((char)this._streamId);
        ret.putChar((char)this._sSeqNo);
        ret.putInt(this._ppid);
        ret.put(this._data, this._dataOffset, this._dataLength);
    }

    public void setTsn(long tsn) {
        this._tsn = tsn;
    }

    public void setStreamId(int streamId) {
        this._streamId = streamId;
    }

    public void setsSeqNo(int sSeqNo) {
        this._sSeqNo = sSeqNo;
    }

    @Override
    public String toString() {
        Object ret = super.toString();
        ret = (String)ret + " ppid=" + this._ppid + " seqn=" + this._sSeqNo + " streamId=" + this._streamId + " tsn=" + this._tsn + " retryAt=" + this._retryTime + " retryCount=" + this._retryCount + " sentTime=" + this._sentTime + " gapacked=" + this._gapAck;
        return ret;
    }

    public void setFlags(int flag) {
        this._flags = (byte)flag;
    }

    public int getFlags() {
        return this._flags;
    }

    public static int getCapacity() {
        return 1024;
    }

    public void setData(byte[] data) {
        this._data = data;
        this._dataLength = data.length;
        this._dataOffset = 0;
    }

    public void setData(byte[] data, int offs, int len) {
        this._data = data;
        this._dataLength = len;
        this._dataOffset = offs;
    }

    public void setGapAck(boolean b) {
        this._gapAck = b;
    }

    public boolean getGapAck() {
        return this._gapAck;
    }

    public void setRetryTime(long l) {
        this._retryTime = l;
        ++this._retryCount;
    }

    public long getRetryTime() {
        return this._retryTime;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public int compare(Object o1, Object o2) {
        return (int)(((DataChunk)o1)._tsn - ((DataChunk)o2)._tsn);
    }

    public long getSentTime() {
        return this._sentTime;
    }

    public void setSentTime(long now) {
        this._sentTime = now;
    }

    public void clean() {
        this._tsn = 0L;
        this._streamId = 0;
        this._sSeqNo = 0;
        this._ppid = 0;
        this._data = null;
        this._dataOffset = 0;
        this._dataLength = 0;
        this._open = null;
        this._invalid = null;
        this._gapAck = false;
        this._retryTime = 0L;
        this._retryCount = 0;
        this._sentTime = 0L;
    }

    public void incrementRetryCount() {
        ++this._retryCount;
        Log.verb(" retry count is now " + this._retryCount + " on " + this._tsn);
    }
}

