/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.HeartBeatAckChunk;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;
import pe.pi.sctp4j.sctp.messages.params.VariableParam;

public class HeartBeatChunk
extends Chunk {
    public HeartBeatChunk() throws SctpPacketFormatException {
        super((byte)4);
        Chunk.HeartbeatInfo req = new Chunk.HeartbeatInfo(1, "HeartbeatInfo");
        String t = "" + System.currentTimeMillis();
        req.setData(t.getBytes());
        Log.debug("adding " + req + " to " + this);
        this._varList.add(req);
        this.validate();
    }

    public HeartBeatChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        if (this._body.remaining() >= 4) {
            while (this._body.hasRemaining()) {
                VariableParam v = this.readVariable();
                this._varList.add(v);
            }
        }
    }

    @Override
    public void validate() throws SctpPacketFormatException {
        if (this._varList == null || this._varList.size() != 1) {
            throw new SctpPacketFormatException("No (or too much content in this heartbeat packet");
        }
        VariableParam hbd = (VariableParam)this._varList.get(0);
        if (!(hbd instanceof Chunk.HeartbeatInfo)) {
            throw new SctpPacketFormatException("Expected a heartbeatinfo in this packet");
        }
    }

    public Chunk[] mkReply() {
        Chunk[] rep = new Chunk[1];
        HeartBeatAckChunk dub = new HeartBeatAckChunk();
        dub._varList = this._varList;
        rep[0] = dub;
        return rep;
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
    }
}

