/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.RequestedHMACAlgorithmParameter;
import pe.pi.sctp4j.sctp.messages.params.VariableParam;

public class InitChunk
extends Chunk {
    long _initiateTag;
    long _adRecWinCredit;
    int _numOutStreams;
    int _numInStreams;
    long _initialTSN;
    byte[] _farSupportedExtensions;
    byte[] _farRandom;
    boolean _farForwardTSNsupported;
    byte[] _farHmacs;
    byte[] _farChunks;
    public int _outStreams;

    public InitChunk() {
        super((byte)1);
    }

    public InitChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        if (this._body.remaining() >= 16) {
            this._initiateTag = this._body.getInt();
            this._adRecWinCredit = InitChunk.getUnsignedInt(this._body);
            this._numOutStreams = this._body.getChar();
            this._numInStreams = this._body.getChar();
            this._initialTSN = InitChunk.getUnsignedInt(this._body);
            Log.verb("Init " + this.toString());
            while (this._body.hasRemaining()) {
                VariableParam v = this.readVariable();
                this._varList.add(v);
            }
            for (VariableParam v : this._varList) {
                Log.verb("variable of type: " + v.getName() + " " + v.toString());
                if (v instanceof Chunk.SupportedExtensions) {
                    this._farSupportedExtensions = ((Chunk.SupportedExtensions)v).getData();
                    continue;
                }
                if (v instanceof Chunk.RandomParam) {
                    this._farRandom = ((Chunk.RandomParam)v).getData();
                    continue;
                }
                if (v instanceof Chunk.ForwardTSNsupported) {
                    this._farForwardTSNsupported = true;
                    continue;
                }
                if (v instanceof RequestedHMACAlgorithmParameter) {
                    this._farHmacs = ((RequestedHMACAlgorithmParameter)v).getData();
                    continue;
                }
                if (v instanceof Chunk.ChunkListParam) {
                    this._farChunks = ((Chunk.ChunkListParam)v).getData();
                    continue;
                }
                Log.debug("unexpected variable of type: " + v.getName());
            }
        }
    }

    @Override
    public String toString() {
        Object ret = super.toString();
        ret = (String)ret + " initiateTag : " + this._initiateTag + " adRecWinCredit : " + this._adRecWinCredit + " numOutStreams : " + this._numOutStreams + " numInStreams : " + this._numInStreams + " initialTSN : " + this._initialTSN + " farForwardTSNsupported : " + this._farForwardTSNsupported + (String)(this._farSupportedExtensions == null ? " no supported extensions" : " supported extensions are: " + InitChunk.chunksToNames(this._farSupportedExtensions));
        return ret;
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
        ret.putInt((int)this._initiateTag);
        InitChunk.putUnsignedInt(ret, this._adRecWinCredit);
        ret.putChar((char)this._numOutStreams);
        ret.putChar((char)this._numInStreams);
        Chunk.putUnsignedInt(ret, this._initialTSN);
    }

    public int getInitiateTag() {
        return (int)this._initiateTag;
    }

    public long getAdRecWinCredit() {
        return this._adRecWinCredit;
    }

    public int getNumOutStreams() {
        return this._numOutStreams;
    }

    public int getNumInStreams() {
        return this._numInStreams;
    }

    public long getInitialTSN() {
        return this._initialTSN;
    }

    public void setInitialTSN(long tsn) {
        this._initialTSN = tsn;
    }

    public void setAdRecWinCredit(long credit) {
        this._adRecWinCredit = credit;
    }

    public void setNumOutStreams(int outn) {
        this._numOutStreams = outn;
    }

    public void setNumInStreams(int inn) {
        this._numInStreams = inn;
    }

    public byte[] getFarSupportedExtensions() {
        return this._farSupportedExtensions;
    }

    public void setInitiate(long tag) {
        this._initiateTag = tag;
    }
}

