/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import com.phono.srtplight.Log;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.Crc32c;
import pe.pi.sctp4j.sctp.messages.exceptions.ChecksumException;
import pe.pi.sctp4j.sctp.messages.exceptions.InvalidSCTPPacketException;
import pe.pi.sctp4j.sctp.messages.exceptions.SctpPacketFormatException;

public class Packet {
    static int MTU = 1500;
    char _srcPort;
    char _destPort;
    int _verTag;
    int _chksum;
    List<Chunk> _chunks;
    private static int SUMOFFSET = 8;

    public Packet(ByteBuffer pkt) throws SctpPacketFormatException, ChecksumException {
        if (pkt.limit() < 12) {
            throw new SctpPacketFormatException("SCTP packet too short expected 12 bytes, got " + pkt.limit());
        }
        this.checkChecksum(pkt);
        this._srcPort = pkt.getChar();
        this._destPort = pkt.getChar();
        this._verTag = pkt.getInt();
        this._chksum = pkt.getInt();
        this._chunks = this.mkChunks(pkt);
        ((Buffer)pkt).rewind();
    }

    public Packet(int sp, int dp, int vertag) {
        this._srcPort = (char)sp;
        this._destPort = (char)dp;
        this._verTag = vertag;
        this._chunks = new ArrayList<Chunk>();
    }

    public ByteBuffer getByteBuffer() throws SctpPacketFormatException {
        ByteBuffer ret = ByteBuffer.allocate(MTU);
        ret.putChar(this._srcPort);
        ret.putChar(this._destPort);
        ret.putInt(this._verTag);
        ret.putInt(this._chksum);
        ByteBuffer bret = ret;
        int pad = 0;
        for (Chunk c : this._chunks) {
            ByteBuffer cs = ret.slice();
            c.write(cs);
            ByteBuffer bcs = cs;
            pad = bcs.position() % 4;
            pad = pad != 0 ? 4 - pad : 0;
            Log.verb("padding by " + pad);
            ((Buffer)bret).position(pad + bret.position() + bcs.position());
        }
        ret = (ByteBuffer)((Buffer)bret).flip();
        this.setChecksum(ret);
        return ret;
    }

    public int getSrcPort() {
        return this._srcPort;
    }

    public int getDestPort() {
        return this._destPort;
    }

    public long getVerTag() {
        return this._verTag;
    }

    public long getChksum() {
        return this._chksum;
    }

    public static String getHex(ByteBuffer in) {
        byte[] bin = new byte[in.limit()];
        in.get(bin);
        return Packet.getHex(bin, bin.length);
    }

    public static String getHex(byte[] in) {
        return Packet.getHex(in, in.length);
    }

    public static String getHex(byte[] in, int len) {
        char[] cmap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer ret = new StringBuffer();
        int top = Math.min(in.length, len);
        for (int i = 0; i < top; ++i) {
            ret.append(cmap[0xF & in[i] >>> 4]);
            ret.append(cmap[in[i] & 0xF]);
        }
        return ret.toString();
    }

    private List<Chunk> mkChunks(ByteBuffer pkt) {
        ArrayList<Chunk> ret = new ArrayList<Chunk>();
        Chunk next = null;
        while (null != (next = Chunk.mkChunk(pkt))) {
            ret.add(next);
            Log.debug("saw chunk: " + next.typeLookup());
        }
        return ret;
    }

    public List<Chunk> getChunkList() {
        return this._chunks;
    }

    void setChecksum(ByteBuffer pkt) {
        byte[] b = new byte[4];
        pkt.putInt(SUMOFFSET, 0);
        Crc32c crc = new Crc32c();
        crc.update(pkt.array(), pkt.arrayOffset(), pkt.limit());
        long result = crc.getValue();
        b[0] = (byte)(result & 0xFFL);
        b[1] = (byte)(result >> 8 & 0xFFL);
        b[2] = (byte)(result >> 16 & 0xFFL);
        b[3] = (byte)(result >> 24 & 0xFFL);
        long flip = ((0xFF & b[0]) << 24) + ((0xFF & b[1]) << 16) + ((0xFF & b[2]) << 8) + (0xFF & b[3]);
        pkt.putInt(8, (int)flip);
    }

    void checkChecksum(ByteBuffer pkt) throws ChecksumException {
        long farsum = pkt.getInt(SUMOFFSET);
        this.setChecksum(pkt);
        long calc = pkt.getInt(SUMOFFSET);
        if (calc != farsum) {
            Log.error("Checksums don't match " + Long.toHexString(calc) + " vs " + Long.toHexString(farsum));
            byte[] p = pkt.array();
            Log.error("for packet " + Packet.getHex(p));
            throw new ChecksumException();
        }
    }

    private void reflectedVerify(int cno, Association ass) throws InvalidSCTPPacketException {
        int cverTag;
        Chunk chunk = this._chunks.get(cno);
        boolean t = (Chunk.TBIT & chunk._flags) > 0;
        int n = cverTag = t ? ass.getPeerVerTag() : ass.getMyVerTag();
        if (cverTag != this._verTag) {
            throw new InvalidSCTPPacketException("VerTag on an " + chunk.typeLookup() + " doesn't match " + (t ? "their " : "our ") + " vertag " + this._verTag + " != " + cverTag);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate(Association ass) throws InvalidSCTPPacketException {
        if (this._chunks == null || this._chunks.size() <= 0) return;
        int init = this.findChunk(1);
        if (init >= 0) {
            if (init != 0) {
                throw new InvalidSCTPPacketException("Init must be only chunk in a packet");
            }
            if (this._verTag == 0) return;
            throw new InvalidSCTPPacketException("VerTag on an init packet expected to be Zeros");
        }
        int abo = this.findChunk(6);
        if (abo >= 0) {
            this._chunks = this._chunks.subList(0, abo + 1);
            this.reflectedVerify(abo, ass);
            return;
        } else {
            int sdc = this.findChunk(14);
            if (sdc >= 0) {
                if (sdc != 0) throw new InvalidSCTPPacketException("SHUTDOWN_COMPLETE must be only chunk in a packet");
                this.reflectedVerify(sdc, ass);
                return;
            } else {
                if (this._verTag == ass.getMyVerTag()) return;
                throw new InvalidSCTPPacketException("VerTag on plain packet expected to match ours " + this._verTag + " != " + ass.getMyVerTag());
            }
        }
    }

    private int findChunk(int ty) {
        byte bty = (byte)ty;
        int ret = 0;
        for (Chunk c : this._chunks) {
            if (c._type == bty) break;
            ++ret;
        }
        return ret < this._chunks.size() ? ret : -1;
    }
}

