/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import pe.pi.sctp4j.sctp.messages.Chunk;

public class SackChunk
extends Chunk {
    GapBlock[] _gaps;
    long[] _duplicateTSNs;
    private long _cumuTSNAck;
    private long _arWin;

    public long getCumuTSNAck() {
        return this._cumuTSNAck;
    }

    public void setCumuTSNAck(long cumuTSNAck) {
        this._cumuTSNAck = cumuTSNAck;
    }

    public long getArWin() {
        return this._arWin;
    }

    public void setArWin(long arWin) {
        this._arWin = Math.max(arWin, 0L);
    }

    public SackChunk(byte type, byte flags, int length, ByteBuffer pkt) {
        super(type, flags, length, pkt);
        int i;
        this._cumuTSNAck = Chunk.getUnsignedInt(this._body);
        this._arWin = Chunk.getUnsignedInt(this._body);
        int ngaps = this._body.getChar();
        int nDTSNs = this._body.getChar();
        this._gaps = new GapBlock[ngaps];
        this._duplicateTSNs = new long[nDTSNs];
        for (i = 0; i < ngaps; ++i) {
            this._gaps[i] = new GapBlock(this._body);
        }
        for (i = 0; i < nDTSNs; ++i) {
            this._duplicateTSNs[i] = Chunk.getUnsignedInt(this._body);
        }
    }

    public GapBlock[] getGaps() {
        return this._gaps;
    }

    public long[] getDupTSNs() {
        return this._duplicateTSNs;
    }

    public SackChunk() {
        super((byte)3);
        this._gaps = new GapBlock[0];
        this._duplicateTSNs = new long[0];
    }

    public void setDuplicates(ArrayList<Long> dups) {
        this._duplicateTSNs = new long[dups.size()];
        int i = 0;
        for (Long du : dups) {
            this._duplicateTSNs[i++] = du;
        }
    }

    public void setGaps(ArrayList<Long> seenTsns) {
        long cuTsn = this._cumuTSNAck;
        ArrayList<GapBlock> gaplist = new ArrayList<GapBlock>();
        GapBlock currentGap = null;
        int prevoff = 0;
        for (Long t : seenTsns) {
            char offs = (char)(t - cuTsn);
            if (currentGap == null) {
                currentGap = new GapBlock(offs);
                currentGap.setEnd(offs);
                gaplist.add(currentGap);
            } else if (offs == prevoff + 1) {
                currentGap.setEnd(offs);
            } else {
                currentGap = new GapBlock(offs);
                currentGap.setEnd(offs);
                gaplist.add(currentGap);
            }
            prevoff = offs;
        }
        this._gaps = new GapBlock[gaplist.size()];
        int i = 0;
        for (GapBlock g : gaplist) {
            this._gaps[i++] = g;
        }
    }

    @Override
    void putFixedParams(ByteBuffer ret) {
        int i;
        Chunk.putUnsignedInt(ret, this._cumuTSNAck);
        Chunk.putUnsignedInt(ret, this._arWin);
        ret.putChar((char)this._gaps.length);
        ret.putChar((char)this._duplicateTSNs.length);
        for (i = 0; i < this._gaps.length; ++i) {
            this._gaps[i].put(ret);
        }
        for (i = 0; i < this._duplicateTSNs.length; ++i) {
            Chunk.putUnsignedInt(ret, this._duplicateTSNs[i]);
        }
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer("SACK cumuTSNAck=" + this._cumuTSNAck).append(" _arWin=" + this._arWin).append(" _gaps=" + this._gaps.length + " [");
        for (GapBlock g : this._gaps) {
            ret.append("\n\t{" + g._start + "," + g._end + "}");
        }
        ret.append("]\n _duplicateTSNs=" + this._duplicateTSNs.length);
        for (long t : this._duplicateTSNs) {
            ret.append("\n\t" + t);
        }
        return ret.toString();
    }

    public class GapBlock {
        char _start;
        char _end;

        GapBlock(ByteBuffer b) {
            this._start = b.getChar();
            this._end = b.getChar();
        }

        GapBlock(char start) {
            this._start = start;
        }

        void setEnd(char end) {
            this._end = end;
        }

        private void put(ByteBuffer b) {
            b.putChar(this._start);
            b.putChar(this._end);
        }

        public char getStart() {
            return this._start;
        }

        public char getEnd() {
            return this._end;
        }
    }
}

