/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages.params;

import com.phono.srtplight.Log;
import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;

public class IncomingSSNResetRequestParameter
extends KnownParam {
    long reqSeqNo;
    int[] streams;

    public IncomingSSNResetRequestParameter(int t, String n) {
        super(t, n);
    }

    public IncomingSSNResetRequestParameter() {
        super(14, "IncomingSSNResetRequestParameter");
    }

    public IncomingSSNResetRequestParameter(long reqNo) {
        this();
        this.reqSeqNo = reqNo;
    }

    @Override
    public void readBody(ByteBuffer body, int blen) {
        if (blen < 4) {
            Log.error("Huh ? No body to this " + this.getName());
            return;
        }
        this.reqSeqNo = Chunk.getUnsignedInt(body);
        if (blen > 4) {
            this.streams = new int[(blen - 4) / 2];
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i] = body.getChar();
            }
        } else {
            this.streams = new int[0];
            Log.warn("No inbound stream mentioned");
        }
    }

    @Override
    public void writeBody(ByteBuffer body) {
        Chunk.putUnsignedInt(body, this.reqSeqNo);
        if (this.streams != null) {
            for (int i = 0; i < this.streams.length; ++i) {
                body.putChar((char)this.streams[i]);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getClass().getSimpleName()).append(" ");
        ret.append("seq:" + this.reqSeqNo);
        if (this.streams != null) {
            ret.append("streams {");
            for (int s2 : this.streams) {
                ret.append("" + s2);
            }
            ret.append("}");
        } else {
            ret.append("no streams");
        }
        return ret.toString();
    }

    public boolean sameAs(IncomingSSNResetRequestParameter other) {
        return this.reqSeqNo == other.reqSeqNo;
    }

    public int[] getStreams() {
        return this.streams;
    }

    public long getReqNo() {
        return this.reqSeqNo;
    }

    public void setStreams(int[] ss) {
        this.streams = ss;
    }
}

