/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages.params;

import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;

public class OutgoingSSNResetRequestParameter
extends KnownParam {
    long reqSeqNo;
    long respSeqNo;
    long lastTsn;
    int[] streams;

    public OutgoingSSNResetRequestParameter(int t, String n) {
        super(t, n);
    }

    public OutgoingSSNResetRequestParameter() {
        super(13, "OutgoingSSNResetRequestParameter");
    }

    public OutgoingSSNResetRequestParameter(long reqNo, long respNo, long lastTsn) {
        this();
        this.respSeqNo = respNo;
        this.lastTsn = lastTsn;
        this.reqSeqNo = reqNo;
    }

    public long getRespSeqNo() {
        return this.respSeqNo;
    }

    public long getReqSeqNo() {
        return this.reqSeqNo;
    }

    @Override
    public void readBody(ByteBuffer body, int blen) {
        this.reqSeqNo = Chunk.getUnsignedInt(body);
        this.respSeqNo = Chunk.getUnsignedInt(body);
        this.lastTsn = Chunk.getUnsignedInt(body);
        this.streams = new int[(blen - 12) / 2];
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i] = body.getChar();
        }
    }

    @Override
    public void writeBody(ByteBuffer body) {
        Chunk.putUnsignedInt(body, this.reqSeqNo);
        Chunk.putUnsignedInt(body, this.respSeqNo);
        Chunk.putUnsignedInt(body, this.lastTsn);
        if (this.streams != null) {
            for (int i = 0; i < this.streams.length; ++i) {
                body.putChar((char)this.streams[i]);
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getClass().getSimpleName()).append(" ");
        ret.append("reqseq:").append(this.reqSeqNo).append(" ");
        ret.append("respseq:").append(this.respSeqNo).append(" ");
        ret.append("latsTSN:").append(this.lastTsn).append(" ");
        if (this.streams != null) {
            ret.append("streams {");
            for (int s2 : this.streams) {
                ret.append("" + s2);
            }
            ret.append("}");
        } else {
            ret.append("no streams");
        }
        return ret.toString();
    }

    public long getLastAssignedTSN() {
        return this.lastTsn;
    }

    public int[] getStreams() {
        return this.streams;
    }

    public void setStreams(int[] ss) {
        this.streams = ss;
    }

    public boolean sameAs(OutgoingSSNResetRequestParameter other) {
        return this.reqSeqNo == other.reqSeqNo;
    }
}

