/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages.params;

import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.Chunk;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;

public class ReconfigurationResponseParameter
extends KnownParam {
    long seqNo;
    long result;
    long senderNextTSN;
    long receiverNextTSN;
    boolean hasTSNs;
    public static final int SUCCESS_NOTHING_TO_DO = 0;
    public static final int SUCCESS_PERFORMED = 1;
    public static final int DENIED = 2;
    public static final int ERROR_WRONG_SSN = 3;
    public static final int ERROR_REQUEST_ALREADY_IN_PROGESS = 4;
    public static final int ERROR_BAD_SEQUENCE_NUMBER = 5;
    public static final int IN_PROGRESS = 6;
    static final String[] valuenames = new String[]{"Success - Nothing to do", "Success - Performed", "Denied", "Error - Wrong SSN", "Error - Request already in progress", "Error - Bad Sequence Number", "In progress"};

    public ReconfigurationResponseParameter(int t, String n) {
        super(t, n);
    }

    public ReconfigurationResponseParameter() {
        this(16, "ReconfigurationResponseParameter");
    }

    @Override
    public void readBody(ByteBuffer body, int blen) {
        this.seqNo = Chunk.getUnsignedInt(body);
        this.result = Chunk.getUnsignedInt(body);
        if (blen == 16) {
            this.senderNextTSN = Chunk.getUnsignedInt(body);
            this.receiverNextTSN = Chunk.getUnsignedInt(body);
            this.hasTSNs = true;
        }
    }

    @Override
    public void writeBody(ByteBuffer body) {
        Chunk.putUnsignedInt(body, this.seqNo);
        Chunk.putUnsignedInt(body, this.result);
        if (this.hasTSNs) {
            Chunk.putUnsignedInt(body, this.senderNextTSN);
            Chunk.putUnsignedInt(body, this.receiverNextTSN);
        }
    }

    private String resultToName() {
        return this.result >= 0L && this.result < (long)valuenames.length ? valuenames[(int)this.result] : "invalid value";
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(this.getClass().getSimpleName()).append(" ");
        ret.append("seqNo:").append(this.seqNo).append(" ");
        ret.append("result:").append(this.resultToName()).append(" ");
        if (this.hasTSNs) {
            ret.append("senderNextTSN:").append(this.senderNextTSN).append(" ");
            ret.append("receiverNextTSN:").append(this.receiverNextTSN).append(" ");
        }
        return ret.toString();
    }

    public void setResult(int res) {
        this.result = res;
    }

    public void setSeq(long reqSeqNo) {
        this.seqNo = reqSeqNo;
    }
}

