/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.messages.params;

import java.nio.ByteBuffer;
import pe.pi.sctp4j.sctp.messages.params.KnownParam;

public class RequestedHMACAlgorithmParameter
extends KnownParam {
    int[] hmacs;

    public RequestedHMACAlgorithmParameter(int t, String n) {
        super(t, n);
    }

    @Override
    public void readBody(ByteBuffer body, int blen) {
        this.hmacs = new int[blen / 2];
        for (int i = 0; i < this.hmacs.length; ++i) {
            this.hmacs[i] = body.getChar();
        }
    }

    @Override
    public void writeBody(ByteBuffer body) {
        if (this.hmacs != null) {
            for (int i = 0; i < this.hmacs.length; ++i) {
                body.putChar((char)this.hmacs[i]);
            }
        }
    }

    @Override
    public String toString() {
        Object ret = " Hmacs are ";
        block5: for (int i = 0; i < this.hmacs.length; ++i) {
            switch (this.hmacs[i]) {
                case 0: 
                case 2: {
                    ret = (String)ret + " Reserved ";
                    continue block5;
                }
                case 1: {
                    ret = (String)ret + " SHA-1 ";
                    continue block5;
                }
                case 3: {
                    ret = (String)ret + " SHA-256 ";
                }
            }
        }
        return super.toString() + (String)ret;
    }

    public boolean doesSha256() {
        boolean ret = false;
        for (int i = 0; i < this.hmacs.length; ++i) {
            if (3 != this.hmacs[i]) continue;
            ret = true;
        }
        return ret;
    }
}

