/*
 * Decompiled with CFR 0.152.
 */
package pe.pi.sctp4j.sctp.small;

import com.phono.srtplight.Log;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import pe.pi.sctp4j.sctp.Association;
import pe.pi.sctp4j.sctp.behave.SCTPStreamBehaviour;
import pe.pi.sctp4j.sctp.behave.UnorderedStreamBehaviour;
import pe.pi.sctp4j.sctp.small.BlockingSCTPStream;
import pe.pi.sctp4j.sctp.small.ThreadedAssociation;

public class UDPForwardingStream
extends BlockingSCTPStream
implements Runnable {
    DatagramSocket _udpSock = new DatagramSocket();
    private final Thread _rcv;

    public UDPForwardingStream(Association a, Integer id, Integer toPort) throws SocketException {
        super((ThreadedAssociation)a, id);
        InetSocketAddress addr = new InetSocketAddress("localhost", (int)toPort.shortValue());
        this._udpSock.bind(addr);
        this._rcv = new Thread((Runnable)this, "UDPForwarding_rcv");
        this._rcv.start();
        SCTPStreamBehaviour behave = this.mkBehave();
        super.setBehave(behave);
    }

    @Override
    public void run() {
        try {
            this._udpSock.setSoTimeout(1000);
            byte[] buff = new byte[4096];
            DatagramPacket dgp = new DatagramPacket(buff, buff.length);
            while (this._rcv != null) {
                try {
                    this._udpSock.receive(dgp);
                    int l = dgp.getLength();
                    if (l > buff.length) {
                        Log.warn("truncated packet from " + this._udpSock.getRemoteSocketAddress().toString());
                        l = buff.length;
                    }
                    byte[] pkt = new byte[l];
                    System.arraycopy(buff, 0, pkt, 0, l);
                    this.send(pkt);
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SCTPStreamBehaviour mkBehave() {
        return new UnorderedStreamBehaviour();
    }
}

