/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.BodyAdapter;
import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import com.github.mizosoft.methanol.TypeRef;
import com.github.mizosoft.methanol.internal.extensions.MimeBodyPublisherAdapter;
import java.net.http.HttpRequest;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MoreBodyPublishers {
    private MoreBodyPublishers() {
    }

    public static MimeBodyPublisher ofMediaType(HttpRequest.BodyPublisher bodyPublisher, MediaType mediaType) {
        return new MimeBodyPublisherAdapter(bodyPublisher, mediaType);
    }

    public static HttpRequest.BodyPublisher ofObject(Object object, @Nullable MediaType mediaType) {
        TypeRef<?> runtimeType = TypeRef.from(object.getClass());
        BodyAdapter.Encoder encoder = BodyAdapter.Encoder.getEncoder(runtimeType, mediaType).orElseThrow(() -> MoreBodyPublishers.unsupportedConversion(runtimeType, mediaType));
        return encoder.toBody(object, mediaType);
    }

    private static UnsupportedOperationException unsupportedConversion(TypeRef<?> type, @Nullable MediaType mediaType) {
        String message = "unsupported conversion from an object type <" + type + ">";
        if (mediaType != null) {
            message = message + " with media type <" + mediaType + ">";
        }
        return new UnsupportedOperationException(message);
    }
}

