/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol;

import com.github.mizosoft.methanol.MediaType;
import com.github.mizosoft.methanol.MimeBodyPublisher;
import com.github.mizosoft.methanol.MoreBodyPublishers;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.flow.AbstractSubscription;
import com.github.mizosoft.methanol.internal.flow.FlowSupport;
import com.github.mizosoft.methanol.internal.flow.Prefetcher;
import com.github.mizosoft.methanol.internal.flow.Upstream;
import com.github.mizosoft.methanol.internal.text.CharMatcher;
import com.github.mizosoft.methanol.internal.text.HttpCharMatchers;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Flow;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MultipartBodyPublisher
implements MimeBodyPublisher {
    private static final System.Logger logger = System.getLogger(MultipartBodyPublisher.class.getName());
    private static final long UNKNOWN_LENGTH = -1L;
    private static final long UNINITIALIZED_LENGTH = -2L;
    private static final String BOUNDARY_ATTRIBUTE = "boundary";
    private final List<Part> parts;
    private final MediaType mediaType;
    private long contentLength;

    private MultipartBodyPublisher(List<Part> parts, MediaType mediaType) {
        this.parts = parts;
        this.mediaType = mediaType;
        this.contentLength = -2L;
    }

    public String boundary() {
        return Validate.castNonNull(this.mediaType.parameters().get(BOUNDARY_ATTRIBUTE));
    }

    public List<Part> parts() {
        return this.parts;
    }

    @Override
    public MediaType mediaType() {
        return this.mediaType;
    }

    @Override
    public long contentLength() {
        long len = this.contentLength;
        if (len == -2L) {
            this.contentLength = len = this.computeLength();
        }
        return len;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber);
        new MultipartSubscription(this, subscriber).signal(true);
    }

    private long computeLength() {
        long lengthOfParts = 0L;
        String boundary = this.boundary();
        StringBuilder headings = new StringBuilder();
        int sz = this.parts.size();
        for (int i = 0; i < sz; ++i) {
            Part part = this.parts.get(i);
            long partLength = part.bodyPublisher().contentLength();
            if (partLength < 0L) {
                return -1L;
            }
            lengthOfParts += partLength;
            BoundaryAppender.get(i, sz).append(headings, boundary);
            MultipartBodyPublisher.appendPartHeaders(headings, part);
            headings.append("\r\n");
        }
        BoundaryAppender.LAST.append(headings, boundary);
        return lengthOfParts + (long)StandardCharsets.UTF_8.encode(CharBuffer.wrap(headings)).remaining();
    }

    private static void appendPartHeaders(StringBuilder target, Part part) {
        part.headers().map().forEach((n, vs) -> vs.forEach(v -> MultipartBodyPublisher.appendHeader(target, n, v)));
        HttpRequest.BodyPublisher publisher = part.bodyPublisher();
        if (publisher instanceof MimeBodyPublisher) {
            MultipartBodyPublisher.appendHeader(target, "Content-Type", ((MimeBodyPublisher)publisher).mediaType().toString());
        }
    }

    private static void appendHeader(StringBuilder target, String name, String value2) {
        target.append(name).append(": ").append(value2).append("\r\n");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static final class MultipartSubscription
    extends AbstractSubscription<ByteBuffer> {
        private static final VarHandle PART_SUBSCRIBER;
        private static final Flow.Subscriber<ByteBuffer> CANCELLED;
        private final String boundary;
        private final List<Part> parts;
        private volatile  @MonotonicNonNull Flow.Subscriber<ByteBuffer> partSubscriber;
        private int partIndex;
        private boolean complete;
        private final List<PartSequenceListener> listeners = new CopyOnWriteArrayList<PartSequenceListener>();

        MultipartSubscription(MultipartBodyPublisher upstream, Flow.Subscriber<? super ByteBuffer> downstream) {
            super(downstream, FlowSupport.SYNC_EXECUTOR);
            this.boundary = upstream.boundary();
            this.parts = upstream.parts();
        }

        void registerListener(PartSequenceListener listener) {
            this.listeners.add(listener.guarded());
        }

        @Override
        protected long emit(Flow.Subscriber<? super ByteBuffer> downstream, long emit) {
            long submitted = 0L;
            while (true) {
                ByteBuffer batch;
                if (this.complete) {
                    this.cancelOnComplete(downstream);
                    return 0L;
                }
                if (submitted >= emit || (batch = this.pollNext()) == null) {
                    return submitted;
                }
                if (!this.submitOnNext(downstream, batch)) break;
                ++submitted;
            }
            return 0L;
        }

        @Override
        protected void abort(boolean flowInterrupted) {
            Flow.Subscriber previous = PART_SUBSCRIBER.getAndSet(this, CANCELLED);
            if (previous instanceof PartSubscriber) {
                ((PartSubscriber)previous).abortUpstream(flowInterrupted);
            }
        }

        private @Nullable ByteBuffer pollNext() {
            ByteBuffer next;
            Flow.Subscriber<ByteBuffer> subscriber = this.partSubscriber;
            if (subscriber instanceof PartSubscriber && (next = ((PartSubscriber)subscriber).pollNext()) != PartSubscriber.END_OF_PART) {
                return next;
            }
            return subscriber != CANCELLED ? this.nextPartHeaders() : null;
        }

        private @Nullable ByteBuffer nextPartHeaders() {
            StringBuilder heading = new StringBuilder();
            BoundaryAppender.get(this.partIndex, this.parts.size()).append(heading, this.boundary);
            if (this.partIndex < this.parts.size()) {
                Part part;
                if (!this.subscribeToPart(part = this.parts.get(this.partIndex++))) {
                    return null;
                }
                MultipartBodyPublisher.appendPartHeaders(heading, part);
                heading.append("\r\n");
                this.listeners.forEach(listener -> listener.onNextPart(part));
            } else {
                this.partSubscriber = CANCELLED;
                this.complete = true;
                this.listeners.forEach(PartSequenceListener::onSequenceCompletion);
            }
            return StandardCharsets.UTF_8.encode(CharBuffer.wrap(heading));
        }

        private boolean subscribeToPart(Part part) {
            PartSubscriber subscriber = new PartSubscriber(this);
            Flow.Subscriber<ByteBuffer> current = this.partSubscriber;
            if (current != CANCELLED && PART_SUBSCRIBER.compareAndSet(this, current, subscriber)) {
                part.bodyPublisher().subscribe(subscriber);
                return true;
            }
            return false;
        }

        static {
            try {
                PART_SUBSCRIBER = MethodHandles.lookup().findVarHandle(MultipartSubscription.class, "partSubscriber", Flow.Subscriber.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
            CANCELLED = new Flow.Subscriber<ByteBuffer>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                }

                @Override
                public void onNext(ByteBuffer item) {
                }

                @Override
                public void onError(Throwable throwable) {
                }

                @Override
                public void onComplete() {
                }
            };
        }
    }

    public static final class Part {
        private static final CharMatcher TOKEN_MATCHER = CharMatcher.chars("!#$%&'*+-.^_`|~").or(CharMatcher.alphaNum());
        private final HttpHeaders headers;
        private final HttpRequest.BodyPublisher bodyPublisher;

        Part(HttpHeaders headers, HttpRequest.BodyPublisher bodyPublisher) {
            Objects.requireNonNull(headers, "headers");
            Objects.requireNonNull(bodyPublisher, "bodyPublisher");
            Part.validateHeaderNames(headers.map().keySet(), bodyPublisher);
            this.headers = headers;
            this.bodyPublisher = bodyPublisher;
        }

        public HttpHeaders headers() {
            return this.headers;
        }

        public HttpRequest.BodyPublisher bodyPublisher() {
            return this.bodyPublisher;
        }

        public static Part create(HttpHeaders headers, HttpRequest.BodyPublisher bodyPublisher) {
            return new Part(headers, bodyPublisher);
        }

        private static void validateHeaderNames(Set<String> names, HttpRequest.BodyPublisher publisher) {
            Validate.requireArgument(!names.contains("Content-Type") || !(publisher instanceof MimeBodyPublisher), "unexpected Content-Type header");
            for (String name : names) {
                Validate.requireArgument(TOKEN_MATCHER.allMatch(name) && !name.isEmpty(), "illegal header name: %s", name);
            }
        }
    }

    private static enum BoundaryAppender {
        FIRST("--", "\r\n"),
        MIDDLE("\r\n--", "\r\n"),
        LAST("\r\n--", "--\r\n");

        private final String prefix;
        private final String suffix;

        private BoundaryAppender(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        void append(StringBuilder target, String boundary) {
            target.append(this.prefix).append(boundary).append(this.suffix);
        }

        static BoundaryAppender get(int partIndex, int partsSize) {
            return partIndex <= 0 ? FIRST : (partIndex >= partsSize ? LAST : MIDDLE);
        }
    }

    public static final class Builder {
        private static final int MAX_BOUNDARY_LENGTH = 70;
        private static final String MULTIPART_TYPE = "multipart";
        private static final String FORM_DATA_SUBTYPE = "form-data";
        private final List<Part> parts = new ArrayList<Part>();
        private MediaType mediaType = MediaType.of("multipart", "form-data");

        Builder() {
        }

        public Builder boundary(String boundary) {
            Objects.requireNonNull(boundary);
            this.mediaType = this.mediaType.withParameter(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE, Builder.validateBoundary(boundary));
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            Objects.requireNonNull(mediaType);
            this.mediaType = Builder.checkMediaType(mediaType);
            return this;
        }

        public Builder part(Part part) {
            Objects.requireNonNull(part);
            this.parts.add(part);
            return this;
        }

        public Builder formPart(String name, HttpRequest.BodyPublisher bodyPublisher) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(bodyPublisher, "body");
            return this.part(Part.create(Builder.getFormHeaders(name, null), bodyPublisher));
        }

        public Builder formPart(String name, String filename, HttpRequest.BodyPublisher body) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(filename, "filename");
            Objects.requireNonNull(body, "body");
            return this.part(Part.create(Builder.getFormHeaders(name, filename), body));
        }

        public Builder textPart(String name, Object value2) {
            return this.textPart(name, value2, StandardCharsets.UTF_8);
        }

        public Builder textPart(String name, Object value2, Charset charset) {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(value2, "value");
            Objects.requireNonNull(charset, "charset");
            return this.formPart(name, HttpRequest.BodyPublishers.ofString(value2.toString(), charset));
        }

        public Builder filePart(String name, Path file) throws FileNotFoundException {
            return this.filePart(name, file, Builder.probeMediaType(file));
        }

        public Builder filePart(String name, Path file, MediaType mediaType) throws FileNotFoundException {
            Objects.requireNonNull(name, "name");
            Objects.requireNonNull(file, "file");
            Objects.requireNonNull(mediaType, "mediaType");
            @Nullable Path filenameComponent = file.getFileName();
            String filename = filenameComponent != null ? filenameComponent.toString() : "";
            MimeBodyPublisher publisher = MoreBodyPublishers.ofMediaType(HttpRequest.BodyPublishers.ofFile(file), mediaType);
            return this.formPart(name, filename, publisher);
        }

        public MultipartBodyPublisher build() {
            List<Part> addedParts = List.copyOf(this.parts);
            Validate.requireState(!addedParts.isEmpty(), "at least one part should be added");
            MediaType localMediaType = this.mediaType;
            if (!localMediaType.parameters().containsKey(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE)) {
                localMediaType = localMediaType.withParameter(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE, UUID.randomUUID().toString());
            }
            return new MultipartBodyPublisher(addedParts, localMediaType);
        }

        private static String validateBoundary(String boundary) {
            Validate.requireArgument(boundary.length() <= 70 && !boundary.isEmpty(), "illegal boundary length: %s", boundary.length());
            Validate.requireArgument(HttpCharMatchers.BOUNDARY_MATCHER.allMatch(boundary) && !boundary.endsWith(" "), "illegal boundary: '%s'", boundary);
            return boundary;
        }

        private static MediaType checkMediaType(MediaType mediaType) {
            Validate.requireArgument(MULTIPART_TYPE.equals(mediaType.type()), "not a multipart type: %s", mediaType.type());
            String boundary = mediaType.parameters().get(MultipartBodyPublisher.BOUNDARY_ATTRIBUTE);
            if (boundary != null) {
                Builder.validateBoundary(boundary);
            }
            return mediaType;
        }

        private static HttpHeaders getFormHeaders(String name, @Nullable String filename) {
            StringBuilder disposition = new StringBuilder();
            Builder.appendEscaped(disposition.append("form-data; name="), name);
            if (filename != null) {
                Builder.appendEscaped(disposition.append("; filename="), filename);
            }
            return HttpHeaders.of(Map.of("Content-Disposition", List.of(disposition.toString())), (n, v) -> true);
        }

        private static void appendEscaped(StringBuilder target, String field) {
            target.append("\"");
            int len = field.length();
            for (int i = 0; i < len; ++i) {
                char c = field.charAt(i);
                if (c == '\\' || c == '\"') {
                    target.append('\\');
                }
                target.append(c);
            }
            target.append("\"");
        }

        private static MediaType probeMediaType(Path file) {
            try {
                String contentType = Files.probeContentType(file);
                if (contentType != null) {
                    return MediaType.parse(contentType);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return MediaType.APPLICATION_OCTET_STREAM;
        }
    }

    private static final class PartSubscriber
    implements Flow.Subscriber<ByteBuffer> {
        static final ByteBuffer END_OF_PART = ByteBuffer.allocate(0);
        private final MultipartSubscription downstream;
        private final ConcurrentLinkedQueue<ByteBuffer> buffers;
        private final Upstream upstream;
        private final Prefetcher prefetcher;

        PartSubscriber(MultipartSubscription downstream) {
            this.downstream = downstream;
            this.buffers = new ConcurrentLinkedQueue();
            this.upstream = new Upstream();
            this.prefetcher = new Prefetcher();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription);
            if (this.upstream.setOrCancel(subscription)) {
                this.prefetcher.initialize(this.upstream);
            }
        }

        @Override
        public void onNext(ByteBuffer item) {
            Objects.requireNonNull(item);
            this.buffers.offer(item);
            this.downstream.signal(false);
        }

        @Override
        public void onError(Throwable throwable) {
            Objects.requireNonNull(throwable);
            this.abortUpstream(false);
            this.downstream.signalError(throwable);
        }

        @Override
        public void onComplete() {
            this.abortUpstream(false);
            this.buffers.offer(END_OF_PART);
            this.downstream.signal(true);
        }

        void abortUpstream(boolean cancel) {
            if (cancel) {
                this.upstream.cancel();
            } else {
                this.upstream.clear();
            }
        }

        @Nullable ByteBuffer pollNext() {
            ByteBuffer next = this.buffers.peek();
            if (next != null && next != END_OF_PART) {
                this.buffers.poll();
                this.prefetcher.update(this.upstream);
            }
            return next;
        }
    }

    static interface PartSequenceListener {
        public void onNextPart(Part var1);

        public void onSequenceCompletion();

        default public PartSequenceListener guarded() {
            return new PartSequenceListener(){

                @Override
                public void onNextPart(Part part) {
                    try {
                        this.onNextPart(part);
                    }
                    catch (Throwable error) {
                        logger.log(System.Logger.Level.WARNING, "exception thrown by PartSequenceListener::onNextPart", error);
                    }
                }

                @Override
                public void onSequenceCompletion() {
                    try {
                        this.onSequenceCompletion();
                    }
                    catch (Throwable error) {
                        logger.log(System.Logger.Level.WARNING, "exception thrown by PartSequenceListener::onSequenceCompletion", error);
                    }
                }
            };
        }

        public static void register(Flow.Subscription subscription, PartSequenceListener listener) {
            Validate.requireArgument(subscription instanceof MultipartSubscription, "not a multipart subscription");
            ((MultipartSubscription)subscription).registerListener(listener);
        }
    }
}

