/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.CacheControl;
import com.github.mizosoft.methanol.MutableRequest;
import com.github.mizosoft.methanol.TrackedResponse;
import com.github.mizosoft.methanol.internal.cache.CacheReadingPublisher;
import com.github.mizosoft.methanol.internal.cache.CacheResponseMetadata;
import com.github.mizosoft.methanol.internal.cache.DateUtils;
import com.github.mizosoft.methanol.internal.cache.FreshnessPolicy;
import com.github.mizosoft.methanol.internal.cache.PublisherResponse;
import com.github.mizosoft.methanol.internal.cache.Store;
import com.github.mizosoft.methanol.internal.extensions.ResponseBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CacheResponse
extends PublisherResponse
implements Closeable {
    private final Store.Viewer viewer;
    private final CacheStrategy strategy;

    public CacheResponse(CacheResponseMetadata metadata, Store.Viewer viewer, Executor executor, CacheReadingPublisher.Listener readListener, HttpRequest request, Instant now) {
        super(metadata.toResponseBuilder().buildTracked(), new CacheReadingPublisher(viewer, executor, readListener));
        this.viewer = viewer;
        this.strategy = new CacheStrategy(request, this.response, now);
    }

    private CacheResponse(TrackedResponse<?> response, Flow.Publisher<List<ByteBuffer>> body, Store.Viewer viewer, CacheStrategy strategy) {
        super(response, body);
        this.viewer = viewer;
        this.strategy = strategy;
    }

    @Override
    public CacheResponse with(Consumer<ResponseBuilder<?>> mutator) {
        ResponseBuilder builder = ResponseBuilder.newBuilder(this.response);
        mutator.accept(builder);
        return new CacheResponse(builder.buildTracked(), this.publisher, this.viewer, this.strategy);
    }

    @Override
    public void close() {
        this.viewer.close();
    }

    public  @Nullable Store.Editor edit() throws IOException {
        return this.viewer.edit();
    }

    public boolean isServable() {
        return this.strategy.canServeCacheResponse(CacheStrategy.StalenessLimit.MAX_AGE);
    }

    public boolean isServableWhileRevalidating() {
        return this.strategy.canServeCacheResponse(CacheStrategy.StalenessLimit.STALE_WHILE_REVALIDATE);
    }

    public boolean isServableOnError() {
        return this.strategy.canServeCacheResponse(CacheStrategy.StalenessLimit.STALE_IF_ERROR);
    }

    public HttpRequest toValidationRequest(HttpRequest request) {
        return this.strategy.toValidationRequest(request);
    }

    public CacheResponse withCacheHeaders() {
        return this.with(this.strategy::addCacheHeaders);
    }

    static final class CacheStrategy {
        private static final Duration ONE_DAY = Duration.ofDays(1L);
        private final CacheControl requestCacheControl;
        private final CacheControl responseCacheControl;
        private final Duration age;
        private final Duration freshness;
        private final Duration staleness;
        private final boolean usesHeuristics;
        private final LocalDateTime effectiveLastModified;
        private final Optional<String> etag;

        CacheStrategy(HttpRequest request, TrackedResponse<?> response, Instant now) {
            this.requestCacheControl = CacheControl.parse(request.headers());
            this.responseCacheControl = CacheControl.parse(response.headers());
            Optional<Duration> maxAge = this.requestCacheControl.maxAge().or(this.responseCacheControl::maxAge);
            FreshnessPolicy freshnessPolicy = new FreshnessPolicy(maxAge, response);
            Duration freshnessLifetime = freshnessPolicy.computeFreshnessLifetime();
            this.age = freshnessPolicy.computeAge(now);
            this.freshness = freshnessLifetime.minus(this.age);
            this.staleness = this.freshness.negated();
            this.usesHeuristics = freshnessPolicy.usesHeuristics();
            this.effectiveLastModified = freshnessPolicy.effectiveLastModified();
            this.etag = response.headers().firstValue("ETag");
        }

        boolean canServeCacheResponse(StalenessLimit stalenessLimit) {
            if (this.requestCacheControl.noCache() || this.responseCacheControl.noCache()) {
                return false;
            }
            if (!this.freshness.isNegative()) {
                return this.requestCacheControl.minFresh().isEmpty() || this.freshness.compareTo(this.requestCacheControl.minFresh().get()) >= 0;
            }
            if (this.responseCacheControl.mustRevalidate()) {
                return false;
            }
            return stalenessLimit.get(this).filter(limit -> this.staleness.compareTo((Duration)limit) <= 0).isPresent();
        }

        void addCacheHeaders(ResponseBuilder<?> builder) {
            builder.setHeader("Age", Long.toString(this.age.toSeconds()));
            if (this.freshness.isNegative()) {
                builder.header("Warning", "110 - \"Response is Stale\"");
            }
            if (this.usesHeuristics && this.age.compareTo(ONE_DAY) > 0) {
                builder.header("Warning", "113 - \"Heuristic Expiration\"");
            }
        }

        HttpRequest toValidationRequest(HttpRequest request) {
            return MutableRequest.copyOf(request).setHeader("If-Modified-Since", DateUtils.formatHttpDate(this.effectiveLastModified)).apply(self -> this.etag.ifPresent(etag -> self.setHeader("If-None-Match", (String)etag)));
        }

        static enum StalenessLimit {
            MAX_AGE{

                @Override
                Optional<Duration> get(CacheStrategy strategy) {
                    CacheControl cacheControl = strategy.requestCacheControl;
                    return cacheControl.anyMaxStale() ? Optional.of(strategy.staleness) : cacheControl.maxStale();
                }
            }
            ,
            STALE_WHILE_REVALIDATE{

                @Override
                Optional<Duration> get(CacheStrategy strategy) {
                    return strategy.responseCacheControl.staleWhileRevalidate();
                }
            }
            ,
            STALE_IF_ERROR{

                @Override
                Optional<Duration> get(CacheStrategy strategy) {
                    return strategy.requestCacheControl.staleIfError().or(strategy.responseCacheControl::staleIfError);
                }
            };


            abstract Optional<Duration> get(CacheStrategy var1);
        }
    }
}

