/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import com.github.mizosoft.methanol.internal.Utils;
import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.cache.DateUtils;
import com.github.mizosoft.methanol.internal.cache.ExecutorServiceAdapter;
import com.github.mizosoft.methanol.internal.cache.Store;
import com.github.mizosoft.methanol.internal.cache.StoreCorruptionException;
import com.github.mizosoft.methanol.internal.cache.StoreIO;
import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import com.github.mizosoft.methanol.internal.concurrent.SerialExecutor;
import com.github.mizosoft.methanol.internal.function.ThrowingRunnable;
import com.github.mizosoft.methanol.internal.function.Unchecked;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DiskStore
implements Store {
    private static final System.Logger logger = System.getLogger(DiskStore.class.getName());
    private static final ThreadLocal<Boolean> isIndexExecutor = ThreadLocal.withInitial(() -> false);
    static final long INDEX_MAGIC = 7882834714441969516L;
    static final long ENTRY_MAGIC = 8891064658374387837L;
    static final int STORE_VERSION = 1;
    static final int INDEX_HEADER_SIZE = 24;
    static final int ENTRY_DESCRIPTOR_SIZE = 26;
    static final int ENTRY_TRAILER_SIZE = 32;
    static final String LOCK_FILENAME = ".lock";
    static final String INDEX_FILENAME = "index";
    static final String TEMP_INDEX_FILENAME = "index.tmp";
    static final String ENTRY_FILE_SUFFIX = ".ch3oh";
    static final String TEMP_ENTRY_FILE_SUFFIX = ".ch3oh.tmp";
    static final String RIP_FILE_PREFIX = "RIP_";
    private static final int MAX_ENTRY_COUNT = 1000000;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final long DEFAULT_INDEX_UPDATE_DELAY_MILLIS = 4000L;
    private static final Duration DEFAULT_INDEX_UPDATE_DELAY;
    private final Path directory;
    private final long maxSize;
    private final Executor executor;
    private final int appVersion;
    private final Hasher hasher;
    private final Clock clock;
    private final SerialExecutor indexExecutor;
    private final IndexOperator indexOperator;
    private final IndexWriteScheduler indexWriteScheduler;
    private final EvictionScheduler evictionScheduler;
    private final ConcurrentHashMap<Hash, Entry> entries = new ConcurrentHashMap();
    private final AtomicLong size = new AtomicLong();
    private final StampedLock closeLock = new StampedLock();
    private @MonotonicNonNull DirectoryLock directoryLock;
    private volatile boolean initialized;
    private boolean closed;

    private DiskStore(Builder builder) {
        this.directory = Objects.requireNonNull(builder.directory);
        this.maxSize = builder.maxSize;
        this.executor = Objects.requireNonNull(builder.executor);
        this.appVersion = builder.appVersion;
        this.hasher = Objects.requireNonNullElse(builder.hasher, Hasher.TRUNCATED_SHA_256);
        this.clock = Objects.requireNonNullElse(builder.clock, Utils.systemMillisUtc());
        boolean debugIndexOperations = builder.debugIndexOperations;
        Executor indexExecutorDelegate = debugIndexOperations ? runnable -> this.executor.execute(() -> {
            isIndexExecutor.set(true);
            try {
                runnable.run();
            }
            finally {
                isIndexExecutor.set(false);
            }
        }) : this.executor;
        this.indexExecutor = new SerialExecutor(indexExecutorDelegate);
        this.indexOperator = debugIndexOperations ? new DebugIndexOperator(this.directory, this.appVersion) : new IndexOperator(this.directory, this.appVersion);
        this.indexWriteScheduler = new IndexWriteScheduler(this.indexOperator, this.indexExecutor, this::entrySetSnapshot, Objects.requireNonNullElse(builder.indexUpdateDelay, DEFAULT_INDEX_UPDATE_DELAY), Objects.requireNonNullElse(builder.delayer, Delayer.systemDelayer()), this.clock);
        this.evictionScheduler = new EvictionScheduler(this, this.executor);
    }

    public Path directory() {
        return this.directory;
    }

    @Override
    public void initialize() throws IOException {
        Utils.blockOnIO(this.initializeAsync());
    }

    @Override
    public CompletableFuture<Void> initializeAsync() {
        return this.initialized ? CompletableFuture.completedFuture(null) : Unchecked.runAsync(this::doInitialize, this.indexExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize() throws IOException {
        if (this.initialized) {
            return;
        }
        long stamp = this.closeLock.readLock();
        try {
            this.requireNotClosed();
            Files.createDirectories(this.directory, new FileAttribute[0]);
            this.directoryLock = DirectoryLock.acquire(this.directory);
            long totalSize = 0L;
            for (EntryDescriptor descriptor : this.indexOperator.recoverEntrySet()) {
                this.entries.put(descriptor.hash, new Entry(descriptor));
                totalSize += descriptor.size;
            }
            this.size.set(totalSize);
            this.initialized = true;
            if (totalSize > this.maxSize) {
                this.evictionScheduler.schedule();
            }
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.of(this.executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Store.Viewer view(String key) throws IOException {
        Objects.requireNonNull(key);
        this.initialize();
        long stamp = this.closeLock.readLock();
        try {
            this.requireNotClosed();
            Entry entry = this.entries.get(this.hasher.hash(key));
            if (entry == null) {
                Store.Viewer viewer = null;
                return viewer;
            }
            Store.Viewer viewer = entry.openViewer(key);
            if (viewer != null) {
                this.indexWriteScheduler.trySchedule();
            }
            Store.Viewer viewer2 = viewer;
            return viewer2;
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Store.Editor edit(String key) throws IOException {
        Objects.requireNonNull(key);
        this.initialize();
        long stamp = this.closeLock.readLock();
        try {
            this.requireNotClosed();
            Entry entry = this.entries.computeIfAbsent(this.hasher.hash(key), x$0 -> new Entry((Hash)x$0));
            Store.Editor editor = entry.newEditor(key, -1);
            if (editor != null && entry.isReadable()) {
                this.indexWriteScheduler.trySchedule();
            }
            Store.Editor editor2 = editor;
            return editor2;
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    @Override
    public Iterator<Store.Viewer> iterator() throws IOException {
        this.initialize();
        return new ConcurrentViewerIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(String key) throws IOException {
        Objects.requireNonNull(key);
        this.initialize();
        long stamp = this.closeLock.readLock();
        try {
            String cachedKey;
            this.requireNotClosed();
            Entry entry = this.entries.get(this.hasher.hash(key));
            if (entry != null && ((cachedKey = entry.cachedKey) == null || key.equals(cachedKey))) {
                boolean bl = this.removeEntry(entry, true);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws IOException {
        this.initialize();
        long stamp = this.closeLock.readLock();
        try {
            this.requireNotClosed();
            for (Entry entry : this.entries.values()) {
                this.removeEntry(entry, false);
            }
            this.indexWriteScheduler.trySchedule();
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    @Override
    public long size() throws IOException {
        this.initialize();
        return this.size.get();
    }

    @Override
    public void dispose() throws IOException {
        this.doClose(true);
        this.size.set(0L);
    }

    @Override
    public void close() throws IOException {
        this.doClose(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose(boolean disposing) throws IOException {
        long stamp = this.closeLock.writeLock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        finally {
            this.closeLock.unlockWrite(stamp);
        }
        for (Entry entry : this.entries.values()) {
            entry.freeze();
        }
        if (disposing) {
            this.indexWriteScheduler.shutdown();
            DiskStore.deleteStoreContent(this.directory);
        } else {
            this.evictExcessiveEntries();
            Utils.blockOnIO(this.indexWriteScheduler.scheduleNow());
            this.indexWriteScheduler.shutdown();
        }
        this.indexExecutor.shutdown();
        this.evictionScheduler.shutdown();
        this.entries.clear();
        DirectoryLock lock = this.directoryLock;
        if (lock != null) {
            lock.release();
        }
    }

    @Override
    public void flush() throws IOException {
        long stamp = this.closeLock.readLock();
        try {
            if (!this.initialized || this.closed) {
                return;
            }
            Utils.blockOnIO(this.indexWriteScheduler.scheduleNow());
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    private Set<EntryDescriptor> entrySetSnapshot() {
        HashSet<EntryDescriptor> snapshot = new HashSet<EntryDescriptor>();
        for (Entry entry : this.entries.values()) {
            EntryDescriptor descriptor = entry.descriptor();
            if (descriptor == null) continue;
            snapshot.add(descriptor);
        }
        return Collections.unmodifiableSet(snapshot);
    }

    private long evict(Entry entry, int targetEntryVersion) throws IOException {
        assert (this.holdsCloseLock());
        long evictedSize = entry.evict(targetEntryVersion);
        if (evictedSize >= 0L && this.entries.remove(entry.hash, entry)) {
            return evictedSize;
        }
        return -1L;
    }

    private boolean removeEntry(Entry entry, boolean scheduleIndexWrite) throws IOException {
        return this.removeEntry(entry, scheduleIndexWrite, -1);
    }

    private boolean removeEntry(Entry entry, boolean scheduleIndexWrite, int targetEntryVersion) throws IOException {
        assert (this.holdsCloseLock());
        long evictedSize = this.evict(entry, targetEntryVersion);
        if (evictedSize >= 0L) {
            this.size.addAndGet(-evictedSize);
            if (scheduleIndexWrite) {
                this.indexWriteScheduler.trySchedule();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryRunScheduledEviction() throws IOException {
        assert (this.initialized);
        long stamp = this.closeLock.readLock();
        try {
            if (this.closed) {
                boolean bl = false;
                return bl;
            }
            if (this.evictExcessiveEntries()) {
                this.indexWriteScheduler.trySchedule();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeLock.unlockRead(stamp);
        }
    }

    private boolean evictExcessiveEntries() throws IOException {
        boolean evictedAtLeastOneEntry = false;
        Iterator<Entry> lruIterator = null;
        long currentSize = this.size.get();
        while (currentSize > this.maxSize) {
            if (lruIterator == null) {
                lruIterator = this.entriesSnapshotInLruOrder().iterator();
            }
            if (!lruIterator.hasNext()) break;
            long evictedSize = this.evict(lruIterator.next(), -1);
            if (evictedSize >= 0L) {
                currentSize = this.size.addAndGet(-evictedSize);
                evictedAtLeastOneEntry = true;
                continue;
            }
            currentSize = this.size.get();
        }
        return evictedAtLeastOneEntry;
    }

    private Collection<Entry> entriesSnapshotInLruOrder() {
        TreeMap<EntryDescriptor, Entry> lruEntries = new TreeMap<EntryDescriptor, Entry>(EntryDescriptor.LRU_ORDER);
        for (Entry entry : this.entries.values()) {
            EntryDescriptor descriptor = entry.descriptor();
            if (descriptor == null) continue;
            lruEntries.put(descriptor, entry);
        }
        return Collections.unmodifiableCollection(lruEntries.values());
    }

    private void requireNotClosed() {
        assert (this.holdsCloseLock());
        Validate.requireState(!this.closed, "closed");
    }

    private boolean holdsCloseLock() {
        return this.closeLock.isReadLocked() || this.closeLock.isWriteLocked();
    }

    private static void checkValue(long expected, long found, String msg) throws StoreCorruptionException {
        if (expected != found) {
            throw new StoreCorruptionException(String.format("%s; expected: %#x, found: %#x", msg, expected, found));
        }
    }

    private static void checkValue(boolean valueIsValid, String msg, long value2) throws StoreCorruptionException {
        if (!valueIsValid) {
            throw new StoreCorruptionException(String.format("%s: %d", msg, value2));
        }
    }

    private static int getNonNegativeInt(ByteBuffer buffer) throws StoreCorruptionException {
        int value2 = buffer.getInt();
        DiskStore.checkValue(value2 >= 0, "expected a value >= 0", value2);
        return value2;
    }

    private static long getNonNegativeLong(ByteBuffer buffer) throws StoreCorruptionException {
        long value2 = buffer.getLong();
        DiskStore.checkValue(value2 >= 0L, "expected a value >= 0", value2);
        return value2;
    }

    private static long getPositiveLong(ByteBuffer buffer) throws StoreCorruptionException {
        long value2 = buffer.getLong();
        DiskStore.checkValue(value2 > 0L, "expected a positive value", value2);
        return value2;
    }

    private static @Nullable Hash entryFileToHash(String filename) {
        assert (filename.endsWith(ENTRY_FILE_SUFFIX) || filename.endsWith(TEMP_ENTRY_FILE_SUFFIX));
        int suffixLength = filename.endsWith(ENTRY_FILE_SUFFIX) ? ENTRY_FILE_SUFFIX.length() : TEMP_ENTRY_FILE_SUFFIX.length();
        return Hash.tryParse(filename.substring(0, filename.length() - suffixLength));
    }

    private static void replace(Path source, Path target) throws IOException {
        Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void deleteStoreContent(Path directory) throws IOException {
        Path lockFile = directory.resolve(LOCK_FILENAME);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory, file -> !file.equals(lockFile));){
            for (Path file2 : stream) {
                DiskStore.safeDelete(file2);
            }
        }
        catch (DirectoryIteratorException e) {
            throw e.getCause();
        }
    }

    private static void isolatedDelete(Path file) throws IOException {
        Path parent = file.getParent();
        boolean isolated = false;
        while (!isolated) {
            Path ripFile = parent.resolve(RIP_FILE_PREFIX + Long.toHexString(ThreadLocalRandom.current().nextLong()));
            try {
                Files.move(file, ripFile, StandardCopyOption.ATOMIC_MOVE);
                isolated = true;
            }
            catch (AccessDeniedException | FileAlreadyExistsException fileSystemException) {
            }
            catch (NoSuchFileException e) {
                return;
            }
            Files.deleteIfExists(ripFile);
        }
    }

    private static void safeDelete(Path file) throws IOException {
        String pathString = file.getFileName().toString();
        if (pathString.endsWith(ENTRY_FILE_SUFFIX)) {
            DiskStore.isolatedDelete(file);
        } else if (pathString.startsWith(RIP_FILE_PREFIX)) {
            try {
                Files.deleteIfExists(file);
            }
            catch (AccessDeniedException accessDeniedException) {}
        } else {
            Files.deleteIfExists(file);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static {
        long millis = Long.getLong("com.github.mizosoft.methanol.internal.cache.DiskStore.indexUpdateDelayMillis", 4000L);
        if (millis < 0L) {
            millis = 4000L;
        }
        DEFAULT_INDEX_UPDATE_DELAY = Duration.ofMillis(millis);
    }

    public static final class Hash {
        static final int BYTES = 10;
        private static final int HEX_STRING_LENGTH = 20;
        private final long upper64Bits;
        private final short lower16Bits;
        private @MonotonicNonNull String lazyHex;

        public Hash(ByteBuffer buffer) {
            this.upper64Bits = buffer.getLong();
            this.lower16Bits = buffer.getShort();
        }

        void writeTo(ByteBuffer buffer) {
            assert (buffer.remaining() >= 10);
            buffer.putLong(this.upper64Bits);
            buffer.putShort(this.lower16Bits);
        }

        String toHexString() {
            String hex = this.lazyHex;
            if (hex == null) {
                StringBuilder sb = new StringBuilder(20);
                ByteBuffer buffer = ByteBuffer.allocate(10);
                this.writeTo(buffer);
                buffer.flip();
                while (buffer.hasRemaining()) {
                    byte b = buffer.get();
                    char upperHex = Character.forDigit(b >> 4 & 0xF, 16);
                    char lowerHex = Character.forDigit(b & 0xF, 16);
                    sb.append(upperHex).append(lowerHex);
                }
                this.lazyHex = hex = sb.toString();
            }
            return hex;
        }

        public int hashCode() {
            return Long.hashCode(this.upper64Bits) ^ Short.hashCode(this.lower16Bits);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Hash)) {
                return false;
            }
            Hash other = (Hash)obj;
            return this.upper64Bits == other.upper64Bits && this.lower16Bits == other.lower16Bits;
        }

        public String toString() {
            return this.toHexString();
        }

        static @Nullable Hash tryParse(String hex) {
            if (hex.length() != 20) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.allocate(10);
            for (int i = 0; i < 10; ++i) {
                int upperNibble = Character.digit(hex.charAt(2 * i), 16);
                int lowerNibble = Character.digit(hex.charAt(2 * i + 1), 16);
                if (upperNibble == -1 || lowerNibble == -1) {
                    return null;
                }
                buffer.put((byte)(upperNibble << 4 | lowerNibble));
            }
            return new Hash(buffer.flip());
        }
    }

    public static final class Builder {
        private static final int UNSET = -1;
        private @MonotonicNonNull Path directory;
        private long maxSize = -1L;
        private @MonotonicNonNull Executor executor;
        private int appVersion = -1;
        public @MonotonicNonNull Hasher hasher;
        private @MonotonicNonNull Clock clock;
        private @MonotonicNonNull Delayer delayer;
        private @MonotonicNonNull Duration indexUpdateDelay;
        private boolean debugIndexOperations;

        Builder() {
        }

        public Builder directory(Path directory) {
            this.directory = Objects.requireNonNull(directory);
            return this;
        }

        public Builder maxSize(long maxSize) {
            Validate.requireArgument(maxSize > 0L, "non-positive max size");
            this.maxSize = maxSize;
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor);
            return this;
        }

        public Builder appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder hasher(Hasher hasher) {
            this.hasher = Objects.requireNonNull(hasher);
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        public Builder delayer(Delayer delayer) {
            this.delayer = Objects.requireNonNull(delayer);
            return this;
        }

        public Builder indexUpdateDelay(Duration duration) {
            Objects.requireNonNull(duration);
            Utils.requireNonNegativeDuration(duration);
            this.indexUpdateDelay = duration;
            return this;
        }

        public Builder debugIndexOperations(boolean debugIndexOperations) {
            this.debugIndexOperations = debugIndexOperations;
            return this;
        }

        public DiskStore build() {
            Validate.requireState(this.directory != null && this.maxSize != -1L && this.executor != null && this.appVersion != -1, "missing required fields");
            return new DiskStore(this);
        }
    }

    @FunctionalInterface
    public static interface Hasher {
        public static final Hasher TRUNCATED_SHA_256 = Hasher::truncatedSha256Hash;

        public Hash hash(String var1);

        private static Hash truncatedSha256Hash(String key) {
            MessageDigest digest = Hasher.sha256Digest();
            digest.update(StandardCharsets.UTF_8.encode(key));
            return new Hash(ByteBuffer.wrap(digest.digest()).limit(10));
        }

        private static MessageDigest sha256Digest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException("SHA-256 not available!", e);
            }
        }
    }

    private static final class DebugIndexOperator
    extends IndexOperator {
        private static final System.Logger logger = System.getLogger(DebugIndexOperator.class.getName());
        private final AtomicReference<@Nullable String> runningOperation = new AtomicReference();

        DebugIndexOperator(Path directory, int appVersion) {
            super(directory, appVersion);
        }

        @Override
        Set<EntryDescriptor> readIndex() throws IOException {
            this.enter("readIndex");
            try {
                Set<EntryDescriptor> set = super.readIndex();
                return set;
            }
            finally {
                this.exit();
            }
        }

        @Override
        void writeIndex(Set<EntryDescriptor> entrySet) throws IOException {
            this.enter("writeIndex");
            try {
                super.writeIndex(entrySet);
            }
            finally {
                this.exit();
            }
        }

        private void enter(String operation) {
            String currentOperation;
            if (!isIndexExecutor.get().booleanValue()) {
                logger.log(System.Logger.Level.ERROR, () -> "IndexOperator::" + operation + " isn't called by the index executor");
            }
            if ((currentOperation = this.runningOperation.compareAndExchange(null, operation)) != null) {
                logger.log(System.Logger.Level.ERROR, () -> "IndexOperator::" + operation + " is called while IndexOperator::" + currentOperation + " is running");
            }
        }

        private void exit() {
            this.runningOperation.set(null);
        }
    }

    private static class IndexOperator {
        private final Path directory;
        private final Path indexFile;
        private final Path tempIndexFile;
        private final int appVersion;

        IndexOperator(Path directory, int appVersion) {
            this.directory = directory;
            this.appVersion = appVersion;
            this.indexFile = directory.resolve(DiskStore.INDEX_FILENAME);
            this.tempIndexFile = directory.resolve(DiskStore.TEMP_INDEX_FILENAME);
        }

        Set<EntryDescriptor> recoverEntrySet() throws IOException {
            Set<EntryDescriptor> indexEntrySet = this.readOrCreateIndexIfAbsent();
            Map<Hash, EntryFiles> entriesFoundOnDisk = this.scanDirectoryForEntries();
            HashSet<EntryDescriptor> processedEntrySet = new HashSet<EntryDescriptor>(indexEntrySet.size());
            HashSet<Path> toDelete = new HashSet<Path>();
            for (EntryDescriptor entryDescriptor : indexEntrySet) {
                EntryFiles entryFiles = entriesFoundOnDisk.get(entryDescriptor.hash);
                if (entryFiles == null) continue;
                if (entryFiles.dirtyFile != null) {
                    toDelete.add(entryFiles.dirtyFile);
                }
                if (entryFiles.cleanFile == null) continue;
                processedEntrySet.add(entryDescriptor);
            }
            if (processedEntrySet.size() != entriesFoundOnDisk.size()) {
                HashMap<Hash, EntryFiles> untrackedEntries = new HashMap<Hash, EntryFiles>(entriesFoundOnDisk);
                processedEntrySet.forEach(descriptor -> untrackedEntries.remove(descriptor.hash));
                for (EntryFiles entryFiles : untrackedEntries.values()) {
                    if (entryFiles.cleanFile != null) {
                        toDelete.add(entryFiles.cleanFile);
                    }
                    if (entryFiles.dirtyFile == null) continue;
                    toDelete.add(entryFiles.dirtyFile);
                }
            }
            for (Path path : toDelete) {
                DiskStore.safeDelete(path);
            }
            return Collections.unmodifiableSet(processedEntrySet);
        }

        private Set<EntryDescriptor> readOrCreateIndexIfAbsent() throws IOException {
            Files.deleteIfExists(this.tempIndexFile);
            try {
                return this.readIndex();
            }
            catch (NoSuchFileException e) {
                this.writeIndex(Set.of());
                return Set.of();
            }
            catch (StoreCorruptionException | EOFException e) {
                logger.log(System.Logger.Level.WARNING, "dropping store contents due to unreadable index", (Throwable)e);
                DiskStore.deleteStoreContent(this.directory);
                this.writeIndex(Set.of());
                return Set.of();
            }
        }

        Set<EntryDescriptor> readIndex() throws IOException {
            try (FileChannel channel = FileChannel.open(this.indexFile, StandardOpenOption.READ);){
                ByteBuffer header = StoreIO.readNBytes(channel, 24);
                DiskStore.checkValue(7882834714441969516L, header.getLong(), "not in index format");
                DiskStore.checkValue(1L, header.getInt(), "unknown store version");
                DiskStore.checkValue(this.appVersion, header.getInt(), "unknown app version");
                long entryCount = header.getLong();
                DiskStore.checkValue(entryCount >= 0L && entryCount <= 1000000L, "invalid entry count", entryCount);
                if (entryCount == 0L) {
                    Set<EntryDescriptor> set = Set.of();
                    return set;
                }
                int intEntryCount = (int)entryCount;
                int entryTableSize = intEntryCount * 26;
                ByteBuffer entryTable = StoreIO.readNBytes(channel, entryTableSize);
                HashSet<EntryDescriptor> result = new HashSet<EntryDescriptor>(intEntryCount);
                for (int i = 0; i < intEntryCount; ++i) {
                    result.add(new EntryDescriptor(entryTable));
                }
                Set<EntryDescriptor> set = Collections.unmodifiableSet(result);
                return set;
            }
        }

        void writeIndex(Set<EntryDescriptor> entrySet) throws IOException {
            try (FileChannel channel = FileChannel.open(this.tempIndexFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                ByteBuffer header = ByteBuffer.allocate(24).putLong(7882834714441969516L).putInt(1).putInt(this.appVersion).putLong(entrySet.size());
                StoreIO.writeBytes(channel, header.flip());
                if (entrySet.size() > 0) {
                    ByteBuffer entryTable = ByteBuffer.allocate(entrySet.size() * 26);
                    entrySet.forEach(descriptor -> descriptor.writeTo(entryTable));
                    StoreIO.writeBytes(channel, entryTable.flip());
                }
                channel.force(false);
            }
            DiskStore.replace(this.tempIndexFile, this.indexFile);
        }

        private Map<Hash, EntryFiles> scanDirectoryForEntries() throws IOException {
            HashMap<Hash, EntryFiles> scanResult = new HashMap<Hash, EntryFiles>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.directory);){
                for (Path path : stream) {
                    Hash entryHash;
                    String filename = path.getFileName().toString();
                    if (filename.equals(DiskStore.INDEX_FILENAME) || filename.equals(DiskStore.TEMP_INDEX_FILENAME) || filename.equals(DiskStore.LOCK_FILENAME)) continue;
                    if ((filename.endsWith(DiskStore.ENTRY_FILE_SUFFIX) || filename.endsWith(DiskStore.TEMP_ENTRY_FILE_SUFFIX)) && (entryHash = DiskStore.entryFileToHash(filename)) != null) {
                        EntryFiles files = scanResult.computeIfAbsent(entryHash, __ -> new EntryFiles());
                        if (filename.endsWith(DiskStore.ENTRY_FILE_SUFFIX)) {
                            files.cleanFile = path;
                            continue;
                        }
                        files.dirtyFile = path;
                        continue;
                    }
                    if (filename.startsWith(DiskStore.RIP_FILE_PREFIX)) {
                        DiskStore.safeDelete(path);
                        continue;
                    }
                    logger.log(System.Logger.Level.WARNING, "unrecognized file or directory found during initialization: " + path + System.lineSeparator() + "it is generally not a good idea to let the store directory be used by other entities");
                }
            }
            return scanResult;
        }

        private static final class EntryFiles {
            @MonotonicNonNull Path cleanFile;
            @MonotonicNonNull Path dirtyFile;

            EntryFiles() {
            }
        }
    }

    private static final class IndexWriteScheduler {
        private static final WriteTaskView TOMBSTONE = new WriteTaskView(){

            @Override
            Instant fireTime() {
                return Instant.MIN;
            }

            @Override
            void cancel() {
            }
        };
        private final IndexOperator indexOperator;
        private final Executor indexExecutor;
        private final Supplier<Set<EntryDescriptor>> entrySetSnapshotSupplier;
        private final Duration updateDelay;
        private final Delayer delayer;
        private final Clock clock;
        private final AtomicReference<WriteTaskView> scheduledWriteTask = new AtomicReference();
        private final Phaser runningTaskAwaiter = new Phaser(1);

        IndexWriteScheduler(IndexOperator indexOperator, Executor indexExecutor, Supplier<Set<EntryDescriptor>> entrySetSnapshotSupplier, Duration updateDelay, Delayer delayer, Clock clock) {
            this.indexOperator = indexOperator;
            this.indexExecutor = indexExecutor;
            this.entrySetSnapshotSupplier = entrySetSnapshotSupplier;
            this.updateDelay = updateDelay;
            this.delayer = delayer;
            this.clock = clock;
        }

        void trySchedule() {
            block5: {
                Duration delay;
                WriteTask nextTask;
                WriteTaskView currentTask;
                Instant now = this.clock.instant();
                do {
                    Instant nextFireTime;
                    Instant instant = nextFireTime = (currentTask = this.scheduledWriteTask.get()) != null ? currentTask.fireTime() : null;
                    if (nextFireTime == null) {
                        delay = Duration.ZERO;
                    } else if (currentTask == TOMBSTONE || nextFireTime.isAfter(now)) {
                        delay = null;
                    } else {
                        Duration idleness = Duration.between(nextFireTime, now);
                        Duration remainingUpdateDelay = this.updateDelay.minus(idleness);
                        delay = DateUtils.max(remainingUpdateDelay, Duration.ZERO);
                    }
                    if (delay == null) break block5;
                } while (!this.scheduledWriteTask.compareAndSet(currentTask, nextTask = new WriteTask(now.plus(delay))));
                this.delayer.delay(nextTask.logOnFailure(), delay, this.indexExecutor);
            }
        }

        CompletableFuture<Void> scheduleNow() {
            WriteTask immediateTask;
            WriteTaskView currentTask;
            Instant now = this.clock.instant();
            do {
                if ((currentTask = this.scheduledWriteTask.get()) != TOMBSTONE) continue;
                return CompletableFuture.completedFuture(null);
            } while (!this.scheduledWriteTask.compareAndSet(currentTask, immediateTask = new WriteTask(now)));
            if (currentTask != null) {
                currentTask.cancel();
            }
            return Unchecked.runAsync(immediateTask, this.indexExecutor);
        }

        void shutdown() throws InterruptedIOException {
            this.scheduledWriteTask.set(TOMBSTONE);
            try {
                this.runningTaskAwaiter.awaitAdvanceInterruptibly(this.runningTaskAwaiter.arriveAndDeregister());
                assert (this.runningTaskAwaiter.isTerminated());
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }

        private static abstract class WriteTaskView {
            private WriteTaskView() {
            }

            abstract Instant fireTime();

            abstract void cancel();
        }

        private final class WriteTask
        extends WriteTaskView
        implements ThrowingRunnable {
            private final Instant fireTime;
            private volatile boolean cancelled;

            WriteTask(Instant fireTime) {
                this.fireTime = fireTime;
            }

            @Override
            Instant fireTime() {
                return this.fireTime;
            }

            @Override
            void cancel() {
                this.cancelled = true;
            }

            @Override
            public void run() throws IOException {
                if (!this.cancelled && IndexWriteScheduler.this.runningTaskAwaiter.register() >= 0) {
                    try {
                        IndexWriteScheduler.this.indexOperator.writeIndex(IndexWriteScheduler.this.entrySetSnapshotSupplier.get());
                    }
                    finally {
                        IndexWriteScheduler.this.runningTaskAwaiter.arriveAndDeregister();
                    }
                }
            }

            Runnable logOnFailure() {
                return () -> {
                    try {
                        this.run();
                    }
                    catch (IOException e) {
                        logger.log(System.Logger.Level.ERROR, "index write failure", (Throwable)e);
                    }
                };
            }
        }
    }

    private static final class EvictionScheduler {
        private static final int RUN = 1;
        private static final int KEEP_ALIVE = 2;
        private static final int SHUTDOWN = 4;
        private static final VarHandle SYNC;
        private final DiskStore store;
        private final Executor executor;
        private volatile int sync;

        EvictionScheduler(DiskStore store, Executor executor) {
            this.store = store;
            this.executor = executor;
        }

        void schedule() {
            int s2;
            while (((s2 = this.sync) & 4) == 0) {
                int bit = (s2 & 1) == 0 ? 1 : 2;
                if (!SYNC.compareAndSet(this, s2, s2 | bit)) continue;
                if (bit != 1) break;
                this.executor.execute(this::runEviction);
                break;
            }
        }

        private void runEviction() {
            int s2;
            while (((s2 = this.sync) & 4) == 0) {
                int bit;
                try {
                    if (!this.store.tryRunScheduledEviction()) {
                        this.shutdown();
                        break;
                    }
                }
                catch (IOException e) {
                    logger.log(System.Logger.Level.ERROR, "background eviction failure", (Throwable)e);
                }
                if (!SYNC.compareAndSet(this, s2, s2 & ~(bit = (s2 & 2) != 0 ? 2 : 1)) || bit != 1) continue;
                break;
            }
        }

        void shutdown() {
            SYNC.getAndBitwiseOr(this, 4);
        }

        static {
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                SYNC = lookup.findVarHandle(EvictionScheduler.class, "sync", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static final class DirectoryLock {
        private static final ConcurrentHashMap<Path, DirectoryLock> acquiredLocks = new ConcurrentHashMap();
        private final Path directory;
        private final Path lockFile;
        private volatile @MonotonicNonNull FileChannel channel;
        private volatile @MonotonicNonNull FileLock fileLock;

        DirectoryLock(Path directory) {
            this.directory = directory;
            this.lockFile = directory.resolve(DiskStore.LOCK_FILENAME);
        }

        void release() throws IOException {
            Utils.closeQuietly(this.channel);
            if (this.fileLock != null) {
                Files.deleteIfExists(this.lockFile);
            }
            acquiredLocks.remove(this.directory, this);
        }

        private boolean tryLock() throws IOException {
            FileChannel channel;
            this.channel = channel = FileChannel.open(this.lockFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
            try {
                FileLock fileLock;
                this.fileLock = fileLock = channel.tryLock();
                return fileLock != null;
            }
            catch (OverlappingFileLockException e) {
                return false;
            }
            catch (IOException e) {
                Utils.closeQuietly(channel);
                throw e;
            }
        }

        static DirectoryLock acquire(Path directory) throws IOException {
            boolean inserted;
            DirectoryLock lock = new DirectoryLock(directory);
            boolean bl = inserted = acquiredLocks.putIfAbsent(directory, lock) == null;
            if (!inserted || !lock.tryLock()) {
                lock.release();
                throw new IOException(String.format("cache directory <%s> is being used by another %s", directory, inserted ? "process" : "instance"));
            }
            return lock;
        }
    }

    private static final class EntryDescriptor {
        static final Comparator<EntryDescriptor> LRU_ORDER = Comparator.comparing(descriptor -> descriptor.lastUsed).thenComparingLong(descriptor -> descriptor.size);
        final Hash hash;
        final Instant lastUsed;
        final long size;

        EntryDescriptor(Hash hash, Instant lastUsed, long size) {
            this.hash = hash;
            this.lastUsed = lastUsed;
            this.size = size;
        }

        EntryDescriptor(ByteBuffer buffer) throws StoreCorruptionException {
            this.hash = new Hash(buffer);
            this.lastUsed = Instant.ofEpochMilli(buffer.getLong());
            this.size = DiskStore.getPositiveLong(buffer);
        }

        void writeTo(ByteBuffer buffer) {
            assert (buffer.remaining() >= 26);
            this.hash.writeTo(buffer);
            buffer.putLong(this.lastUsed.toEpochMilli());
            buffer.putLong(this.size);
        }

        public int hashCode() {
            return this.hash.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof EntryDescriptor && this.hash.equals(((EntryDescriptor)obj).hash);
        }
    }

    private final class Entry {
        static final int ANY_ENTRY_VERSION = -1;
        private final ReentrantLock lock = new ReentrantLock();
        final Hash hash;
        volatile @MonotonicNonNull String cachedKey;
        int viewerCount;
        private Instant lastUsed;
        private long entrySize;
        private @MonotonicNonNull Path entryFile;
        private @MonotonicNonNull Path tempEntryFile;
        private @Nullable DiskEditor currentEditor;
        private int version;
        private boolean evicted;
        private boolean frozen;

        Entry(Hash hash) {
            this.hash = hash;
            this.lastUsed = Instant.MAX;
        }

        Entry(EntryDescriptor descriptor) {
            this.hash = descriptor.hash;
            this.lastUsed = descriptor.lastUsed;
            this.entrySize = descriptor.size;
            this.version = 1;
        }

        boolean isReadable() {
            this.lock.lock();
            try {
                boolean bl = this.version > 0 && !this.evicted;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Nullable EntryDescriptor descriptor() {
            this.lock.lock();
            try {
                EntryDescriptor entryDescriptor = this.isReadable() ? new EntryDescriptor(this.hash, this.lastUsed, this.entrySize) : null;
                return entryDescriptor;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable Store.Viewer openViewer(@Nullable String key) throws IOException {
            this.lock.lock();
            try {
                EntryReadResult result = this.tryReadEntry(key);
                if (result == null) {
                    Store.Viewer viewer = null;
                    return viewer;
                }
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(this.entryFile(), Set.of(StandardOpenOption.READ), this.asyncChannelExecutor(), new FileAttribute[0]);
                DiskViewer viewer = new DiskViewer(this, this.version, result.key, result.metadata, channel, result.dataSize);
                ++this.viewerCount;
                this.lastUsed = DiskStore.this.clock.instant();
                DiskViewer diskViewer = viewer;
                return diskViewer;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable Store.Editor newEditor(String key, int targetVersion) {
            this.lock.lock();
            try {
                DiskEditor editor;
                if (this.currentEditor != null || targetVersion != -1 && targetVersion != this.version || this.evicted || this.frozen) {
                    Store.Editor editor2 = null;
                    return editor2;
                }
                this.currentEditor = editor = new DiskEditor(this, key);
                this.lastUsed = DiskStore.this.clock.instant();
                DiskEditor diskEditor = editor;
                return diskEditor;
            }
            finally {
                this.lock.unlock();
            }
        }

        void freeze() throws IOException {
            this.lock.lock();
            try {
                this.frozen = true;
                this.discardCurrentEdit();
            }
            finally {
                this.lock.unlock();
            }
        }

        private void discardCurrentEdit() throws IOException {
            assert (this.lock.isHeldByCurrentThread());
            DiskEditor editor = this.currentEditor;
            this.currentEditor = null;
            if (editor != null) {
                editor.discard();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void commitEdit(DiskEditor editor, String key, @Nullable ByteBuffer newMetadata, @Nullable AsynchronousFileChannel dataChannel, long dataSize) throws IOException {
            boolean firstTimeReadable;
            long oldEntrySize;
            long newEntrySize;
            this.lock.lock();
            try {
                long updatedDataSize;
                boolean ownedEditor = this.currentEditor == editor;
                this.currentEditor = null;
                if (!ownedEditor || dataSize < 0L || newMetadata == null && dataChannel == null || this.evicted) {
                    this.refuseEdit(dataChannel);
                    return;
                }
                EntryReadResult readResult = this.tryReadEntry(null);
                ByteBuffer oldMetadata = readResult != null ? readResult.metadata : EMPTY_BUFFER;
                ByteBuffer metadataToWrite = Objects.requireNonNullElse(newMetadata, oldMetadata);
                long updatedMetadataSize = metadataToWrite.remaining();
                newEntrySize = updatedMetadataSize + (updatedDataSize = dataChannel != null ? dataSize : (readResult != null ? readResult.dataSize : 0L));
                if (newEntrySize > DiskStore.this.maxSize) {
                    this.refuseEdit(dataChannel);
                    return;
                }
                if (dataChannel != null || readResult == null) {
                    this.writeEntry(key, metadataToWrite, dataChannel, dataSize);
                } else {
                    this.updateEntry(key, metadataToWrite, readResult.dataSize);
                }
                oldEntrySize = this.entrySize;
                this.entrySize = newEntrySize;
                this.cachedKey = key;
                firstTimeReadable = this.version == 0;
                ++this.version;
            }
            finally {
                this.lock.unlock();
            }
            long netEntrySize = newEntrySize - oldEntrySize;
            if (DiskStore.this.size.addAndGet(netEntrySize) > DiskStore.this.maxSize) {
                DiskStore.this.evictionScheduler.schedule();
            }
            if (firstTimeReadable) {
                DiskStore.this.indexWriteScheduler.trySchedule();
            }
        }

        private void refuseEdit(@Nullable AsynchronousFileChannel dataChannel) throws IOException {
            assert (this.lock.isHeldByCurrentThread());
            Utils.closeQuietly(dataChannel);
            Files.deleteIfExists(this.tempEntryFile());
            if (this.version == 0 && !this.evicted) {
                this.evicted = true;
                DiskStore.this.entries.remove(this.hash, this);
            }
        }

        private void writeEntry(String key, ByteBuffer metadata, @Nullable AsynchronousFileChannel dataChannel, long dataSize) throws IOException {
            ByteBuffer footer = this.buildEntryFooter(key, metadata, dataSize);
            if (dataChannel != null) {
                try (AsynchronousFileChannel asynchronousFileChannel = dataChannel;){
                    Utils.blockOnIO(StoreIO.writeBytesAsync(dataChannel, footer, dataSize));
                    dataChannel.force(false);
                }
            }
            try (FileChannel channel = FileChannel.open(this.tempEntryFile(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                StoreIO.writeBytes(channel, footer, dataSize);
                channel.force(false);
            }
            if (this.viewerCount > 0) {
                DiskStore.isolatedDelete(this.entryFile());
            }
            DiskStore.replace(this.tempEntryFile(), this.entryFile());
        }

        private void updateEntry(String key, ByteBuffer metadata, long dataSize) throws IOException {
            DiskStore.replace(this.entryFile(), this.tempEntryFile());
            ByteBuffer footer = this.buildEntryFooter(key, metadata, dataSize);
            try (FileChannel channel = FileChannel.open(this.tempEntryFile(), StandardOpenOption.WRITE);){
                channel.truncate(dataSize + (long)footer.remaining());
                StoreIO.writeBytes(channel, footer, dataSize);
                channel.force(false);
            }
            DiskStore.replace(this.tempEntryFile(), this.entryFile());
        }

        private ByteBuffer buildEntryFooter(String key, ByteBuffer metadata, long dataSize) {
            ByteBuffer encodedKey = StandardCharsets.UTF_8.encode(key);
            int keySize = encodedKey.remaining();
            int metadataSize = metadata.remaining();
            return ByteBuffer.allocate(keySize + metadataSize + 32).put(encodedKey).put(metadata).putLong(8891064658374387837L).putInt(1).putInt(DiskStore.this.appVersion).putInt(keySize).putInt(metadataSize).putLong(dataSize).flip();
        }

        private @Nullable EntryReadResult tryReadEntry(@Nullable String expectedKey) throws IOException {
            String key = this.cachedKey;
            if (this.isReadable() && (key == null || expectedKey == null || key.equals(expectedKey))) {
                EntryReadResult readResult = this.readEntry();
                if (expectedKey == null || readResult.key.equals(expectedKey)) {
                    this.cachedKey = readResult.key;
                    return readResult;
                }
            }
            return null;
        }

        private EntryReadResult readEntry() throws IOException {
            try (FileChannel channel = FileChannel.open(this.entryFile(), StandardOpenOption.READ);){
                ByteBuffer trailer = StoreIO.readNBytes(channel, 32, channel.size() - 32L);
                DiskStore.checkValue(8891064658374387837L, trailer.getLong(), "not in entry file format");
                DiskStore.checkValue(1L, trailer.getInt(), "unexpected store version");
                DiskStore.checkValue(DiskStore.this.appVersion, trailer.getInt(), "unexpected app version");
                int keySize = DiskStore.getNonNegativeInt(trailer);
                int metadataSize = DiskStore.getNonNegativeInt(trailer);
                long dataSize = DiskStore.getNonNegativeLong(trailer);
                DiskStore.checkValue(this.entrySize, (long)metadataSize + dataSize, "unexpected entry size");
                ByteBuffer keyAndMetadata = StoreIO.readNBytes(channel, keySize + metadataSize, dataSize);
                String key = StandardCharsets.UTF_8.decode(keyAndMetadata.limit(keySize)).toString();
                ByteBuffer metadata = keyAndMetadata.limit(keySize + metadataSize).slice().asReadOnlyBuffer();
                EntryReadResult entryReadResult = new EntryReadResult(key, metadata, dataSize);
                return entryReadResult;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long evict(int targetVersion) throws IOException {
            this.lock.lock();
            try {
                if (this.evicted || targetVersion != -1 && targetVersion != this.version) {
                    long l = -1L;
                    return l;
                }
                this.evicted = true;
                if (this.viewerCount > 0) {
                    DiskStore.isolatedDelete(this.entryFile());
                } else {
                    Files.deleteIfExists(this.entryFile());
                }
                this.discardCurrentEdit();
                long l = this.entrySize;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        void decrementViewerCount() {
            this.lock.lock();
            try {
                --this.viewerCount;
            }
            finally {
                this.lock.unlock();
            }
        }

        Path entryFile() {
            Path file = this.entryFile;
            if (file == null) {
                this.entryFile = file = DiskStore.this.directory.resolve(this.hash.toHexString() + DiskStore.ENTRY_FILE_SUFFIX);
            }
            return file;
        }

        Path tempEntryFile() {
            Path file = this.tempEntryFile;
            if (file == null) {
                this.tempEntryFile = file = DiskStore.this.directory.resolve(this.hash.toHexString() + DiskStore.TEMP_ENTRY_FILE_SUFFIX);
            }
            return file;
        }

        ExecutorService asyncChannelExecutor() {
            return ExecutorServiceAdapter.adapt(DiskStore.this.executor);
        }
    }

    private final class ConcurrentViewerIterator
    implements Iterator<Store.Viewer> {
        private final Iterator<Entry> entryIterator;
        private @Nullable Store.Viewer nextViewer;
        private @Nullable Store.Viewer currentViewer;

        ConcurrentViewerIterator() {
            this.entryIterator = DiskStore.this.entries.values().iterator();
        }

        @Override
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        public boolean hasNext() {
            return this.nextViewer != null || this.findNextViewer();
        }

        @Override
        public Store.Viewer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Store.Viewer viewer = Validate.castNonNull(this.nextViewer);
            this.nextViewer = null;
            this.currentViewer = viewer;
            return viewer;
        }

        @Override
        public void remove() {
            Store.Viewer viewer = this.currentViewer;
            Validate.requireState(viewer != null, "next() must be called before remove()");
            this.currentViewer = null;
            try {
                viewer.removeEntry();
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.WARNING, "entry removal failure", (Throwable)e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EnsuresNonNullIf(expression={"nextViewer"}, result=true)
        private boolean findNextViewer() {
            long stamp = DiskStore.this.closeLock.readLock();
            try {
                if (DiskStore.this.closed) {
                    boolean bl = false;
                    return bl;
                }
                while (this.nextViewer == null && this.entryIterator.hasNext()) {
                    Entry entry = this.entryIterator.next();
                    try {
                        Store.Viewer viewer = entry.openViewer(null);
                        if (viewer == null) continue;
                        this.nextViewer = viewer;
                        DiskStore.this.indexWriteScheduler.trySchedule();
                        boolean bl = true;
                        return bl;
                    }
                    catch (NoSuchFileException e) {
                        try {
                            DiskStore.this.removeEntry(entry, true);
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (IOException e) {
                        logger.log(System.Logger.Level.WARNING, "failed to open viewer while iterating", (Throwable)e);
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                DiskStore.this.closeLock.unlockRead(stamp);
            }
        }
    }

    private static final class DiskEditor
    implements Store.Editor {
        private final Entry entry;
        private final String key;
        private final Lock lock = new ReentrantLock();
        private ByteBuffer metadata = EMPTY_BUFFER;
        private boolean editedMetadata;
        private @MonotonicNonNull AsynchronousFileChannel lazyChannel;
        private long writtenCount;
        private boolean committed;
        private boolean closed;

        DiskEditor(Entry entry, String key) {
            this.entry = entry;
            this.key = key;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public void metadata(ByteBuffer metadata) {
            this.lock.lock();
            try {
                this.requireNotCommitted();
                this.metadata = Utils.copy(metadata).asReadOnlyBuffer();
                this.editedMetadata = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletableFuture<Integer> writeAsync(long position, ByteBuffer src) {
            AsynchronousFileChannel channel;
            this.lock.lock();
            try {
                this.requireNotCommitted();
                Validate.requireArgument(position >= 0L && position <= this.writtenCount, "position out of range: %d", position);
                if (this.closed) {
                    int fakeWritten = src.remaining();
                    src.position(src.position() + fakeWritten);
                    CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(fakeWritten);
                    return completableFuture;
                }
                channel = this.lazyChannel;
                if (channel == null) {
                    this.lazyChannel = channel = AsynchronousFileChannel.open(this.entry.tempEntryFile(), Set.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE), this.entry.asyncChannelExecutor(), new FileAttribute[0]);
                }
            }
            catch (IOException e) {
                CompletableFuture<Integer> completableFuture = CompletableFuture.failedFuture(e);
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
            return StoreIO.writeBytesAsync(channel, src, position).thenApply(written -> this.updateWrittenCount(position, (int)written));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int updateWrittenCount(long position, int written) {
            this.lock.lock();
            try {
                this.writtenCount = Math.max(this.writtenCount, position + (long)written);
                int n = written;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void commitOnClose() {
            this.lock.lock();
            try {
                this.committed = true;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            AsynchronousFileChannel channel;
            ByteBuffer newMetadata = null;
            long dataSize = -1L;
            this.lock.lock();
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                channel = this.lazyChannel;
                if (this.committed) {
                    newMetadata = this.editedMetadata ? this.metadata : null;
                    dataSize = this.writtenCount;
                }
            }
            finally {
                this.lock.unlock();
            }
            this.entry.commitEdit(this, this.key, newMetadata, channel, dataSize);
        }

        void discard() throws IOException {
            this.lock.lock();
            try {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                Utils.closeQuietly(this.lazyChannel);
                Files.deleteIfExists(this.entry.tempEntryFile());
            }
            finally {
                this.lock.unlock();
            }
        }

        private void requireNotCommitted() {
            Validate.requireState(!this.committed, "committed");
        }
    }

    private final class DiskViewer
    implements Store.Viewer {
        private final Entry entry;
        private final int entryVersion;
        private final String key;
        private final ByteBuffer metadata;
        private final AsynchronousFileChannel channel;
        private final long dataSize;
        private final AtomicBoolean closed = new AtomicBoolean();

        DiskViewer(Entry entry, int entryVersion, String key, ByteBuffer metadata, AsynchronousFileChannel channel, long dataSize) {
            this.entry = entry;
            this.entryVersion = entryVersion;
            this.key = key;
            this.metadata = metadata;
            this.channel = channel;
            this.dataSize = dataSize;
        }

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public ByteBuffer metadata() {
            return this.metadata.duplicate();
        }

        @Override
        public CompletableFuture<Integer> readAsync(long position, ByteBuffer dst) {
            Validate.requireArgument(position >= 0L, "negative position: %d", position);
            Objects.requireNonNull(dst);
            long availableBytes = this.dataSize - position;
            if (availableBytes <= 0L) {
                return CompletableFuture.completedFuture(-1);
            }
            int toRead = (int)Math.min(availableBytes, (long)dst.remaining());
            int originalLimit = dst.limit();
            dst.limit(dst.position() + toRead);
            return ((CompletableFuture)StoreIO.readBytesAsync(this.channel, dst, position).thenRun(() -> dst.limit(originalLimit))).thenApply(__ -> toRead);
        }

        @Override
        public long dataSize() {
            return this.dataSize;
        }

        @Override
        public long entrySize() {
            return (long)this.metadata.remaining() + this.dataSize;
        }

        @Override
        public @Nullable Store.Editor edit() throws IOException {
            return this.entry.newEditor(this.key(), this.entryVersion);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeEntry() throws IOException {
            long stamp = DiskStore.this.closeLock.readLock();
            try {
                DiskStore.this.requireNotClosed();
                boolean bl = DiskStore.this.removeEntry(this.entry, true, this.entryVersion);
                return bl;
            }
            finally {
                DiskStore.this.closeLock.unlockRead(stamp);
            }
        }

        @Override
        public void close() {
            Utils.closeQuietly(this.channel);
            if (this.closed.compareAndSet(false, true)) {
                this.entry.decrementViewerCount();
            }
        }
    }

    private static final class EntryReadResult {
        final String key;
        final ByteBuffer metadata;
        final long dataSize;

        EntryReadResult(String key, ByteBuffer metadata, long dataSize) {
            this.key = key;
            this.metadata = metadata;
            this.dataSize = dataSize;
        }
    }
}

