/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.cache;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Store
extends AutoCloseable,
Flushable {
    public long maxSize();

    public Optional<Executor> executor();

    public void initialize() throws IOException;

    public CompletableFuture<Void> initializeAsync();

    public @Nullable Viewer view(String var1) throws IOException;

    public @Nullable Editor edit(String var1) throws IOException;

    public Iterator<Viewer> iterator() throws IOException;

    public boolean remove(String var1) throws IOException;

    public void clear() throws IOException;

    public long size() throws IOException;

    public void dispose() throws IOException;

    @Override
    public void close() throws IOException;

    @Override
    public void flush() throws IOException;

    public static interface Editor
    extends Closeable {
        public String key();

        public void metadata(ByteBuffer var1);

        public CompletableFuture<Integer> writeAsync(long var1, ByteBuffer var3);

        public void commitOnClose();

        @Override
        public void close() throws IOException;
    }

    public static interface Viewer
    extends Closeable {
        public String key();

        public ByteBuffer metadata();

        public CompletableFuture<Integer> readAsync(long var1, ByteBuffer var3);

        public long dataSize();

        public long entrySize();

        public @Nullable Editor edit() throws IOException;

        public boolean removeEntry() throws IOException;

        @Override
        public void close();
    }
}

