/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;

public final class SerialExecutor
implements Executor {
    private static final int DRAIN_COUNT_BITS = 60;
    private static final long DRAIN_COUNT_MASK = 0xFFFFFFFFFFFFFFFL;
    private static final long SUBMITTED = 0x1000000000000000L;
    private static final long RUNNING = 0x2000000000000000L;
    private static final long KEEP_ALIVE = 0x4000000000000000L;
    private static final long SHUTDOWN = Long.MIN_VALUE;
    private static final VarHandle SYNC;
    private final Executor delegate;
    private final ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private volatile long sync;

    public SerialExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable command) {
        long s2;
        boolean drainIsIdle;
        Objects.requireNonNull(command);
        if ((this.sync & Long.MIN_VALUE) != 0L) {
            throw new RejectedExecutionException(command.toString());
        }
        RunnableDecorator task = new RunnableDecorator(command);
        this.taskQueue.offer(task);
        do {
            boolean bl = drainIsIdle = ((s2 = this.sync) & 0x3000000000000000L) == 0L;
        } while (!drainIsIdle && !SYNC.compareAndSet(this, s2, s2 | 0x4000000000000000L));
        if (drainIsIdle) {
            try {
                this.delegate.execute(this::drainTaskQueue);
                SYNC.compareAndSet(this, s2, s2 | 0x1000000000000000L);
            }
            catch (RejectedExecutionException e) {
                this.taskQueue.remove(task);
                throw e;
            }
        }
    }

    public void shutdown() {
        SYNC.getAndBitwiseOr(this, Long.MIN_VALUE);
    }

    private void drainTaskQueue() {
        if (!this.acquireRun()) {
            return;
        }
        while (true) {
            long unsetBits;
            Runnable task;
            if ((task = this.taskQueue.poll()) != null) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    SYNC.getAndBitwiseAnd(this, -8070450532247928833L);
                    ForkJoinPool.commonPool().execute(() -> this.execute(() -> {}));
                    throw t;
                }
            }
            long s2 = this.sync;
            long l = unsetBits = (s2 & 0x4000000000000000L) != 0L ? 0x4000000000000000L : 0x3000000000000000L;
            if (SYNC.compareAndSet(this, s2, SerialExecutor.incrementDrainCount(s2) & (unsetBits ^ 0xFFFFFFFFFFFFFFFFL)) && (unsetBits & 0x2000000000000000L) != 0L) break;
        }
    }

    private boolean acquireRun() {
        long s2 = SYNC.getAndBitwiseOr(this, 0x2000000000000000L);
        return (s2 & 0x2000000000000000L) == 0L;
    }

    private static long incrementDrainCount(long sync) {
        long count = sync & 0xFFFFFFFFFFFFFFFL;
        long incrementedCount = count + 1L & 0xFFFFFFFFFFFFFFFL;
        long stateBits = sync & 0xF000000000000000L;
        return incrementedCount | stateBits;
    }

    boolean isRunningBitSet() {
        return (this.sync & 0x2000000000000000L) != 0L;
    }

    long drainCount() {
        return this.sync & 0xFFFFFFFFFFFFFFFL;
    }

    boolean isSubmittedBitSet() {
        return (this.sync & 0x1000000000000000L) != 0L;
    }

    boolean isShutdownBitSet() {
        return (this.sync & Long.MIN_VALUE) != 0L;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            SYNC = lookup.findVarHandle(SerialExecutor.class, "sync", Long.TYPE);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class RunnableDecorator
    implements Runnable {
        private final Runnable delegate;

        RunnableDecorator(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

