/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.concurrent;

import com.github.mizosoft.methanol.internal.concurrent.Delayer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

enum SystemDelayer implements Delayer
{
    INSTANCE;


    @Override
    public Future<Void> delay(Runnable task, Duration delay, Executor executor) {
        return CompletableFuture.runAsync(task, SystemDelayer.delayedExecutor(delay, executor));
    }

    private static Executor delayedExecutor(Duration delay, Executor executor) {
        return delay.isZero() ? executor : CompletableFuture.delayedExecutor(TimeUnit.NANOSECONDS.convert(delay), TimeUnit.NANOSECONDS, executor);
    }
}

