/*
 * Decompiled with CFR 0.152.
 */
package com.github.mizosoft.methanol.internal.text;

import com.github.mizosoft.methanol.internal.Validate;
import com.github.mizosoft.methanol.internal.text.CharMatcher;
import com.github.mizosoft.methanol.internal.text.HttpCharMatchers;
import java.nio.CharBuffer;

public final class HeaderValueTokenizer {
    private final CharBuffer buffer;

    public HeaderValueTokenizer(String value2) {
        this.buffer = CharBuffer.wrap(value2);
    }

    public String nextToken() {
        this.buffer.mark();
        this.consumeCharsMatching(HttpCharMatchers.TOKEN_MATCHER);
        int tokenLimit = this.buffer.position();
        this.buffer.reset();
        Validate.requireState(this.buffer.position() < tokenLimit, "expected a token at %d", this.buffer.position());
        int originalLimit = this.buffer.limit();
        String token = this.buffer.limit(tokenLimit).toString();
        this.buffer.position(tokenLimit).limit(originalLimit);
        return token;
    }

    public String nextTokenOrQuotedString() {
        return this.consumeCharIfPresent('\"') ? this.finishQuotedString() : this.nextToken();
    }

    public void consumeCharsMatching(CharMatcher matcher) {
        while (this.buffer.hasRemaining() && matcher.matches(this.buffer.get(this.buffer.position()))) {
            this.buffer.get();
        }
    }

    public boolean consumeCharIfPresent(char c) {
        if (this.buffer.hasRemaining() && this.buffer.get(this.buffer.position()) == c) {
            this.buffer.get();
            return true;
        }
        return false;
    }

    public void requireCharacter(char c) {
        Validate.requireState(this.getCharacter() == c, "expected a %c at %d", Character.valueOf(c), this.buffer.position() - 1);
    }

    public char getCharacter() {
        Validate.requireState(this.buffer.hasRemaining(), "expected more input");
        return this.buffer.get();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public boolean consumeDelimiter(char delimiter) {
        return this.consumeDelimiter(delimiter, true);
    }

    public boolean consumeDelimiter(char delimiter, boolean requireDelimiter) {
        if (this.hasRemaining()) {
            this.consumeCharsMatching(HttpCharMatchers.OWS_MATCHER);
            if (requireDelimiter) {
                this.requireCharacter(delimiter);
            } else {
                this.consumeCharIfPresent(delimiter);
            }
            do {
                this.consumeCharsMatching(HttpCharMatchers.OWS_MATCHER);
            } while (this.consumeCharIfPresent(delimiter));
        }
        return this.hasRemaining();
    }

    private String finishQuotedString() {
        StringBuilder unescaped = new StringBuilder();
        while (!this.consumeCharIfPresent('\"')) {
            char c = this.getCharacter();
            Validate.requireArgument(HttpCharMatchers.QUOTED_TEXT_MATCHER.matches(c) || c == '\\', "illegal char %#x in a quoted-string", c);
            if (c == '\\') {
                c = this.getCharacter();
                Validate.requireArgument(HttpCharMatchers.QUOTED_PAIR_MATCHER.matches(c), "illegal char %#x in a quoted-pair", c);
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }
}

