/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

import com.phono.srtplight.LogFace;

public class Log {
    public static final int ALL = 9;
    public static final int VERB = 5;
    public static final int DEBUG = 4;
    public static final int INFO = 3;
    public static final int WARN = 2;
    public static final int ERROR = 1;
    public static int NONE = 0;
    private static int _level = 1;
    private static LogFace __logger;
    private static String[] levels;

    private static LogFace mkDefaultLogger() {
        return new LogFace(){

            @Override
            public void e(String message) {
                System.out.println(message);
            }

            @Override
            public void d(String message) {
                System.out.println(message);
            }

            @Override
            public void w(String message) {
                System.out.println(message);
            }

            @Override
            public void v(String message) {
                System.out.println(message);
            }

            @Override
            public void i(String message) {
                System.out.println(message);
            }
        };
    }

    private Log() {
    }

    public static void setLevel(int level) {
        _level = level;
    }

    public static void setLogger(LogFace logger) {
        __logger = logger;
    }

    public static int getLevel() {
        return _level;
    }

    public static void error(String string) {
        if (_level >= 1) {
            Log.log(1, string);
        }
    }

    public static void warn(String string) {
        if (_level >= 2) {
            Log.log(2, string);
        }
    }

    public static void info(String string) {
        if (_level >= 3) {
            Log.log(3, string);
        }
    }

    public static void debug(String string) {
        if (_level >= 4) {
            Log.log(4, string);
        }
    }

    public static void verb(String string) {
        if (_level >= 5) {
            Log.log(5, string);
        }
    }

    public static void where() {
        Exception x = new Exception("Called From");
        x.printStackTrace();
    }

    private static void log(int level, String string) {
        if (__logger == null) {
            __logger = Log.mkDefaultLogger();
        }
        String message = (level > 0 && level <= 5 ? levels[level] : "") + ": " + System.currentTimeMillis() + " " + Thread.currentThread().getName() + "->" + string;
        switch (level) {
            case 1: {
                __logger.e(message);
                break;
            }
            case 4: {
                __logger.d(message);
                break;
            }
            case 2: {
                __logger.w(message);
                break;
            }
            case 5: {
                __logger.v(message);
                break;
            }
            case 3: {
                __logger.i(message);
            }
        }
    }

    static {
        levels = new String[]{"NONE", "ERROR", "WARN", "INFO", "DEBUG", "VERB"};
    }
}

