/*
 * Decompiled with CFR 0.152.
 */
package com.phono.srtplight;

import com.phono.srtplight.BitUtils;
import com.phono.srtplight.InvalidRTCPPacketException;
import com.phono.srtplight.Log;
import com.phono.srtplight.SRTPProtocolImpl;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class RTCP {
    static final int SR = 200;
    static final int RR = 201;
    static final int SDES = 202;
    static final int BYE = 203;
    static final int RTPFB = 205;
    static final int PSFB = 206;
    protected char pt;
    protected long ssrc;

    void addBody(ByteBuffer bb) {
        int pad = 0;
        int rc = this.getRC();
        int llen = this.estimateBodyLength();
        byte[] head = new byte[4];
        BitUtils.copyBits(2, 2, head, 0);
        BitUtils.copyBits(pad, 1, head, 2);
        BitUtils.copyBits(rc, 5, head, 3);
        BitUtils.copyBits(this.pt, 8, head, 8);
        BitUtils.copyBits(llen, 16, head, 16);
        bb.put(head);
        bb.putInt((int)this.ssrc);
    }

    public static RTCP mkRTCP(ByteBuffer bb) throws InvalidRTCPPacketException {
        RTCP ret = null;
        int begin = bb.position();
        char fh = bb.getChar();
        int v = (fh & 0xC000) >>> 14;
        int p = (fh & 0x2000) >>> 13;
        int rc = (fh & 0x1F00) >>> 8;
        char lpt = (char)(fh & 0xFF);
        char length = bb.getChar();
        Log.verb("Have RTCP pkt with v=" + v + " p=" + p + " rc=" + rc + " pt=" + lpt + " lenght=" + length);
        if (v != 2) {
            throw new InvalidRTCPPacketException("version must be 2");
        }
        int offset = length * 4;
        switch (lpt) {
            case '\u00c8': {
                ret = new SenderReport(bb, rc, length);
                break;
            }
            case '\u00c9': {
                ret = new ReceiverReport(bb, rc, length);
                break;
            }
            case '\u00ca': {
                ret = new SDES(bb, rc, length);
                break;
            }
            case '\u00cb': {
                ret = new BYE(bb, rc, length);
                break;
            }
            case '\u00cd': {
                ret = new RTPFB(bb, rc, length);
                break;
            }
            case '\u00ce': {
                ret = new PSFB(bb, rc, length);
                break;
            }
            default: {
                ret = new RTCP();
                Log.debug("Ignoring unknown RTCP type =" + lpt);
            }
        }
        ((Buffer)bb).position(begin + offset + 4);
        return ret;
    }

    public static void main(String[] args) {
        byte[][] tests;
        Log.setLevel(9);
        byte[] sr = new byte[]{-128, -56, 0, 6, 80, -10, -72, -65, -35, 98, 71, -51, 75, 67, -107, -127, 39, -101, -54, -17, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] rr = new byte[]{-127, -55, 0, 7, -85, 54, -51, 25, 46, 15, 54, 20, -96, -5, -16, -27, 90, 80, 11, -64, 26, -55, 82, -68, 97, 54, 87, -43, 95, 25, 0, -92};
        byte[] fb = new byte[]{-113, -51, 0, 6, 117, -24, 29, -113, 4, -83, -96, -14, -38, 89, 38, 37, 48, -18, 110, -97, 113, 54, -126, 97, -5, -28, 18, -128};
        for (byte[] t : tests = new byte[][]{sr, rr, fb}) {
            ByteBuffer p = ByteBuffer.wrap(t);
            try {
                RTCP r = RTCP.mkRTCP(p);
                if (r != null) {
                    Log.verb(r.toString());
                    continue;
                }
                Log.error("r is null");
            }
            catch (InvalidRTCPPacketException irp) {
                Log.error(irp.getMessage());
                irp.printStackTrace();
            }
        }
        SenderReport sro = RTCP.mkSenderReport();
        sro.setSSRC(1358346431L);
        sro.setNTPStamp(-2494352296553245311L);
        sro.setRTPStamp(664521455L);
        sro.setSenderPackets(0L);
        sro.setSenderOctets(0L);
        int ebl = sro.estimateBodyLength();
        ByteBuffer bbo = ByteBuffer.allocate(4 * (ebl + 1));
        sro.addBody(bbo);
        byte[] pky = bbo.array();
        Log.verb("sro " + sro);
        Log.verb("sro " + SRTPProtocolImpl.getHex(pky));
        for (int i = 0; i < sr.length; ++i) {
            if (pky[i] == sr[i]) continue;
            Log.error("packets differ at:" + i);
        }
        ReceiverReport rro = RTCP.mkReceiverReport();
        ebl = sro.estimateBodyLength();
        bbo = ByteBuffer.allocate(4 * (ebl + 1));
        rro.addBody(bbo);
        pky = bbo.array();
        Log.verb("rro " + rro);
        Log.verb("rro " + SRTPProtocolImpl.getHex(pky));
        PSFB p = RTCP.mkPSFB();
        p.setSSRC(305419896L);
        p.setMssrc(591751049L);
        p.setSssrc(878082202L);
        p.setFmt(1);
        p.setFci(new byte[0]);
        int pl = p.estimateBodyLength();
        bbo = ByteBuffer.allocate(4 * (pl + 1));
        p.addBody(bbo);
        byte[] pa = bbo.array();
        Log.info("PSFB " + p);
        Log.info("PSFB " + SRTPProtocolImpl.getHex(pa));
        try {
            bbo.flip();
            RTCP p2 = RTCP.mkRTCP(bbo);
            Log.info("PSFB " + p2.toString());
        }
        catch (Exception x) {
            Log.warn("cant parse PSFB");
            x.printStackTrace();
        }
    }

    public static SenderReport mkSenderReport() {
        SenderReport ret = new SenderReport();
        return ret;
    }

    static ReceiverReport mkReceiverReport() {
        ReceiverReport ret = new ReceiverReport();
        return ret;
    }

    static PSFB mkPSFB() {
        PSFB ret = new PSFB();
        return ret;
    }

    int estimateBodyLength() {
        return 1;
    }

    public void setSSRC(long s2) {
        this.ssrc = s2;
    }

    int getRC() {
        return 0;
    }

    public class ReportBlock {
        long ssrc;
        int frac;
        int cumulost;
        long highestSeqRcvd;
        long iaJitter;
        long lsr;
        long dlsr;

        ReportBlock(ByteBuffer bb) {
            this.ssrc = bb.getInt();
            char c3 = bb.getChar();
            char c4 = bb.getChar();
            this.frac = c3 & 0xFF;
            this.cumulost = c4 + ((c3 & 0xFF) << 16);
            this.highestSeqRcvd = bb.getInt();
            this.iaJitter = bb.getInt();
            this.lsr = bb.getInt();
            this.dlsr = bb.getInt();
        }

        public long getSsrc() {
            return this.ssrc;
        }

        public int getFrac() {
            return this.frac;
        }

        public int getCumulost() {
            return this.cumulost;
        }

        public long getHighestSeqRcvd() {
            return this.highestSeqRcvd;
        }

        public long getIaJitter() {
            return this.iaJitter;
        }

        public long getLsr() {
            return this.lsr;
        }

        public long getDlsr() {
            return this.dlsr;
        }

        public String toString() {
            return "ReportBlock for ssrc=" + this.ssrc + " frac=" + this.frac + " cumulost=" + this.cumulost + " highestSeqRcvd=" + this.highestSeqRcvd + " iaJitter=" + this.iaJitter + " lsr=" + this.lsr + " dlsr=" + this.dlsr;
        }

        private void addBody(ByteBuffer bb) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class RTPFB
    extends FB {
        public RTPFB(ByteBuffer bb, int rc, int length) throws InvalidRTCPPacketException {
            super(bb, rc, length);
        }

        @Override
        public String toString() {
            String ret = "RTCP RTPFB: sssrc=" + this.sssrc + " mssrc=" + this.mssrc + " fmt=" + this.fmt + " fci length=" + this.fci.length;
            return ret;
        }

        public List<Long> getSeqList() {
            ArrayList<Long> ret = new ArrayList<Long>();
            ByteBuffer bb = ByteBuffer.wrap(this.fci);
            long lost = bb.getChar();
            ret.add(lost);
            long bits = bb.getChar();
            for (int i = 0; i < 16; ++i) {
                long bit = bits & 1L;
                if (bit != 0L) {
                    ret.add(lost + (long)i + 1L);
                }
                bits >>= 1;
            }
            return ret;
        }
    }

    public static class PSFB
    extends FB {
        public PSFB(ByteBuffer bb, int rc, int length) throws InvalidRTCPPacketException {
            super(bb, rc, length);
        }

        protected PSFB() {
            this.pt = (char)206;
        }

        @Override
        public String toString() {
            String ret = "RTCP PSFB: sssrc=" + this.sssrc + " mssrc=" + this.mssrc + " fmt=" + this.fmt + " fci length=" + this.fci.length;
            return ret;
        }

        @Override
        public void addBody(ByteBuffer bb) {
            super.addBody(bb);
        }

        @Override
        int estimateBodyLength() {
            return super.estimateBodyLength();
        }
    }

    public static class FB
    extends RTCP {
        protected long sssrc;
        protected long mssrc;
        protected int fmt;
        protected byte[] fci;

        public FB(ByteBuffer bb, int rc, int length) throws InvalidRTCPPacketException {
            if (length < 2) {
                throw new InvalidRTCPPacketException("length expected at least 2 got " + length);
            }
            this.sssrc = bb.getInt();
            this.mssrc = bb.getInt();
            this.fmt = rc;
            this.fci = new byte[(length - 2) * 4];
            bb.get(this.fci);
        }

        protected FB() {
        }

        @Override
        public void addBody(ByteBuffer bb) {
            super.addBody(bb);
            bb.putInt((int)this.mssrc);
            bb.put(this.fci);
        }

        public long getSssrc() {
            return this.sssrc;
        }

        public long getMssrc() {
            return this.mssrc;
        }

        public int getFmt() {
            return this.fmt;
        }

        @Override
        public int getRC() {
            return this.fmt;
        }

        public byte[] getFci() {
            return this.fci;
        }

        public String toString() {
            String ret = "RTCP FB: sssrc=" + this.sssrc + " mssrc=" + this.mssrc + " fmt=" + this.fmt + " fci length=" + this.fci.length;
            return ret;
        }

        @Override
        int estimateBodyLength() {
            return this.fci.length / 4 + 2;
        }

        public void setSssrc(long sssrc) {
            this.sssrc = sssrc;
        }

        public void setMssrc(long mssrc) {
            this.mssrc = mssrc;
        }

        public void setFmt(int fmt) {
            this.fmt = fmt;
        }

        public void setFci(byte[] fci) {
            this.fci = fci;
        }
    }

    public static class BYE
    extends RTCP {
        public BYE(ByteBuffer bb, int rc, int length) {
        }
    }

    public static class SDES
    extends RTCP {
        public SDES(ByteBuffer bb, int rc, int length) {
        }
    }

    public static class ReceiverReport
    extends RTCP {
        long ssrc;
        ArrayList<ReportBlock> reports;

        public ReceiverReport(ByteBuffer bb, int rc, int length) throws InvalidRTCPPacketException {
            int expected = 1 + 6 * rc;
            Log.verb("length expected=" + expected + " got length=" + length + " rc = " + rc);
            if (length != expected) {
                throw new InvalidRTCPPacketException("length mismatch expected=" + expected + " got length=" + length);
            }
            this.ssrc = bb.getInt();
            this.reports = new ArrayList();
            for (int i = 0; i < rc; ++i) {
                ReportBlock rblock = new ReportBlock(bb);
                this.reports.add(rblock);
            }
        }

        @Override
        public void addBody(ByteBuffer bb) {
            super.addBody(bb);
        }

        @Override
        int getRC() {
            return this.reports.size();
        }

        @Override
        int estimateBodyLength() {
            return 6 + 6 * this.reports.size();
        }

        private ReceiverReport() {
            this.reports = new ArrayList();
            this.pt = (char)201;
        }

        public ReportBlock[] getReports() {
            ReportBlock[] ret = new ReportBlock[this.reports.size()];
            for (int i = 0; i < this.reports.size(); ++i) {
                ret[i] = this.reports.get(i);
            }
            return ret;
        }

        public String toString() {
            String ret = "RTCP RR: ssrc=" + this.ssrc;
            for (ReportBlock b : this.reports) {
                ret = ret + "\n\t" + b.toString();
            }
            return ret;
        }
    }

    static class SenderReport
    extends RTCP {
        long ntpstamp;
        long rtpstamp;
        long senderPkts;
        long senderOcts;
        ArrayList<ReportBlock> reports;

        public void setNTPStamp(long s2) {
            this.ntpstamp = s2;
        }

        public void setRTPStamp(long s2) {
            this.rtpstamp = s2;
        }

        public void setSenderPackets(long s2) {
            this.senderPkts = s2;
        }

        public void setSenderOctets(long s2) {
            this.senderOcts = s2;
        }

        public void addReport(ReportBlock b) {
            this.reports.add(b);
        }

        @Override
        public void addBody(ByteBuffer bb) {
            super.addBody(bb);
            bb.putLong(this.ntpstamp);
            bb.putInt((int)this.rtpstamp);
            bb.putInt((int)this.senderPkts);
            bb.putInt((int)this.senderOcts);
            for (ReportBlock r : this.reports) {
                r.addBody(bb);
            }
        }

        @Override
        int getRC() {
            return this.reports.size();
        }

        @Override
        int estimateBodyLength() {
            return 6 + 6 * this.reports.size();
        }

        public SenderReport(ByteBuffer bb, int rc, int length) throws InvalidRTCPPacketException {
            int expected = 6 + 6 * rc;
            if (length != expected) {
                throw new InvalidRTCPPacketException("length mismatch expected=" + expected + " got length=" + length);
            }
            this.ssrc = bb.getInt();
            this.ntpstamp = bb.getLong();
            this.rtpstamp = bb.getInt();
            this.senderPkts = bb.getInt();
            this.senderOcts = bb.getInt();
            this.reports = new ArrayList();
            for (int i = 0; i < rc; ++i) {
                ReportBlock rblock = new ReportBlock(bb);
                this.reports.add(rblock);
            }
        }

        private SenderReport() {
            this.reports = new ArrayList();
            this.pt = (char)200;
        }

        public String toString() {
            String ret = "RTCP SR: ssrc=" + this.ssrc + " ntpstamp=" + this.ntpstamp + " rtpstamp=" + this.rtpstamp + " senderPkts=" + this.senderPkts + " senderOcts=" + this.senderOcts;
            for (ReportBlock b : this.reports) {
                ret = ret + "\n\t" + b.toString();
            }
            return ret;
        }
    }
}

